/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.libs.flac.encode;

import java.io.IOException;
import org.lolicode.nekomusiccli.libs.flac.encode.BitOutputStream;
import org.lolicode.nekomusiccli.libs.flac.encode.SizeEstimate;
import org.lolicode.nekomusiccli.libs.flac.encode.SubframeEncoder;

final class VerbatimEncoder
extends SubframeEncoder {
    public static SizeEstimate<SubframeEncoder> computeBest(long[] samples, int shift, int depth) {
        VerbatimEncoder enc = new VerbatimEncoder(samples, shift, depth);
        long size = 8 + shift + samples.length * depth;
        return new SizeEstimate<SubframeEncoder>(size, enc);
    }

    public VerbatimEncoder(long[] samples, int shift, int depth) {
        super(shift, depth);
    }

    @Override
    public void encode(long[] samples, BitOutputStream out) throws IOException {
        this.writeTypeAndShift(1, out);
        for (long val : samples) {
            this.writeRawSample(val >> this.sampleShift, out);
        }
    }
}

