/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.libs.lrcparser.parser;

import java.io.Serializable;
import java.util.Comparator;

public class Sentence
implements Serializable {
    private static final long serialVersionUID = -7463622619946509670L;
    private long fromTime = -1L;
    private long toTime = -1L;
    private String content = "";
    private int index = -1;

    public Sentence(long fromTime) {
        this("", fromTime, -1L);
    }

    public Sentence(String content) {
        this(content, -1L, -1L);
    }

    public Sentence(String content, long fromTime) {
        this(content, fromTime, -1L);
    }

    public Sentence(String content, long fromTime, long toTime) {
        this.content = content;
        this.fromTime = fromTime;
        this.toTime = toTime;
    }

    public String getContent() {
        return this.content;
    }

    public long getDuring() {
        return this.toTime - this.fromTime + 1L;
    }

    public long getFromTime() {
        return this.fromTime;
    }

    public long getToTime() {
        return this.toTime;
    }

    public boolean isInTime(long time) {
        if (time < 0L) {
            return true;
        }
        boolean fromTimeCheck = this.fromTime == -1L || time >= this.fromTime;
        boolean toTimeCheck = this.toTime == -1L || time <= this.toTime;
        return fromTimeCheck && toTimeCheck;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setFromTime(long fromTime) {
        this.fromTime = fromTime;
    }

    public void setToTime(long toTime) {
        this.toTime = toTime;
    }

    public String toString() {
        return "{index:" + this.index + "|" + this.fromTime + "(" + this.content + ")" + this.toTime + "}";
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public static class SentenceComparator
    implements Comparator<Sentence> {
        @Override
        public int compare(Sentence sent1, Sentence sent2) {
            return (int)(sent1.getFromTime() - sent2.getFromTime());
        }
    }
}

