/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.music;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.InterruptedIOException;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import org.lolicode.nekomusiccli.NekoMusicClient;
import org.lolicode.nekomusiccli.config.CustomSoundCategory;
import org.lolicode.nekomusiccli.hud.HudUtils;
import org.lolicode.nekomusiccli.music.MusicObj;
import org.lolicode.nekomusiccli.music.player.AudioPlayer;
import org.lolicode.nekomusiccli.utils.Alert;
import org.lolicode.nekomusiccli.utils.InstanceLock;

public class MusicManager {
    private final AtomicReference<AudioPlayer> playerRef = new AtomicReference();
    private volatile boolean isPlaying = false;
    public volatile MusicObj currentMusic = null;
    private final ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("NekoMusic Client Music-Manager").build());
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("NekoMusic Client Music-Manager-Scheduler").build());
    private final BlockingDeque<Future<?>> futures = new LinkedBlockingDeque();
    private volatile boolean isDisposed = false;

    public synchronized void play(MusicObj music) {
        if (this.isDisposed) {
            NekoMusicClient.LOGGER.error("MusicManager is disposed");
            Alert.error("player.nekomusic.manager.disposed");
            return;
        }
        if (this.isPlaying) {
            this.stop();
        }
        if (music == null || music.url == null || music.url.isBlank()) {
            NekoMusicClient.LOGGER.error("Music is null");
            Alert.error("player.nekomusic.music.null");
            return;
        }
        if (NekoMusicClient.config.singleInstance && !InstanceLock.checkLock()) {
            NekoMusicClient.LOGGER.info("NekoMusic: Another instance is running, skip playing music");
            return;
        }
        MusicManager.stopVanillaMusic();
        this.isPlaying = true;
        this.currentMusic = music;
        if (music.seekTo < 0L || music.seekTo * 1000L > music.dt) {
            music.seekTo = 0L;
            NekoMusicClient.LOGGER.warn("Invalid seekTo value, set to 0. Is the server sending wrong data?");
        }
        this.futures.add(this.executor.submit(() -> {
            try {
                if (NekoMusicClient.hudUtils == null) {
                    NekoMusicClient.hudUtils = new HudUtils();
                }
                NekoMusicClient.hudUtils.setMusic(music);
            }
            catch (InterruptedIOException e) {
                return;
            }
            catch (Exception e) {
                NekoMusicClient.LOGGER.error("Failed to update hud", (Throwable)e);
                Alert.error("hud.nekomusic.update.failed");
            }
            try {
                AudioPlayer player = AudioPlayer.getAudioPlayerStream(music);
                if (player == null) {
                    NekoMusicClient.LOGGER.info("Failed to stream audio, perhaps the server doesn't support it, or the format is not supported");
                    Alert.info("player.nekomusic.streaming.unavailable");
                    player = AudioPlayer.getAudioPlayerNoStream(music);
                }
                if (player == null) {
                    throw new RuntimeException("Failed to get audio player");
                }
                AudioPlayer oldPlayer = this.playerRef.getAndSet(player);
                if (oldPlayer != null) {
                    oldPlayer.stop();
                }
                if (NekoMusicClient.hudUtils != null) {
                    NekoMusicClient.hudUtils.startLyric(music.seekTo);
                }
                player.playFrom(music.seekTo);
                player.setGain(MusicManager.getVolume());
                if (music.dt > 0L) {
                    this.futures.add(this.scheduler.schedule(() -> {
                        if (this.isPlaying) {
                            this.stop();
                        }
                    }, music.seekTo > 0L ? music.dt - music.seekTo * 1000L : music.dt, TimeUnit.MILLISECONDS));
                }
            }
            catch (InterruptedIOException player) {
            }
            catch (Exception e) {
                NekoMusicClient.LOGGER.error("Failed to play music", (Throwable)e);
                Alert.error("player.nekomusic.play.failed");
                this.stop();
            }
        }));
    }

    public synchronized void stop() {
        AudioPlayer player = this.playerRef.getAndSet(null);
        this.futures.forEach(f -> {
            if (!f.isDone()) {
                f.cancel(true);
            }
        });
        this.futures.clear();
        if (player != null) {
            player.stop();
        }
        this.isPlaying = false;
        if (this.currentMusic != null) {
            this.currentMusic = null;
        }
        if (NekoMusicClient.hudUtils != null) {
            NekoMusicClient.hudUtils.stopCurrentMusic();
        }
    }

    public synchronized void dispose() {
        this.stop();
        this.executor.shutdownNow();
        this.scheduler.shutdownNow();
        this.isDisposed = true;
    }

    public static float getVolume() {
        if (NekoMusicClient.pvAddon != null) {
            return NekoMusicClient.pvAddon.getVolume();
        }
        return class_310.method_1551().field_1690.method_71978(CustomSoundCategory.NEKOMUSIC);
    }

    public void setVolume(float volume) {
        AudioPlayer player = this.playerRef.get();
        if (player != null) {
            try {
                player.setGain(volume);
            }
            catch (Exception e) {
                NekoMusicClient.LOGGER.error("Failed to set volume", (Throwable)e);
                Alert.error("volume.nekomusic.set.failed");
            }
        }
    }

    public static void stopVanillaMusic() {
        if (NekoMusicClient.config.blockMusic) {
            class_310.method_1551().method_1483().method_4875(null, class_3419.field_15253);
        }
        if (NekoMusicClient.config.blockRecords) {
            class_310.method_1551().method_1483().method_4875(null, class_3419.field_15247);
        }
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }
}

