/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.music.player;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.SampleBuffer;
import org.lolicode.nekomusiccli.libs.flac.decode.DataFormatException;
import org.lolicode.nekomusiccli.music.player.Decoder;

public class Mp3Decoder
extends javazoom.jl.decoder.Decoder
implements Decoder {
    private final Bitstream bitstream;
    private volatile boolean closed = false;
    private final int sampleRate;

    public Mp3Decoder(InputStream inputStream) throws DataFormatException, BitstreamException {
        this.bitstream = new Bitstream(inputStream);
        Header header = null;
        try {
            header = this.bitstream.readFrame();
            if (header == null) {
                throw new DataFormatException("Failed to read header");
            }
            this.sampleRate = header.frequency();
        }
        catch (BitstreamException e) {
            this.bitstream.closeFrame();
            this.bitstream.close();
            throw e;
        }
        this.bitstream.closeFrame();
    }

    @Override
    public synchronized void seek(long pos) throws IOException {
        if (this.closed) {
            return;
        }
        long frames = pos * (long)this.sampleRate / 1152L;
        int i = 0;
        while ((long)i < frames) {
            try {
                this.bitstream.readFrame();
            }
            catch (BitstreamException e) {
                throw new IOException(e);
            }
            this.bitstream.closeFrame();
            ++i;
        }
    }

    @Override
    public synchronized void close() throws Exception {
        this.bitstream.close();
        this.closed = true;
    }

    @Override
    public synchronized ByteBuffer decodeFrame() throws Exception {
        if (this.closed) {
            return null;
        }
        Header frame = this.bitstream.readFrame();
        if (frame == null) {
            return null;
        }
        SampleBuffer buffer = (SampleBuffer)super.decodeFrame(frame, this.bitstream);
        ByteBuffer byteBuffer = Decoder.getByteBuffer(buffer.getBuffer());
        this.bitstream.closeFrame();
        return byteBuffer;
    }
}

