/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.music.player;

import java.io.BufferedInputStream;
import java.io.IOException;
import javazoom.jl.decoder.BitstreamException;
import okhttp3.Response;
import org.lolicode.nekomusiccli.NekoMusicClient;
import org.lolicode.nekomusiccli.music.player.AudioPlayer;
import org.lolicode.nekomusiccli.music.player.Decoder;

public class ResponseAudioPlayer
extends AudioPlayer {
    private final BufferedInputStream stream;
    private final Response response;

    public ResponseAudioPlayer() {
        throw new UnsupportedOperationException("This class can't be directly instantiated");
    }

    private ResponseAudioPlayer(BufferedInputStream stream, Decoder decoder, Response response) {
        this.stream = stream;
        this.decoder = decoder;
        this.response = response;
    }

    public static ResponseAudioPlayer getMp3OrFlacAudioPlayer(Response resp, boolean isMp3) throws Exception {
        Decoder decoder = null;
        BufferedInputStream stream = new BufferedInputStream(resp.body().byteStream());
        try {
            decoder = isMp3 ? Decoder.getMp3Decoder(stream) : Decoder.getFlacDecoder(stream);
        }
        catch (IOException | RuntimeException | BitstreamException e) {
            if (decoder != null) {
                decoder.close();
            }
            stream.close();
            return null;
        }
        ResponseAudioPlayer player = new ResponseAudioPlayer(stream, decoder, resp);
        player.decoder = decoder;
        return player;
    }

    @Override
    public synchronized void cleanup() {
        if (this.cleanupDone) {
            return;
        }
        super.cleanup();
        try {
            this.stream.close();
        }
        catch (IOException e) {
            NekoMusicClient.LOGGER.error("Failed to close the audio stream", (Throwable)e);
        }
        try {
            this.response.close();
        }
        catch (Exception e) {
            NekoMusicClient.LOGGER.error("Failed to close the response", (Throwable)e);
        }
        this.cleanupDone = true;
    }
}

