/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.utils;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.lolicode.nekomusiccli.NekoMusicClient;

public class InstanceLock {
    private static final Path LOCK_FILE = Path.of(System.getProperty("java.io.tmpdir"), "nekomusiccli.lock");
    private static FileChannel lockfile = null;
    private static FileLock lock = null;

    private static synchronized void lock() throws IOException {
        lockfile = FileChannel.open(LOCK_FILE, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        lock = lockfile.tryLock();
        if (lock == null) {
            throw new IOException("Failed to lock instance");
        }
    }

    private static synchronized void unlock() throws IOException {
        if (lock != null) {
            lock.release();
        }
        if (lockfile != null) {
            lockfile.close();
        }
        lock = null;
        lockfile = null;
    }

    public static boolean checkLock() {
        if (lockfile != null && lock != null) {
            return true;
        }
        try {
            InstanceLock.lock();
            return true;
        }
        catch (OverlappingFileLockException e) {
            NekoMusicClient.LOGGER.warn("NekoMusic: Instance lock is already held by another thread: ", (Throwable)e);
            return true;
        }
        catch (IOException e) {
            NekoMusicClient.LOGGER.info("NekoMusic: Failed to lock instance, another instance is running");
            return false;
        }
    }

    public static void release() {
        try {
            InstanceLock.unlock();
        }
        catch (IOException e) {
            NekoMusicClient.LOGGER.error("Failed to release lock: ", (Throwable)e);
        }
    }
}

