/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.cache;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_310;
import okhttp3.Cache;
import org.lolicode.nekomusiccli.NekoMusicClient;
import org.lolicode.nekomusiccli.config.ModConfig;

public class CacheUtils {
    private static final String IMG_CACHE_FILE = "image.json";
    private static final String MUSIC_CACHE_FILE = "music.json";
    private static final String LOCK_FILE = "session.lock";
    private FileChannel lockfile = null;
    private FileLock lock = null;
    private final Path cachePath;
    private final Path musicPath;
    private final Path imgPath;
    private final ConcurrentHashMap<String, String> imgCacheMap;
    private final ConcurrentHashMap<String, String> musicCacheMap;
    private final boolean forceDisableCache;

    public CacheUtils(ModConfig config) {
        CacheUtils.checkCachePath(config.getCachePath());
        this.cachePath = Path.of(config.getCachePath(), new String[0]);
        this.musicPath = this.cachePath.resolve("music");
        this.imgPath = this.cachePath.resolve("img");
        try {
            this.lock();
        }
        catch (Exception e) {
            NekoMusicClient.LOGGER.error("Failed to lock cache directory: ", (Throwable)e);
            NekoMusicClient.LOGGER.error("Force disabling cache");
            this.forceDisableCache = true;
            this.imgCacheMap = null;
            this.musicCacheMap = null;
            return;
        }
        this.imgCacheMap = this.getCacheMap(IMG_CACHE_FILE);
        this.musicCacheMap = this.getCacheMap(MUSIC_CACHE_FILE);
        this.forceDisableCache = false;
    }

    public Cache getMusicCache() {
        if (this.forceDisableCache) {
            return null;
        }
        if (NekoMusicClient.config.musicCacheSize == 0) {
            return null;
        }
        return new Cache(this.musicPath.toFile(), NekoMusicClient.config.musicCacheSize == -1 ? Long.MAX_VALUE : (long)NekoMusicClient.config.musicCacheSize * 1024L * 1024L);
    }

    public Cache getImgCache() {
        if (this.forceDisableCache) {
            return null;
        }
        if (NekoMusicClient.config.imgCacheSize == 0) {
            return null;
        }
        return new Cache(this.imgPath.toFile(), NekoMusicClient.config.imgCacheSize == -1 ? Long.MAX_VALUE : (long)NekoMusicClient.config.imgCacheSize * 1024L * 1024L);
    }

    public String queryImgCache(String hash) {
        if (this.forceDisableCache) {
            return null;
        }
        return this.imgCacheMap.get(hash);
    }

    public String queryMusicCache(String hash) {
        if (this.forceDisableCache) {
            return null;
        }
        return this.musicCacheMap.get(hash);
    }

    public void updateImgCache(String hash, String url) {
        if (this.forceDisableCache) {
            return;
        }
        this.addOrReplace(this.imgCacheMap, hash, url);
    }

    public void updateMusicCache(String hash, String url) {
        if (this.forceDisableCache) {
            return;
        }
        this.addOrReplace(this.musicCacheMap, hash, url);
    }

    private void addOrReplace(Map<String, String> map, String key, String value) {
        if (map.containsKey(key)) {
            map.replace(key, value);
        } else {
            map.put(key, value);
        }
    }

    public static boolean checkCachePath(String path) {
        Path p = Path.of(path, new String[0]);
        CacheUtils.checkPath(p);
        CacheUtils.checkPath(p.resolve("music"));
        CacheUtils.checkPath(p.resolve("img"));
        return true;
    }

    private static boolean checkPath(Path path) throws RuntimeException {
        File file = path.toFile();
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("Failed to create cache directory");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Cache path is not a directory");
        }
        if (!file.canRead()) {
            throw new RuntimeException("Cache path is not readable");
        }
        if (!file.canWrite()) {
            throw new RuntimeException("Cache path is not writable");
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file.getAbsolutePath() + "/README.txt"));){
            writer.write("This is a cache directory for {}, please do not save any files here manually, as they might be deleted by the program.".replace("{}", "NekoMusic Client"));
            writer.newLine();
            writer.write("\u8fd9\u662f {} \u7684\u7f13\u5b58\u76ee\u5f55\uff0c\u8bf7\u4e0d\u8981\u624b\u52a8\u4fdd\u5b58\u4efb\u4f55\u6587\u4ef6\u5230\u8fd9\u91cc\uff0c\u56e0\u4e3a\u5b83\u4eec\u53ef\u80fd\u4f1a\u88ab\u7a0b\u5e8f\u5220\u9664\u3002".replace("{}", "NekoMusic Client"));
            writer.flush();
        }
        catch (Exception e) {
            NekoMusicClient.LOGGER.error("Failed to write test file to cache path: ", (Throwable)e);
            throw new RuntimeException("Failed to write test file to cache path, this might be caused by permission issues");
        }
        return true;
    }

    public static String getDefaultCachePath() {
        String path = class_310.method_1551().field_1697.toPath().resolve("cache").resolve("nekomusiccli").toString();
        CacheUtils.checkCachePath(path);
        return path;
    }

    private ConcurrentHashMap<String, String> getCacheMap(String fileName) {
        File file = this.cachePath.resolve(fileName).toFile();
        if (file.exists()) {
            try {
                return new ConcurrentHashMap<String, String>(CacheUtils.readCacheMap(file));
            }
            catch (JsonIOException | JsonSyntaxException | IOException | IllegalArgumentException e) {
                NekoMusicClient.LOGGER.error("Failed to read cache record: " + file.getAbsolutePath(), e);
            }
        } else {
            NekoMusicClient.LOGGER.info("Cache file {} not found, creating new one.".replace("{}", fileName));
        }
        return new ConcurrentHashMap<String, String>();
    }

    private static Map<String, String> readCacheMap(File file) throws IOException, JsonIOException, JsonSyntaxException, IllegalArgumentException {
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            Map map = (Map)NekoMusicClient.GSON.fromJson((Reader)reader, type);
            if (map != null) {
                Map map2 = map;
                return map2;
            }
            throw new IllegalArgumentException("Failed to read cache file: " + file.getName() + ", the file seems to be empty or corrupted.");
        }
    }

    private void writeCacheMap(Map<String, String> cacheMap, String cacheFile) {
        if (this.forceDisableCache) {
            return;
        }
        File file = this.cachePath.resolve(cacheFile).toFile();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            NekoMusicClient.GSON.toJson(cacheMap, (Appendable)writer);
        }
        catch (IOException e) {
            NekoMusicClient.LOGGER.error("Failed to write cache file: " + cacheFile, (Throwable)e);
        }
    }

    private synchronized void lock() {
        if (this.lockfile != null) {
            throw new RuntimeException("Cache directory already locked.");
        }
        try {
            this.lockfile = new FileOutputStream(this.cachePath.resolve(LOCK_FILE).toFile()).getChannel();
            this.lock = this.lockfile.tryLock();
            if (this.lock == null) {
                throw new RuntimeException("Failed to lock cache directory.");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized void unlock() {
        if (this.lockfile == null || this.lock == null || !this.lock.isValid()) {
            throw new RuntimeException("Cache directory not locked.");
        }
        try {
            this.lock.release();
            this.lockfile.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to unlock cache directory: ", e);
        }
        this.lock = null;
        this.lockfile = null;
    }

    public synchronized void save() {
        this.writeCacheMap(this.imgCacheMap, IMG_CACHE_FILE);
        this.writeCacheMap(this.musicCacheMap, MUSIC_CACHE_FILE);
    }

    public void close() {
        this.save();
        if (this.lockfile != null) {
            this.unlock();
        }
    }
}

