/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.config;

import java.util.ArrayList;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import org.lolicode.nekomusiccli.cache.CacheUtils;
import org.lolicode.nekomusiccli.utils.StrEnvSubstitutor;

@Config(name="nekomusiccli")
public class ModConfig
implements ConfigData {
    public boolean enabled = true;
    public boolean blockMusic = true;
    public boolean blockRecords = false;
    public boolean enableHud = true;
    public boolean enableHudInfo = true;
    public boolean enableHudList = true;
    public boolean enableHudLyric = true;
    public boolean enableHudImg = true;
    @ConfigEntry.Gui.Tooltip
    public boolean enableHudImgRotate = true;
    public int maxCharPerLineListHud = 25;
    public int maxRowListHud = 5;
    public boolean scrollListHud = false;
    public int infoX = 74;
    public int infoY = 2;
    public int listX = 2;
    public int listY = 74;
    public int lyricX = 74;
    public int lyricY = 53;
    public int imgX = 2;
    public int imgY = 2;
    public int imgSize = 70;
    public int imgRotateSpeed = 50;
    @ConfigEntry.Gui.Tooltip(count=2)
    @ConfigEntry.BoundedDiscrete(min=0L, max=255L)
    public int textOpacity = 255;
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.BoundedDiscrete(min=0L, max=255L)
    public int textColorRed = 255;
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.BoundedDiscrete(min=0L, max=255L)
    public int textColorGreen = 255;
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.BoundedDiscrete(min=0L, max=255L)
    public int textColorBlue = 255;
    @ConfigEntry.Gui.Tooltip(count=2)
    public ArrayList<String> bannedServers = new ArrayList();
    @ConfigEntry.Gui.Tooltip
    public ArrayList<BannedSong> bannedSongs = new ArrayList();
    @ConfigEntry.Category(value="advanced")
    @ConfigEntry.Gui.Tooltip(count=3)
    @ConfigEntry.Gui.RequiresRestart
    public long musicResponseSizeLimit = 0L;
    @ConfigEntry.Category(value="advanced")
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Gui.RequiresRestart
    public long imgResponseSizeLimit = 25L;
    @ConfigEntry.Category(value="advanced")
    @ConfigEntry.Gui.Tooltip
    public long imgWidthLimit = 0L;
    @ConfigEntry.Category(value="advanced")
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Gui.RequiresRestart
    public int musicCacheSize = 1024;
    @ConfigEntry.Category(value="advanced")
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Gui.RequiresRestart
    public int imgCacheSize = 100;
    @ConfigEntry.Category(value="advanced")
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Gui.RequiresRestart
    public boolean singleInstance = true;
    @ConfigEntry.Category(value="advanced")
    @ConfigEntry.Gui.Tooltip(count=3)
    @ConfigEntry.Gui.RequiresRestart
    public String cachePath = "";
    @ConfigEntry.Category(value="advanced")
    @ConfigEntry.Gui.Tooltip
    public ArrayList<String> domainWhitelist = new ArrayList();
    @ConfigEntry.Category(value="integration")
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Gui.RequiresRestart
    public boolean lowerVolumeWhenPlayingVoice = true;
    @ConfigEntry.Category(value="integration")
    @ConfigEntry.Gui.Tooltip
    public boolean useAbsoluteVolume = false;
    @ConfigEntry.Category(value="integration")
    @ConfigEntry.BoundedDiscrete(min=0L, max=100L)
    public int volumeWhenPlayingVoice = 25;

    public void validatePostLoad() throws ConfigData.ValidationException {
        if (this.maxCharPerLineListHud < 10 && this.maxCharPerLineListHud > 0) {
            this.maxCharPerLineListHud = 10;
        }
        if (this.infoX < 0) {
            this.infoX = 0;
        }
        if (this.infoY < 0) {
            this.infoY = 0;
        }
        if (this.listX < 0) {
            this.listX = 0;
        }
        if (this.listY < 0) {
            this.listY = 0;
        }
        if (this.lyricX < 0) {
            this.lyricX = 0;
        }
        if (this.lyricY < 0) {
            this.lyricY = 0;
        }
        if (this.imgX < 0) {
            this.imgX = 0;
        }
        if (this.imgY < 0) {
            this.imgY = 0;
        }
        if (this.imgSize < 0) {
            this.imgSize = 10;
        }
        if (this.musicCacheSize < -1) {
            this.musicCacheSize = -1;
        }
        if (this.imgRotateSpeed <= 0) {
            this.imgRotateSpeed = 50;
        }
        if (this.textOpacity < 0 || this.textOpacity > 255) {
            this.textOpacity = 255;
        }
        if (this.textColorRed < 0 || this.textColorRed > 255) {
            this.textColorRed = 255;
        }
        if (this.textColorGreen < 0 || this.textColorGreen > 255) {
            this.textColorGreen = 255;
        }
        if (this.textColorBlue < 0 || this.textColorBlue > 255) {
            this.textColorBlue = 255;
        }
        if (this.musicResponseSizeLimit > 0L && this.musicResponseSizeLimit < 10L) {
            this.musicResponseSizeLimit = 10L;
        }
        if (this.volumeWhenPlayingVoice < 0 || this.volumeWhenPlayingVoice > 100) {
            this.volumeWhenPlayingVoice = 25;
        }
        this.bannedServers.removeIf(String::isBlank);
        this.bannedSongs.removeIf(bannedSong -> bannedSong.id <= 0L);
        this.domainWhitelist.removeIf(String::isBlank);
        if (!this.domainWhitelist.isEmpty() && !this.domainWhitelist.contains("music.126.net")) {
            this.domainWhitelist.add("music.126.net");
        }
        try {
            CacheUtils.checkCachePath(this.getCachePath());
        }
        catch (Exception e) {
            throw new ConfigData.ValidationException("Invalid cache path: ", (Throwable)e);
        }
    }

    public void save() {
        AutoConfig.getConfigHolder(this.getClass()).save();
    }

    public String getCachePath() {
        if (this.cachePath.isBlank()) {
            return CacheUtils.getDefaultCachePath();
        }
        return StrEnvSubstitutor.replace(this.cachePath);
    }

    public static class BannedSong {
        @ConfigEntry.Gui.Tooltip
        public long id;
        @ConfigEntry.Gui.Tooltip
        public String name;

        public BannedSong() {
        }

        public BannedSong(long id, String name) {
            this.id = id;
            this.name = name;
        }
    }
}

