/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.libs.flac.common;

import java.io.IOException;
import java.util.Objects;
import org.lolicode.nekomusiccli.libs.flac.decode.DataFormatException;
import org.lolicode.nekomusiccli.libs.flac.decode.FlacLowLevelInput;
import org.lolicode.nekomusiccli.libs.flac.encode.BitOutputStream;

public final class FrameInfo {
    public int frameIndex = -1;
    public long sampleOffset = -1L;
    public int numChannels = -1;
    public int channelAssignment = -1;
    public int blockSize = -1;
    public int sampleRate = -1;
    public int sampleDepth = -1;
    public int frameSize = -1;
    private static final int[][] BLOCK_SIZE_CODES = new int[][]{{192, 1}, {576, 2}, {1152, 3}, {2304, 4}, {4608, 5}, {256, 8}, {512, 9}, {1024, 10}, {2048, 11}, {4096, 12}, {8192, 13}, {16384, 14}, {32768, 15}};
    private static final int[][] SAMPLE_DEPTH_CODES = new int[][]{{8, 1}, {12, 2}, {16, 4}, {20, 5}, {24, 6}};
    private static final int[][] SAMPLE_RATE_CODES = new int[][]{{88200, 1}, {176400, 2}, {192000, 3}, {8000, 4}, {16000, 5}, {22050, 6}, {24000, 7}, {32000, 8}, {44100, 9}, {48000, 10}, {96000, 11}};

    public static FrameInfo readFrame(FlacLowLevelInput in) throws IOException {
        int chanAsgn;
        in.resetCrcs();
        int temp = in.readByte();
        if (temp == -1) {
            return null;
        }
        FrameInfo result = new FrameInfo();
        result.frameSize = -1;
        int sync = temp << 6 | in.readUint(6);
        if (sync != 16382) {
            throw new DataFormatException("Sync code expected");
        }
        if (in.readUint(1) != 0) {
            throw new DataFormatException("Reserved bit");
        }
        int blockStrategy = in.readUint(1);
        int blockSizeCode = in.readUint(4);
        int sampleRateCode = in.readUint(4);
        result.channelAssignment = chanAsgn = in.readUint(4);
        if (chanAsgn < 8) {
            result.numChannels = chanAsgn + 1;
        } else if (8 <= chanAsgn && chanAsgn <= 10) {
            result.numChannels = 2;
        } else {
            throw new DataFormatException("Reserved channel assignment");
        }
        result.sampleDepth = FrameInfo.decodeSampleDepth(in.readUint(3));
        if (in.readUint(1) != 0) {
            throw new DataFormatException("Reserved bit");
        }
        long position = FrameInfo.readUtf8Integer(in);
        if (blockStrategy == 0) {
            if (position >>> 31 != 0L) {
                throw new DataFormatException("Frame index too large");
            }
            result.frameIndex = (int)position;
            result.sampleOffset = -1L;
        } else if (blockStrategy == 1) {
            result.sampleOffset = position;
            result.frameIndex = -1;
        } else {
            throw new AssertionError();
        }
        result.blockSize = FrameInfo.decodeBlockSize(blockSizeCode, in);
        result.sampleRate = FrameInfo.decodeSampleRate(sampleRateCode, in);
        int computedCrc8 = in.getCrc8();
        if (in.readUint(8) != computedCrc8) {
            throw new DataFormatException("CRC-8 mismatch");
        }
        return result;
    }

    private static long readUtf8Integer(FlacLowLevelInput in) throws IOException {
        int head = in.readUint(8);
        int n = Integer.numberOfLeadingZeros(~(head << 24));
        assert (0 <= n && n <= 8);
        if (n == 0) {
            return head;
        }
        if (n == 1 || n == 8) {
            throw new DataFormatException("Invalid UTF-8 coded number");
        }
        long result = head & 127 >>> n;
        for (int i = 0; i < n - 1; ++i) {
            int temp = in.readUint(8);
            if ((temp & 0xC0) != 128) {
                throw new DataFormatException("Invalid UTF-8 coded number");
            }
            result = result << 6 | (long)(temp & 0x3F);
        }
        if (result >>> 36 != 0L) {
            throw new AssertionError();
        }
        return result;
    }

    private static int decodeBlockSize(int code, FlacLowLevelInput in) throws IOException {
        if (code >>> 4 != 0) {
            throw new IllegalArgumentException();
        }
        return switch (code) {
            case 0 -> throw new DataFormatException("Reserved block size");
            case 6 -> in.readUint(8) + 1;
            case 7 -> in.readUint(16) + 1;
            default -> {
                int result = FrameInfo.searchSecond(BLOCK_SIZE_CODES, code);
                if (result < 1 || result > 65536) {
                    throw new AssertionError();
                }
                yield result;
            }
        };
    }

    private static int decodeSampleRate(int code, FlacLowLevelInput in) throws IOException {
        if (code >>> 4 != 0) {
            throw new IllegalArgumentException();
        }
        return switch (code) {
            case 0 -> -1;
            case 12 -> in.readUint(8);
            case 13 -> in.readUint(16);
            case 14 -> in.readUint(16) * 10;
            case 15 -> throw new DataFormatException("Invalid sample rate");
            default -> {
                int result = FrameInfo.searchSecond(SAMPLE_RATE_CODES, code);
                if (result < 1 || result > 655350) {
                    throw new AssertionError();
                }
                yield result;
            }
        };
    }

    private static int decodeSampleDepth(int code) {
        if (code >>> 3 != 0) {
            throw new IllegalArgumentException();
        }
        if (code == 0) {
            return -1;
        }
        int result = FrameInfo.searchSecond(SAMPLE_DEPTH_CODES, code);
        if (result == -1) {
            throw new DataFormatException("Reserved bit depth");
        }
        if (result < 1 || result > 32) {
            throw new AssertionError();
        }
        return result;
    }

    public void writeHeader(BitOutputStream out) throws IOException {
        Objects.requireNonNull(out);
        out.resetCrcs();
        out.writeInt(14, 16382);
        out.writeInt(1, 0);
        out.writeInt(1, 1);
        int blockSizeCode = FrameInfo.getBlockSizeCode(this.blockSize);
        out.writeInt(4, blockSizeCode);
        int sampleRateCode = FrameInfo.getSampleRateCode(this.sampleRate);
        out.writeInt(4, sampleRateCode);
        out.writeInt(4, this.channelAssignment);
        out.writeInt(3, FrameInfo.getSampleDepthCode(this.sampleDepth));
        out.writeInt(1, 0);
        if (this.frameIndex != -1 && this.sampleOffset == -1L) {
            FrameInfo.writeUtf8Integer(this.sampleOffset, out);
        } else if (this.sampleOffset != -1L && this.frameIndex == -1) {
            FrameInfo.writeUtf8Integer(this.sampleOffset, out);
        } else {
            throw new IllegalStateException();
        }
        if (blockSizeCode == 6) {
            out.writeInt(8, this.blockSize - 1);
        } else if (blockSizeCode == 7) {
            out.writeInt(16, this.blockSize - 1);
        }
        if (sampleRateCode == 12) {
            out.writeInt(8, this.sampleRate);
        } else if (sampleRateCode == 13) {
            out.writeInt(16, this.sampleRate);
        } else if (sampleRateCode == 14) {
            out.writeInt(16, this.sampleRate / 10);
        }
        out.writeInt(8, out.getCrc8());
    }

    private static void writeUtf8Integer(long val, BitOutputStream out) throws IOException {
        if (val >>> 36 != 0L) {
            throw new IllegalArgumentException();
        }
        int bitLen = 64 - Long.numberOfLeadingZeros(val);
        if (bitLen <= 7) {
            out.writeInt(8, (int)val);
        } else {
            int n = (bitLen - 2) / 5;
            out.writeInt(8, 65408 >>> n | (int)(val >>> n * 6));
            for (int i = n - 1; i >= 0; --i) {
                out.writeInt(8, 0x80 | (int)(val >>> i * 6) & 0x3F);
            }
        }
    }

    private static int getBlockSizeCode(int blockSize) {
        int result = FrameInfo.searchFirst(BLOCK_SIZE_CODES, blockSize);
        if (result == -1) {
            if (1 <= blockSize && blockSize <= 256) {
                result = 6;
            } else if (1 <= blockSize && blockSize <= 65536) {
                result = 7;
            } else {
                throw new IllegalArgumentException();
            }
        }
        if (result >>> 4 != 0) {
            throw new AssertionError();
        }
        return result;
    }

    private static int getSampleRateCode(int sampleRate) {
        if (sampleRate == 0 || sampleRate < -1) {
            throw new IllegalArgumentException();
        }
        int result = FrameInfo.searchFirst(SAMPLE_RATE_CODES, sampleRate);
        if (result == -1) {
            result = 0 <= sampleRate && sampleRate < 256 ? 12 : (0 <= sampleRate && sampleRate < 65536 ? 13 : (0 <= sampleRate && sampleRate < 655360 && sampleRate % 10 == 0 ? 14 : 0));
        }
        if (result >>> 4 != 0) {
            throw new AssertionError();
        }
        return result;
    }

    private static int getSampleDepthCode(int sampleDepth) {
        if (sampleDepth != -1 && (sampleDepth < 1 || sampleDepth > 32)) {
            throw new IllegalArgumentException();
        }
        int result = FrameInfo.searchFirst(SAMPLE_DEPTH_CODES, sampleDepth);
        if (result == -1) {
            result = 0;
        }
        if (result >>> 3 != 0) {
            throw new AssertionError();
        }
        return result;
    }

    private static final int searchFirst(int[][] table, int key) {
        for (int[] pair : table) {
            if (pair[0] != key) continue;
            return pair[1];
        }
        return -1;
    }

    private static final int searchSecond(int[][] table, int key) {
        for (int[] pair : table) {
            if (pair[1] != key) continue;
            return pair[0];
        }
        return -1;
    }
}

