/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.libs.flac.common;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.lolicode.nekomusiccli.libs.flac.encode.BitOutputStream;

public final class SeekTable {
    public List<SeekPoint> points = new ArrayList<SeekPoint>();

    public SeekTable() {
    }

    public SeekTable(byte[] b) {
        this();
        Objects.requireNonNull(b);
        if (b.length % 18 != 0) {
            throw new IllegalArgumentException("Data contains a partial seek point");
        }
        try {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(b));
            for (int i = 0; i < b.length; i += 18) {
                SeekPoint p = new SeekPoint();
                p.sampleOffset = in.readLong();
                p.fileOffset = in.readLong();
                p.frameSamples = in.readUnsignedShort();
                this.points.add(p);
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void checkValues() {
        Objects.requireNonNull(this.points);
        for (SeekPoint p : this.points) {
            Objects.requireNonNull(p);
            if ((p.frameSamples & 0xFFFF) == p.frameSamples) continue;
            throw new IllegalStateException("Frame samples outside uint16 range");
        }
        for (int i = 1; i < this.points.size(); ++i) {
            SeekPoint p;
            p = this.points.get(i);
            if (p.sampleOffset == -1L) continue;
            SeekPoint q = this.points.get(i - 1);
            if (p.sampleOffset <= q.sampleOffset) {
                throw new IllegalStateException("Sample offsets out of order");
            }
            if (p.fileOffset >= q.fileOffset) continue;
            throw new IllegalStateException("File offsets out of order");
        }
    }

    public void write(boolean last, BitOutputStream out) throws IOException {
        Objects.requireNonNull(out);
        Objects.requireNonNull(this.points);
        if (this.points.size() > 932067) {
            throw new IllegalStateException("Too many seek points");
        }
        this.checkValues();
        out.writeInt(1, last ? 1 : 0);
        out.writeInt(7, 3);
        out.writeInt(24, this.points.size() * 18);
        for (SeekPoint p : this.points) {
            out.writeInt(32, (int)(p.sampleOffset >>> 32));
            out.writeInt(32, (int)(p.sampleOffset >>> 0));
            out.writeInt(32, (int)(p.fileOffset >>> 32));
            out.writeInt(32, (int)(p.fileOffset >>> 0));
            out.writeInt(16, p.frameSamples);
        }
    }

    public static final class SeekPoint {
        public long sampleOffset;
        public long fileOffset;
        public int frameSamples;
    }
}

