/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.libs.flac.decode;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.lolicode.nekomusiccli.libs.flac.common.FrameInfo;
import org.lolicode.nekomusiccli.libs.flac.common.SeekTable;
import org.lolicode.nekomusiccli.libs.flac.common.StreamInfo;
import org.lolicode.nekomusiccli.libs.flac.decode.DataFormatException;
import org.lolicode.nekomusiccli.libs.flac.decode.FlacLowLevelInput;
import org.lolicode.nekomusiccli.libs.flac.decode.FrameDecoder;
import org.lolicode.nekomusiccli.libs.flac.decode.SeekableFileFlacInput;

public class FlacDecoder
implements AutoCloseable {
    public StreamInfo streamInfo;
    public SeekTable seekTable;
    protected FlacLowLevelInput input;
    protected long metadataEndPos;
    private FrameDecoder frameDec;

    protected FlacDecoder() {
    }

    public FlacDecoder(File file) throws IOException {
        Objects.requireNonNull(file);
        this.input = new SeekableFileFlacInput(file);
        if (this.input.readUint(32) != 1716281667) {
            throw new DataFormatException("Invalid magic string");
        }
        this.metadataEndPos = -1L;
    }

    public Object[] readAndHandleMetadataBlock() throws IOException {
        if (this.metadataEndPos != -1L) {
            return null;
        }
        boolean last = this.input.readUint(1) != 0;
        int type = this.input.readUint(7);
        int length = this.input.readUint(24);
        byte[] data = new byte[length];
        this.input.readFully(data);
        if (type == 0) {
            if (this.streamInfo != null) {
                throw new DataFormatException("Duplicate stream info metadata block");
            }
            this.streamInfo = new StreamInfo(data);
        } else {
            if (this.streamInfo == null) {
                throw new DataFormatException("Expected stream info metadata block");
            }
            if (type == 3) {
                if (this.seekTable != null) {
                    throw new DataFormatException("Duplicate seek table metadata block");
                }
                this.seekTable = new SeekTable(data);
            }
        }
        if (last) {
            this.metadataEndPos = this.input.getPosition();
            this.frameDec = new FrameDecoder(this.input, this.streamInfo.sampleDepth);
        }
        return new Object[]{type, data};
    }

    public int readAudioBlock(int[][] samples, int off) throws IOException {
        if (this.frameDec == null) {
            throw new IllegalStateException("Metadata blocks not fully consumed yet");
        }
        FrameInfo frame = this.frameDec.readFrame(samples, off);
        if (frame == null) {
            return 0;
        }
        return frame.blockSize;
    }

    public int seekAndReadAudioBlock(long pos, int[][] samples, int off) throws IOException {
        if (this.frameDec == null) {
            throw new IllegalStateException("Metadata blocks not fully consumed yet");
        }
        long[] sampleAndFilePos = this.getBestSeekPoint(pos);
        if (pos - sampleAndFilePos[0] > 300000L) {
            sampleAndFilePos = this.seekBySyncAndDecode(pos);
            sampleAndFilePos[1] = sampleAndFilePos[1] - this.metadataEndPos;
        }
        this.input.seekTo(sampleAndFilePos[1] + this.metadataEndPos);
        long curPos = sampleAndFilePos[0];
        int[][] smpl = new int[this.streamInfo.numChannels][65536];
        FrameInfo frame;
        while ((frame = this.frameDec.readFrame(smpl, 0)) != null) {
            long nextPos = curPos + (long)frame.blockSize;
            if (nextPos > pos) {
                for (int ch = 0; ch < smpl.length; ++ch) {
                    System.arraycopy(smpl[ch], (int)(pos - curPos), samples[ch], off, (int)(nextPos - pos));
                }
                return (int)(nextPos - pos);
            }
            curPos = nextPos;
        }
        return 0;
    }

    private long[] getBestSeekPoint(long pos) {
        long samplePos = 0L;
        long filePos = 0L;
        if (this.seekTable != null) {
            for (SeekTable.SeekPoint p : this.seekTable.points) {
                if (p.sampleOffset > pos) break;
                samplePos = p.sampleOffset;
                filePos = p.fileOffset;
            }
        }
        return new long[]{samplePos, filePos};
    }

    private long[] seekBySyncAndDecode(long pos) throws IOException {
        long start = this.metadataEndPos;
        long end = this.input.getLength();
        while (end - start > 100000L) {
            long mid = start + end >>> 1;
            long[] offsets = this.getNextFrameOffsets(mid);
            if (offsets == null || offsets[0] > pos) {
                end = mid;
                continue;
            }
            start = offsets[1];
        }
        return this.getNextFrameOffsets(start);
    }

    private long[] getNextFrameOffsets(long filePos) throws IOException {
        if (filePos < this.metadataEndPos || filePos > this.input.getLength()) {
            throw new IllegalArgumentException("File position out of bounds");
        }
        while (true) {
            this.input.seekTo(filePos);
            boolean state = false;
            while (true) {
                int b;
                if ((b = this.input.readByte()) == -1) {
                    return null;
                }
                if (b == 255) {
                    state = true;
                    continue;
                }
                if (state && (b & 0xFE) == 248) break;
                state = false;
            }
            filePos = this.input.getPosition() - 2L;
            this.input.seekTo(filePos);
            try {
                FrameInfo frame = FrameInfo.readFrame(this.input);
                return new long[]{this.getSampleOffset(frame), filePos};
            }
            catch (DataFormatException e) {
                filePos += 2L;
                continue;
            }
            break;
        }
    }

    private long getSampleOffset(FrameInfo frame) {
        Objects.requireNonNull(frame);
        if (frame.sampleOffset != -1L) {
            return frame.sampleOffset;
        }
        if (frame.frameIndex != -1) {
            return frame.frameIndex * this.streamInfo.maxBlockSize;
        }
        throw new AssertionError();
    }

    @Override
    public void close() throws IOException {
        if (this.input != null) {
            this.streamInfo = null;
            this.seekTable = null;
            this.frameDec = null;
            this.input.close();
            this.input = null;
        }
    }
}

