/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.libs.flac.encode;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import org.lolicode.nekomusiccli.libs.flac.encode.BitOutputStream;
import org.lolicode.nekomusiccli.libs.flac.encode.FastDotProduct;
import org.lolicode.nekomusiccli.libs.flac.encode.RiceEncoder;
import org.lolicode.nekomusiccli.libs.flac.encode.SizeEstimate;
import org.lolicode.nekomusiccli.libs.flac.encode.SubframeEncoder;

final class LinearPredictiveEncoder
extends SubframeEncoder {
    private final int order;
    private final double[] realCoefs;
    private int[] coefficients;
    private final int coefDepth;
    private final int coefShift;
    public int riceOrder;

    public static SizeEstimate<SubframeEncoder> computeBest(long[] samples, int shift, int depth, int order, int roundVars, FastDotProduct fdp, int maxRiceOrder) {
        if (order < 1 || order > 32) {
            throw new IllegalArgumentException();
        }
        if (roundVars < 0 || roundVars > order || roundVars > 30) {
            throw new IllegalArgumentException();
        }
        LinearPredictiveEncoder enc = new LinearPredictiveEncoder(samples, shift, depth, order, fdp);
        samples = LinearPredictiveEncoder.shiftRight(samples, shift);
        Integer[] indices = null;
        int scaler = 1 << enc.coefShift;
        if (roundVars > 0) {
            residues = new double[order];
            indices = new Integer[order];
            for (int i = 0; i < order; ++i) {
                residues[i] = Math.abs((double)Math.round(enc.realCoefs[i] * (double)scaler) - enc.realCoefs[i] * (double)scaler);
                indices[i] = i;
            }
            Arrays.sort(indices, new Comparator<Integer>(){

                @Override
                public int compare(Integer x, Integer y) {
                    return Double.compare(residues[y], residues[x]);
                }
            });
        } else {
            residues = null;
        }
        long bestSize = Long.MAX_VALUE;
        int[] bestCoefs = (int[])enc.coefficients.clone();
        for (int i = 0; i < 1 << roundVars; ++i) {
            for (int j = 0; j < roundVars; ++j) {
                int k = indices[j];
                double coef = enc.realCoefs[k];
                int val = (i >>> j & 1) == 0 ? (int)Math.floor(coef * (double)scaler) : (int)Math.ceil(coef * (double)scaler);
                enc.coefficients[order - 1 - k] = Math.max(Math.min(val, (1 << enc.coefDepth - 1) - 1), -(1 << enc.coefDepth - 1));
            }
            long[] newData = roundVars > 0 ? (long[])samples.clone() : samples;
            LinearPredictiveEncoder.applyLpc(newData, enc.coefficients, enc.coefShift);
            long temp = RiceEncoder.computeBestSizeAndOrder(newData, order, maxRiceOrder);
            long size = (long)(8 + shift + order * depth) + (temp >>> 4);
            if (size >= bestSize) continue;
            bestSize = size;
            bestCoefs = (int[])enc.coefficients.clone();
            enc.riceOrder = (int)(temp & 0xFL);
        }
        enc.coefficients = bestCoefs;
        return new SizeEstimate<SubframeEncoder>(bestSize, enc);
    }

    public LinearPredictiveEncoder(long[] samples, int shift, int depth, int order, FastDotProduct fdp) {
        super(shift, depth);
        int numSamples = samples.length;
        if (order < 1 || order > 32 || numSamples < order) {
            throw new IllegalArgumentException();
        }
        this.order = order;
        double[][] matrix = new double[order][order + 1];
        for (int r = 0; r < matrix.length; ++r) {
            for (int c = 0; c < matrix[r].length; ++c) {
                double val = c >= r ? fdp.dotProduct(r, c, samples.length - order) : matrix[c][r];
                matrix[r][c] = val;
            }
        }
        this.realCoefs = LinearPredictiveEncoder.solveMatrix(matrix);
        double maxCoef = 0.0;
        for (double x : this.realCoefs) {
            maxCoef = Math.max(Math.abs(x), maxCoef);
        }
        int wholeBits = maxCoef >= 1.0 ? (int)(Math.log(maxCoef) / Math.log(2.0)) + 1 : 0;
        this.coefficients = new int[order];
        this.coefDepth = 15;
        this.coefShift = this.coefDepth - 1 - wholeBits;
        for (int i = 0; i < this.realCoefs.length; ++i) {
            double coef = this.realCoefs[this.realCoefs.length - 1 - i];
            int val = (int)Math.round(coef * (double)(1 << this.coefShift));
            this.coefficients[i] = Math.max(Math.min(val, (1 << this.coefDepth - 1) - 1), -(1 << this.coefDepth - 1));
        }
    }

    private static double[] solveMatrix(double[][] mat) {
        int rows = mat.length;
        int cols = mat[0].length;
        if (rows + 1 != cols) {
            throw new IllegalArgumentException();
        }
        int numPivots = 0;
        for (int j = 0; j < rows && numPivots < rows; ++j) {
            int pivotRow = rows;
            double pivotMag = 0.0;
            for (int i = numPivots; i < rows; ++i) {
                if (!(Math.abs(mat[i][j]) > pivotMag)) continue;
                pivotMag = Math.abs(mat[i][j]);
                pivotRow = i;
            }
            if (pivotRow == rows) continue;
            double[] temp = mat[numPivots];
            mat[numPivots] = mat[pivotRow];
            mat[pivotRow] = temp;
            pivotRow = numPivots++;
            double factor = mat[pivotRow][j];
            int k = 0;
            while (k < cols) {
                double[] dArray = mat[pivotRow];
                int n = k++;
                dArray[n] = dArray[n] / factor;
            }
            mat[pivotRow][j] = 1.0;
            for (int i = pivotRow + 1; i < rows; ++i) {
                factor = mat[i][j];
                for (int k2 = 0; k2 < cols; ++k2) {
                    double[] dArray = mat[i];
                    int n = k2;
                    dArray[n] = dArray[n] - mat[pivotRow][k2] * factor;
                }
                mat[i][j] = 0.0;
            }
        }
        double[] result = new double[rows];
        for (int i = numPivots - 1; i >= 0; --i) {
            int pivotCol;
            for (pivotCol = 0; pivotCol < cols && mat[i][pivotCol] == 0.0; ++pivotCol) {
            }
            if (pivotCol == cols) continue;
            result[pivotCol] = mat[i][cols - 1];
            for (int j = i - 1; j >= 0; --j) {
                double factor = mat[j][pivotCol];
                for (int k = 0; k < cols; ++k) {
                    double[] dArray = mat[j];
                    int n = k;
                    dArray[n] = dArray[n] - mat[i][k] * factor;
                }
                mat[j][pivotCol] = 0.0;
            }
        }
        return result;
    }

    @Override
    public void encode(long[] samples, BitOutputStream out) throws IOException {
        Objects.requireNonNull(samples);
        Objects.requireNonNull(out);
        if (samples.length < this.order) {
            throw new IllegalArgumentException();
        }
        this.writeTypeAndShift(32 + this.order - 1, out);
        samples = LinearPredictiveEncoder.shiftRight(samples, this.sampleShift);
        for (int i = 0; i < this.order; ++i) {
            this.writeRawSample(samples[i], out);
        }
        out.writeInt(4, this.coefDepth - 1);
        out.writeInt(5, this.coefShift);
        for (int x : this.coefficients) {
            out.writeInt(this.coefDepth, x);
        }
        LinearPredictiveEncoder.applyLpc(samples, this.coefficients, this.coefShift);
        RiceEncoder.encode(samples, this.order, this.riceOrder, out);
    }

    /*
     * WARNING - void declaration
     */
    static void applyLpc(long[] data, int[] coefs, int shift) {
        void var3_6;
        Objects.requireNonNull(data);
        Objects.requireNonNull(coefs);
        if (coefs.length > 32 || shift < 0 || shift > 63) {
            throw new IllegalArgumentException();
        }
        for (long x : data) {
            if ((x >>= 32) == 0L || x == -1L) continue;
            throw new IllegalArgumentException();
        }
        for (int x : coefs) {
            if ((x >>= 14) == 0 || x == -1) continue;
            throw new IllegalArgumentException();
        }
        int n = data.length - 1;
        while (var3_6 >= coefs.length) {
            long sum = 0L;
            for (int j = 0; j < coefs.length; ++j) {
                sum += data[var3_6 - true - j] * (long)coefs[j];
            }
            long val = data[var3_6] - (sum >> shift);
            if (val >> 52 != 0L && val >> 52 != -1L) {
                throw new AssertionError();
            }
            data[var3_6] = val;
            --var3_6;
        }
    }

    static long[] shiftRight(long[] data, int shift) {
        Objects.requireNonNull(data);
        if (shift < 0 || shift > 63) {
            throw new IllegalArgumentException();
        }
        long[] result = new long[data.length];
        for (int i = 0; i < data.length; ++i) {
            result[i] = data[i] >> shift;
        }
        return result;
    }
}

