/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.libs.flac.encode;

import java.io.IOException;
import java.util.Objects;
import org.lolicode.nekomusiccli.libs.flac.encode.BitOutputStream;

final class RiceEncoder {
    RiceEncoder() {
    }

    public static long computeBestSizeAndOrder(long[] data, int warmup, int maxPartOrder) {
        Objects.requireNonNull(data);
        if (warmup < 0 || warmup > data.length) {
            throw new IllegalArgumentException();
        }
        if (maxPartOrder < 0 || maxPartOrder > 15) {
            throw new IllegalArgumentException();
        }
        for (long x : data) {
            if ((x >>= 52) == 0L || x == -1L) continue;
            throw new IllegalArgumentException();
        }
        long bestSize = Integer.MAX_VALUE;
        int bestOrder = -1;
        int[] escapeBits = null;
        int[] bitsAtParam = null;
        for (int order = maxPartOrder; order >= 0; --order) {
            int param;
            int partSize = data.length >>> order;
            if (partSize << order != data.length || partSize < warmup) continue;
            int numPartitions = 1 << order;
            if (escapeBits == null) {
                escapeBits = new int[numPartitions];
                bitsAtParam = new int[numPartitions * 16];
                for (i = warmup; i < data.length; ++i) {
                    j = i / partSize;
                    long val = data[i];
                    escapeBits[j] = Math.max(65 - Long.numberOfLeadingZeros(val ^ val >> 63), escapeBits[j]);
                    val = val >= 0L ? val << 1 : (-val << 1) - 1L;
                    param = 0;
                    while (param < 15) {
                        int n = param + j * 16;
                        bitsAtParam[n] = (int)((long)bitsAtParam[n] + (val + 1L + (long)param));
                        ++param;
                        val >>>= 1;
                    }
                }
            } else {
                for (i = 0; i < numPartitions; ++i) {
                    j = i << 1;
                    escapeBits[i] = Math.max(escapeBits[j], escapeBits[j + 1]);
                    for (int param2 = 0; param2 < 15; ++param2) {
                        bitsAtParam[param2 + i * 16] = bitsAtParam[param2 + j * 16] + bitsAtParam[param2 + (j + 1) * 16];
                    }
                }
            }
            long size = 4 + (4 << order);
            for (int i = 0; i < numPartitions; ++i) {
                int min = Integer.MAX_VALUE;
                if (escapeBits[i] <= 31) {
                    min = 5 + escapeBits[i] * (partSize - (i == 0 ? warmup : 0));
                }
                for (param = 0; param < 15; ++param) {
                    min = Math.min(bitsAtParam[param + i * 16], min);
                }
                size += (long)min;
            }
            if (size >= bestSize) continue;
            bestSize = size;
            bestOrder = order;
        }
        if (bestSize == Integer.MAX_VALUE || bestOrder >>> 4 != 0) {
            throw new AssertionError();
        }
        return bestSize << 4 | (long)bestOrder;
    }

    private static long computeBestSizeAndParam(long[] data, int start, int end) {
        int bestParam;
        long bestSize;
        assert (data != null && 0 <= start && start <= end && end <= data.length);
        long accumulator = 0L;
        for (int i = start; i < end; ++i) {
            long val = data[i];
            accumulator |= val ^ val >> 63;
        }
        int numBits = 65 - Long.numberOfLeadingZeros(accumulator);
        assert (1 <= numBits && numBits <= 65);
        if (numBits <= 31) {
            bestSize = 9 + (end - start) * numBits;
            bestParam = 16 + numBits;
            if (bestParam >>> 6 != 0) {
                throw new AssertionError();
            }
        } else {
            bestSize = Long.MAX_VALUE;
            bestParam = 0;
        }
        for (int param = 0; param <= 14; ++param) {
            long size = 4L;
            for (int i = start; i < end; ++i) {
                long val = data[i];
                val = val >= 0L ? (val <<= 1) : (-val << 1) - 1L;
                size += (val >>> param) + 1L + (long)param;
            }
            if (size >= bestSize) continue;
            bestSize = size;
            bestParam = param;
        }
        return bestSize << 6 | (long)bestParam;
    }

    public static void encode(long[] data, int warmup, int order, BitOutputStream out) throws IOException {
        Objects.requireNonNull(data);
        Objects.requireNonNull(out);
        if (warmup < 0 || warmup > data.length) {
            throw new IllegalArgumentException();
        }
        if (order < 0 || order > 15) {
            throw new IllegalArgumentException();
        }
        for (long x : data) {
            if ((x >>= 52) == 0L || x == -1L) continue;
            throw new IllegalArgumentException();
        }
        out.writeInt(2, 0);
        out.writeInt(4, order);
        int numPartitions = 1 << order;
        int start = warmup;
        int end = data.length >>> order;
        for (int i = 0; i < numPartitions; ++i) {
            int param = (int)RiceEncoder.computeBestSizeAndParam(data, start, end) & 0x3F;
            RiceEncoder.encode(data, start, end, param, out);
            start = end;
            end += data.length >>> order;
        }
    }

    private static void encode(long[] data, int start, int end, int param, BitOutputStream out) throws IOException {
        assert (0 <= param && param <= 31 && data != null && out != null);
        assert (0 <= start && start <= end && end <= data.length);
        if (param < 15) {
            out.writeInt(4, param);
            for (int j = start; j < end; ++j) {
                RiceEncoder.writeRiceSignedInt(data[j], param, out);
            }
        } else {
            out.writeInt(4, 15);
            int numBits = param - 16;
            out.writeInt(5, numBits);
            for (int j = start; j < end; ++j) {
                out.writeInt(numBits, (int)data[j]);
            }
        }
    }

    private static void writeRiceSignedInt(long val, int param, BitOutputStream out) throws IOException {
        assert (0 <= param && param <= 31 && out != null);
        assert (val >> 52 == 0L || val >> 52 == -1L);
        long unsigned = val >= 0L ? val << 1 : (-val << 1) - 1L;
        int unary = (int)(unsigned >>> param);
        for (int i = 0; i < unary; ++i) {
            out.writeInt(1, 0);
        }
        out.writeInt(1, 1);
        out.writeInt(param, (int)unsigned);
    }
}

