/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.libs.lrcparser;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import org.lolicode.nekomusiccli.libs.lrcparser.parser.Sentence;

public class Lyric {
    private Hashtable<String, String> tags;
    private ArrayList<Sentence> sentences;
    private long duration;

    public Lyric(Hashtable<String, String> tags, ArrayList<Sentence> sentences) {
        this.tags = tags;
        this.sentences = sentences;
        this.updateDuration();
    }

    public static String[] findContents(List<Sentence> sentences) {
        String[] contents = new String[sentences.size()];
        for (int i = 0; i < contents.length; ++i) {
            contents[i] = sentences.get(i).getContent();
        }
        return contents;
    }

    public String[] findAllContents(long fromTime, long toTime) {
        return Lyric.findContents(this.findAllSentences(fromTime, toTime));
    }

    public String[] findAllContents() {
        return this.findAllContents(-1L, -1L);
    }

    public Sentence findSentence(long time) {
        if (time < 0L) {
            throw new RuntimeException("time<0");
        }
        for (Sentence sentence : this.sentences) {
            if (sentence.getFromTime() > time || sentence.getToTime() < time) continue;
            return sentence;
        }
        return null;
    }

    public String findContent(long time) {
        Sentence sent = this.findSentence(time);
        if (sent == null) {
            return null;
        }
        return sent.getContent();
    }

    public ArrayList<Sentence> findAllSentences(long fromTime, long toTime) {
        boolean begin = false;
        ArrayList<Sentence> result = new ArrayList<Sentence>(this.sentences.size() / 3);
        if (fromTime >= 0L && toTime >= 0L && fromTime > toTime) {
            return result;
        }
        for (Sentence sent : this.sentences) {
            if (!begin) {
                if (sent.getFromTime() < fromTime) continue;
                begin = true;
                result.add(sent);
                continue;
            }
            if (toTime >= 0L && sent.getFromTime() > toTime) break;
            result.add(sent);
        }
        return result;
    }

    public ArrayList<Sentence> getSentences() {
        return this.sentences;
    }

    public Hashtable<String, String> getTags() {
        return this.tags;
    }

    public boolean isEmpty() {
        return this.sentences.isEmpty();
    }

    public long getDuration() {
        return this.duration;
    }

    public void updateDuration() {
        this.duration = this.sentences == null || this.sentences.size() == 0 ? 0L : this.sentences.stream().sorted(Comparator.comparing(Sentence::getToTime)).mapToLong(Sentence::getToTime).max().orElseGet(this.sentences.get(this.sentences.size() - 1)::getToTime);
    }

    public void merge(Lyric translation) {
        if (translation == null) {
            return;
        }
        if (translation.isEmpty()) {
            return;
        }
        if (this.isEmpty()) {
            this.sentences = translation.sentences;
            this.tags = translation.tags;
            this.updateDuration();
            return;
        }
        for (Sentence sentence : translation.sentences) {
            Sentence target = this.findSentence(sentence.getFromTime());
            if (target == null) continue;
            target.setContent(target.getContent() + "\n" + sentence.getContent());
        }
        this.updateDuration();
    }
}

