/*
 * Decompiled with CFR 0.152.
 */
package org.lolicode.nekomusiccli.music.player;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javazoom.jl.decoder.BitstreamException;
import org.lolicode.nekomusiccli.NekoMusicClient;
import org.lolicode.nekomusiccli.music.player.AudioPlayer;
import org.lolicode.nekomusiccli.music.player.Decoder;

public class ByteArrayInputStreamAudioPlayer
extends AudioPlayer {
    private final ByteArrayInputStream stream;

    public ByteArrayInputStreamAudioPlayer(ByteArrayInputStream stream) throws RuntimeException, IOException, BitstreamException {
        this.stream = stream;
        try {
            this.decoder = Decoder.getDecoder(stream);
        }
        catch (IOException | RuntimeException | BitstreamException e) {
            NekoMusicClient.LOGGER.error("Failed to open the audio stream", e);
            this.cleanup();
            throw e;
        }
    }

    @Override
    public synchronized void cleanup() {
        if (this.cleanupDone) {
            return;
        }
        super.cleanup();
        try {
            this.stream.close();
        }
        catch (IOException e) {
            NekoMusicClient.LOGGER.error("Failed to close the audio stream", (Throwable)e);
        }
        this.cleanupDone = true;
    }
}

