/*
 * Decompiled with CFR 0.152.
 */
package cn.flowerinsnow.greatscrollabletooltips;

import cn.flowerinsnow.greatscrollabletooltips.common.config.GreatScrollableTooltipsConfig;
import cn.flowerinsnow.greatscrollabletooltips.common.object.ScrollSession;
import cn.flowerinsnow.greatscrollabletooltips.common.provider.ModEnvironmentProvider;
import cn.flowerinsnow.greatscrollabletooltips.event.PreScreenKeyPressedEvent;
import cn.flowerinsnow.greatscrollabletooltips.event.PreScreenMouseScrollEvent;
import cn.flowerinsnow.greatscrollabletooltips.event.RenderTooltipEvent;
import cn.flowerinsnow.greatscrollabletooltips.event.ScreenCloseEvent;
import cn.flowerinsnow.greatscrollabletooltips.listener.EventTriggerListener;
import cn.flowerinsnow.greatscrollabletooltips.listener.KeyScrollListener;
import cn.flowerinsnow.greatscrollabletooltips.listener.MouseScrollListener;
import cn.flowerinsnow.greatscrollabletooltips.listener.ScrollingStatusListener;
import cn.flowerinsnow.greatscrollabletooltips.manager.KeyBindingManager;
import java.io.InputStream;
import java.nio.file.Path;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_128;
import net.minecraft.class_1799;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class GreatScrollableTooltips
implements ClientModInitializer {
    public static final String MODID = "great-scrollable-tooltips";
    private static GreatScrollableTooltips instance;
    private GreatScrollableTooltipsConfig config;
    private ScrollSession<class_1799> scrollSession;

    public void onInitializeClient() {
        instance = this;
        this.scrollSession = new ScrollSession();
        this.initConfig();
        this.initListeners();
        this.initKeyBindings();
    }

    private void initConfig() {
        this.config = new GreatScrollableTooltipsConfig(new ModEnvironmentProvider(this){

            public InputStream getDefaultConfigAsStream() {
                return GreatScrollableTooltips.class.getResourceAsStream("/config.toml");
            }

            public Path getConfigFile() {
                return FabricLoader.getInstance().getConfigDir().resolve("great-scrollable-tooltips.toml");
            }

            public void crash(Throwable throwable, String msg) {
                class_310.method_1551().method_54580(class_128.method_560((Throwable)throwable, (String)msg));
            }
        });
        this.config.saveDefaultConfig();
        this.config.load();
    }

    private void initListeners() {
        ClientTickEvents.END_CLIENT_TICK.register((Object)new EventTriggerListener());
        PreScreenKeyPressedEvent.EVENT.register((Object)new KeyScrollListener(this));
        PreScreenMouseScrollEvent.EVENT.register((Object)new MouseScrollListener(this));
        ScrollingStatusListener scrollingStatusListener = new ScrollingStatusListener(this);
        RenderTooltipEvent.Pre.EVENT.register((Object)scrollingStatusListener);
        RenderTooltipEvent.Miss.EVENT.register((Object)scrollingStatusListener);
        ScreenCloseEvent.EVENT.register((Object)scrollingStatusListener);
    }

    private void initKeyBindings() {
        KeyBindingManager.registerAll();
    }

    public static GreatScrollableTooltips getInstance() {
        return instance;
    }

    public GreatScrollableTooltipsConfig getConfig() {
        return this.config;
    }

    public ScrollSession<class_1799> getScrollSession() {
        return this.scrollSession;
    }
}

