package com.hugouououo.alienmod.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1588;
import net.minecraft.class_1603;
import com.hugouououo.alienmod.item.ModItems;

public class AlienRangedAttackGoal<T extends class_1588 & class_1603> extends class_1352 {
    private final T actor;
    private final double speed;
    private int attackInterval;
    private final float squaredRange;
    private int cooldown = -1;
    private int targetSeeingTicker;
//    private boolean movingToLeft;
//    private boolean backward;
//    private int combatTicks = -1;
    private int chargeTicks;

    public AlienRangedAttackGoal(T actor, double speed, int attackInterval, float range) {
        this.actor = actor;
        this.speed = speed;
        this.attackInterval = attackInterval;
        this.squaredRange = range * range;
        this.method_6265(EnumSet.of(class_4134.field_18405, class_4134.field_18406));
    }

//    public void setAttackInterval(int attackInterval) {
//        this.attackInterval = attackInterval;
//    }

    @Override
    public boolean method_6264() {
        return this.actor.method_5968() != null && this.isHoldingRayGun();
    }

    protected boolean isHoldingRayGun() {
        return this.actor.method_6047().method_31574(ModItems.RAY_GUN);
    }

    @Override
    public boolean method_6266() {
        return (this.method_6264() || !this.actor.method_5942().method_6357()) && this.isHoldingRayGun();
    }

    @Override
    public void method_6269() {
        super.method_6269();
        this.actor.method_19540(true);
        this.chargeTicks = 0;
    }
    @Override
    public void method_6270() {
        super.method_6270();
        this.actor.method_19540(false);
        // ...
        this.actor.method_6021();
    }

    @Override
    public boolean method_38846() {
        return true;
    }

    @Override
    public void method_6268() {
        class_1309 target = this.actor.method_5968();
        if (target != null) {
            double distance = this.actor.method_5649(target.method_23317(), target.method_23318(), target.method_23321());
            boolean canSee = this.actor.method_5985().method_6369(target);

            if (canSee) {
                this.targetSeeingTicker = Math.min(this.targetSeeingTicker + 1, 20);
            } else {
                this.targetSeeingTicker = Math.max(this.targetSeeingTicker - 1, -60);
            }

            if (distance <= this.squaredRange /*&& this.targetSeeingTicker >= 10*/) {
                this.actor.method_5942().method_6340();
            } else {
                this.actor.method_5942().method_6335(target, this.speed);
            }

            this.actor.method_5951(target, 180.0F, 180.0F);

            this.cooldown--;

            if (this.cooldown <= 0) { // Se o cooldown terminou
                if (canSee) { // E o alvo está visível
                    if (this.chargeTicks < 20) { // Continua carregando
                        this.chargeTicks++;
                    } else { // Se carregou, atira
                        this.actor.method_7105(target, 1.0f);
                        this.cooldown = this.attackInterval; // Reseta cooldown
                        this.chargeTicks = 0; // Reseta carregamento
                    }
                } else { // Se o alvo não está visível, mas o cooldown já terminou, reseta o carregamento para esperar nova visão
                    this.chargeTicks = 0;
                }
            } else { // Se o cooldown ainda está ativo, reseta o carregamento para evitar que ele comece a carregar antes do tempo
                this.chargeTicks = 0;
            }
        }
    }
}