package com.hugouououo.alienmod.entity.client;

import com.hugouououo.alienmod.AlienMod;
import com.hugouououo.alienmod.entity.custom.AlienEntity;
import com.hugouououo.alienmod.item.ModItems;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5601;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.client.model.*;

public class AlienModel extends class_572<AlienEntity> {

    public static final class_5601 ALIEN = new class_5601(class_2960.method_60655(AlienMod.MOD_ID, "alien"), "main");

    public final class_630 field_3398;
    public final class_630 field_3391;
    public final class_630 right_arm;
    public final class_630 left_arm;
    public final class_630 right_leg;
    public final class_630 left_leg;
    public final class_630 field_3394;

    public AlienModel(class_630 root) {
        super(root);
        this.right_leg = root.method_32086("right_leg");
        this.left_leg = root.method_32086("left_leg");
        this.right_arm = root.method_32086("right_arm");
        this.left_arm = root.method_32086("left_arm");
        this.field_3398 = root.method_32086("head");
        this.field_3391 = root.method_32086("body");
        this.field_3394 = root.method_32086("hat");
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5610 right_leg = modelPartData.method_32117("right_leg", class_5606.method_32108().method_32101(18, 28).method_32098(-1.0F, 0.0F, -1.0F, 2.0F, 8.0F, 2.0F, new class_5605(0.0F)), class_5603.method_32090(-2.0F, 16.0F, 0.0F));

        class_5610 left_leg = modelPartData.method_32117("left_leg", class_5606.method_32108().method_32101(26, 28).method_32098(-1.0F, 0.0F, -1.0F, 2.0F, 8.0F, 2.0F, new class_5605(0.0F)), class_5603.method_32090(2.0F, 16.0F, 0.0F));

        class_5610 right_arm = modelPartData.method_32117("right_arm", class_5606.method_32108().method_32101(18, 16).method_32098(-1.0F, -1.0F, -1.0F, 2.0F, 10.0F, 2.0F, new class_5605(0.0F)), class_5603.method_32090(-4.0F, 7.0F, 0.0F));

        class_5610 left_arm = modelPartData.method_32117("left_arm", class_5606.method_32108().method_32101(26, 16).method_32098(-1.0F, -1.0F, -1.0F, 2.0F, 10.0F, 2.0F, new class_5605(0.0F)), class_5603.method_32090(4.0F, 7.0F, 0.0F));

        class_5610 head = modelPartData.method_32117("head", class_5606.method_32108().method_32101(0, 0).method_32098(-4.0F, -4.0F, -4.0F, 8.0F, 8.0F, 8.0F, new class_5605(0.0F)), class_5603.method_32090(0.0F, 2.0F, 0.0F));

        class_5610 body = modelPartData.method_32117("body", class_5606.method_32108().method_32101(0, 16).method_32098(-3.0F, -5.0F, -1.5F, 6.0F, 10.0F, 3.0F, new class_5605(0.0F)), class_5603.method_32090(0.0F, 11.0F, 0.0F));

        class_5610 hat = modelPartData.method_32117("hat", class_5606.method_32108(), class_5603.field_27701);

        return class_5607.method_32110(modelData, 64, 64);
    }

    @Override
    public void method_2828(class_4587 matrices, class_4588 vertices, int light, int overlay, int color) {
        right_leg.method_22699(matrices, vertices, light, overlay, color);
        left_leg.method_22699(matrices, vertices, light, overlay, color);
        right_arm.method_22699(matrices, vertices, light, overlay, color);
        left_arm.method_22699(matrices, vertices, light, overlay, color);
        field_3398.method_22699(matrices, vertices, light, overlay, color);
        field_3391.method_22699(matrices, vertices, light, overlay, color);
        field_3394.method_22699(matrices, vertices, light, overlay, color);
    }

    @Override
    public void setAngles(AlienEntity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {

        // Resetar as rotações para o estado padrão (T-pose ou pose original)
        // Usando pitch, yaw, roll diretamente
        this.field_3398.field_3654 = 0.0F;
        this.field_3398.field_3675 = 0.0F;
        this.field_3398.field_3674 = 0.0F; // Geralmente roll não é necessário para resetar, mas é uma opção

        this.field_3391.field_3654 = 0.0F;
        this.field_3391.field_3675 = 0.0F;
        this.field_3391.field_3674 = 0.0F;

        this.right_arm.field_3654 = 0.0F;
        this.right_arm.field_3675 = 0.0F;
        this.right_arm.field_3674 = 0.0F;

        this.left_arm.field_3654 = 0.0F;
        this.left_arm.field_3675 = 0.0F;
        this.left_arm.field_3674 = 0.0F;

        this.right_leg.field_3654 = 0.0F;
        this.right_leg.field_3675 = 0.0F;
        this.right_leg.field_3674 = 0.0F;

        this.left_leg.field_3654 = 0.0F;
        this.left_leg.field_3675 = 0.0F;
        this.left_leg.field_3674 = 0.0F;

        this.field_3394.field_3654 = 0.0F; // Se o hat precisar de rotações
        this.field_3394.field_3675 = 0.0F;
        this.field_3394.field_3674 = 0.0F;


        // 2. Animação da cabeça (o mob "olhando" para onde o jogador olha)
        this.field_3398.field_3675 = headYaw * ((float)Math.PI / 180F); // Converter graus para radianos
        this.field_3398.field_3654 = headPitch * ((float)Math.PI / 180F);

        // 3. Animação de caminhar (pernas e braços)
        this.right_leg.field_3654 = class_3532.method_15362(limbAngle * 0.6662F) * 1.4F * limbDistance;
        this.left_leg.field_3654 = class_3532.method_15362(limbAngle * 0.6662F + (float)Math.PI) * 1.4F * limbDistance;

        this.right_arm.field_3654 = class_3532.method_15362(limbAngle * 0.6662F + (float)Math.PI) * 1.4F * limbDistance;
        this.left_arm.field_3654 = class_3532.method_15362(limbAngle * 0.6662F) * 1.4F * limbDistance;

        // 4. Animação de ataque (sua lógica existente)
        if (entity.method_6510() && entity.method_6047().method_31574(ModItems.RAY_GUN)) {
            this.right_arm.field_3654 = (float) (-Math.PI / 2.0F);
            this.right_arm.field_3675 = 0.0F;
        }
    }

}


//    @Override
//    public void setAngles(AlienEntity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
//        super.setAngles(entity, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
//
//        // Animação de ataque
//        if (entity.isAttacking() && entity.getMainHandStack().isOf(ModItems.RAY_GUN)) {
//            this.rightArm.pitch = (float) (-Math.PI / 2.0F);
//            this.rightArm.yaw = 0.0F;
//        }
//    }

