package com.hugouououo.alienmod.entity.custom;

import com.hugouououo.alienmod.AlienMod;
import com.hugouououo.alienmod.entity.ModEntities;
import com.hugouououo.alienmod.entity.ai.goal.AlienRangedAttackGoal;
import com.hugouououo.alienmod.item.ModItems;
import com.hugouououo.alienmod.item.custom.RayGunItem;
import com.hugouououo.alienmod.sound.ModSounds;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5398;
import net.minecraft.class_6019;
import net.minecraft.class_7094;
import net.minecraft.entity.ai.goal.*;
import org.jetbrains.annotations.Nullable;

import java.util.UUID;

public class AlienEntity extends class_1588 implements class_5354, class_1603 {

    // Variaveis
    private int ageWhenTargetSet;
    private int angerTime;
    @Nullable
    private UUID angryAt;
    private static final class_6019 ANGER_TIME_RANGE = class_4802.method_24505(20, 39);
    private static final class_2940<Boolean> ANGRY = class_2945.method_12791(AlienEntity.class, class_2943.field_13323);
    public final class_7094 idleAnimationState = new class_7094();
    private int idleAnimationTimeout = 0;
    private static final class_6019 ANGRY_SOUND_DELAY_RANGE = class_4802.method_24505(0, 1); // Intervalo para o atraso do som
    private int angrySoundDelay;

    // Construtor
    public AlienEntity(class_1299<? extends AlienEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.updateAttackType();
    }

    // Objetivos
    private final AlienRangedAttackGoal<AlienEntity> alienRangedAttackGoal = new AlienRangedAttackGoal<>(this, 1.0, 20, 5.0F);

    @Override
    protected void method_5959() {

        this.field_6201.method_6277(0, new class_1361(this, class_1657.class, 15.0F));
        this.field_6201.method_6277(1, new class_1376(this));
        this.field_6201.method_6277(2, new class_1394(this, 1.0, 0.0F));
        this.field_6185.method_6277(0, new class_1399(this).method_6318());
        this.field_6185.method_6277(1, new class_1400<>(this, class_1657.class, 10, true, false, this::method_29515));
        this.field_6185.method_6277(2, new class_5398<>(this, true));

        this.updateAttackType();
    }

    @Override
    public boolean method_7076(class_1657 player) {
        return this.method_29515(player);
    }

    public void updateAttackType() {
        if (this.method_37908() != null && !this.method_37908().method_8608()) {
            this.field_6201.method_6280(this.alienRangedAttackGoal);

            class_1799 itemStack = this.method_6047();
            if (itemStack.method_31574(ModItems.RAY_GUN)) {
                this.field_6201.method_6277(0, this.alienRangedAttackGoal);
//                AlienMod.LOGGER.info("E DEPOIS, PEGOU UMA ARMA PRA REVIDAR!!!!!");
            }
        }
    }

    @Override
    public void method_7105(class_1309 target, float pullProgress) {
        if (target == null || !target.method_5805()) {
            return;
        }

        if (!this.method_37908().method_8608()) {
            LaserProjectileEntity laser = new LaserProjectileEntity(ModEntities.LASER_PROJECTILE, this.method_37908());
            class_243 direction = target.method_19538().method_1020(this.method_19538()).method_1029();
            class_243 spawnPos = this.method_33571().method_1019(direction.method_1021(1.0));
            laser.method_5814(spawnPos.field_1352, spawnPos.field_1351, spawnPos.field_1350);
            laser.method_18799(direction.method_1021(3.5));
            laser.method_36457(this.method_36455());
            laser.method_36456(this.method_36454());
            laser.method_7432(this);
            this.method_37908().method_8649(laser);

            // som
            float pitch = this.method_37908().field_9229.method_43057() * 0.4F + 1.0F;
            float volume = 0.50F;
            class_2338 soundPos = this.method_24515();
            this.method_37908().method_8396(
                    null,
                    soundPos,
                    ModSounds.LASER_SHOOT,
                    class_3419.field_15251,
                    volume,
                    pitch
            );
        }
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if(source.method_5529() instanceof AlienEntity){
            return false;  // aliens NAO tomam DANO de outros aliens
        }
        //AlienMod.LOGGER.info("ALIEN FOI ATACADO!!!!!!!");
        //this.goalSelector.add(0, this.alienRangedAttackGoal);
        //this.updateAttackType();
        return super.method_5643(source, amount);
    }

    @Override
    public boolean method_25938(net.minecraft.class_1811 weapon) {
        return weapon instanceof RayGunItem;
    }

    @Override
    protected void method_5964(net.minecraft.class_5819 random, net.minecraft.class_1266 localDifficulty) {
        super.method_5964(random, localDifficulty);
        this.method_5673(class_1304.field_6173, new class_1799(ModItems.RAY_GUN));
    }

    @Override
    public void method_6116(class_1304 slot, class_1799 oldStack, class_1799 newStack) {
        super.method_6116(slot, oldStack, newStack);
        if (!this.method_37908().method_8608()) {
            this.updateAttackType();
        }
    }

    // Atributos
    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918()
                .method_26868(class_5134.field_23716, 8.0)
                .method_26868(class_5134.field_23719, 0.3F)
                .method_26868(class_5134.field_23721, 3.0)
                .method_26868(class_5134.field_23717, 32.0)
                .method_26868(class_5134.field_47761, 1.0);
    }


    @Override
    public void method_5980(@Nullable class_1309 target) {
        if (this.method_5968() == null && target != null) {
            this.angrySoundDelay = ANGRY_SOUND_DELAY_RANGE.method_35008(this.field_5974);
        }
        super.method_5980(target);
        if (target == null) {
            this.ageWhenTargetSet = 0;
            this.field_6011.method_12778(ANGRY, false);
        } else {
            this.ageWhenTargetSet = this.field_6012;
            this.field_6011.method_12778(ANGRY, true);
        }
    }


    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ANGRY, false);
    }

    // atacando?
    @Override
    public void method_19540(boolean attacking) {
        super.method_19540(attacking);
    }
    @Override
    public boolean method_6510() {
        return super.method_6510();
    }

    // Metodos do Angerable
    @Override
    public int method_29507() {
        return this.angerTime;
    }
    @Override
    public void method_29514(int angerTime) {
        this.angerTime = angerTime;
    }
    @Nullable
    @Override
    public UUID method_29508() {
        return this.angryAt;
    }
    @Override
    public void method_29513(@Nullable UUID angryAt) {
        this.angryAt = angryAt;
    }
    @Override
    public void method_29509() {
        this.method_29514(ANGER_TIME_RANGE.method_35008(this.field_5974));
    }

    // Sons
    @Override
    protected class_3414 method_5994() { return ModSounds.ALIEN_IDLE; }
    @Override
    protected class_3414 method_6011(class_1282 source) { return ModSounds.ALIEN_HURT;}
    @Override
    protected class_3414 method_6002() { return ModSounds.ALIEN_DEATH; }

    private void playAngrySound() {
        this.method_37908().method_8396(
                null,
                this.method_24515(),
                ModSounds.RAY_GUN_LOAD,
                class_3419.field_15251,
                this.method_6107() * 2.0F,
                this.method_6017() * 1.8F
        );
    }

    // IDLE
    private void setupAnimationState(){
        if(this.idleAnimationTimeout <= 0){
            this.idleAnimationTimeout = 40;
            this.idleAnimationState.method_41322(this.field_6012);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    // isso resolveu o bug de que os que nascem no ovni não atacavam, obrigado gemini
    public boolean hasRayGunEquipped() {
        return this.method_6047().method_31574(ModItems.RAY_GUN);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().method_8608()) {

            // Garante que o alien tenha a Ray Gun
            if (!this.hasRayGunEquipped()) {
                this.method_5673(class_1304.field_6173, new class_1799(ModItems.RAY_GUN));
            }
            // Gerencia a meta de ataque à distância:
            // Se o alien TEM a Ray Gun, garanta que a meta de ataque à distância esteja adicionada.
            // O goalSelector.add() já lida com duplicatas (não adiciona se já presente na mesma prioridade).
            if (this.hasRayGunEquipped()) {
                this.field_6201.method_6277(0, this.alienRangedAttackGoal);
            } else {
                // Se o alien NAO TEM a Ray Gun, garanta que a meta de ataque à distância esteja REMOVIDA.
                this.field_6201.method_6280(this.alienRangedAttackGoal);
            }
        }
        if (this.method_37908().method_8608()) {
            setupAnimationState();
        }
        // Logica p som de raiva
        if (this.angrySoundDelay > 0) { //
            this.angrySoundDelay--; //
            if (this.angrySoundDelay == 0) { //
                this.playAngrySound(); //
            }
        }

        if (this.method_5968() != null && !this.method_5968().method_5805()) {
            this.method_5980(null);
        }
    }
}

