package com.hugouououo.alienmod.item.custom;

import com.hugouououo.alienmod.entity.custom.LaserProjectileEntity;
import com.hugouououo.alienmod.entity.ModEntities;
import com.hugouououo.alienmod.sound.ModSounds;
import org.jetbrains.annotations.Nullable;

import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1811;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;

public class RayGunItem extends class_1811 {

    public static final Predicate<class_1799> LASER_PROJECTILES = (stack) -> stack.method_31574(class_1802.field_8162);
    public RayGunItem(class_1793 settings) {
        super(settings);
    }

    @Override
    public Predicate<class_1799> method_19268() {
        return null;
    }

    @Override
    public int method_24792() {
        return 15;
    }

    @Override
    protected void method_7763(class_1309 shooter, class_1676 projectile, int index, float speed, float divergence, float yaw, @Nullable class_1309 target) {

        projectile.method_24919(shooter, shooter.method_36455(), shooter.method_36454(), 0.0F, speed, divergence);

        if (projectile instanceof LaserProjectileEntity laserProjectile) {
            laserProjectile.setInitialRotation(shooter.method_36455(), shooter.method_36454());
        }

        class_243 eyePos = shooter.method_33571();
        class_243 lookVec = shooter.method_5828(1.0F).method_1029();
        projectile.method_5814(eyePos.field_1352 + lookVec.field_1352 * 0.1, eyePos.field_1351 - 0.2, eyePos.field_1350 + lookVec.field_1350 * 0.1);

        projectile.method_7432(shooter);
        shooter.method_37908().method_8649(projectile);

        shooter.method_37908().method_8396(
                null,
                shooter.method_24515(),
                ModSounds.LASER_SHOOT,
                class_3419.field_15248,
                0.5F,
                shooter.method_37908().field_9229.method_43057() * 0.2F + 1.2F
        );
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);

        if (!user.method_7357().method_7904(itemStack.method_7909())) {
            user.method_7357().method_7906(itemStack.method_7909(), 15); // cooldown

            if (!world.method_8608()) {
                itemStack.method_7956(5, ((class_3218) world), ((class_3222) user),
                        item -> user.method_20235(item, class_1304.field_6173));

                class_1676 laser = new LaserProjectileEntity(ModEntities.LASER_PROJECTILE, world);
                method_7763(user, laser, 0, 3.5f, 0f, user.method_36454(), null);

            }
            return class_1271.method_22427(itemStack);
        } else {
            return class_1271.method_22431(itemStack);
        }
    }


    @Override
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8947;
    }

}