package com.hugouououo.alienmod.mixin;

import com.hugouououo.alienmod.item.custom.RayGunItem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1007;
import net.minecraft.class_1306;
import net.minecraft.class_1799;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_742;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1007.class)
@Environment(EnvType.CLIENT)
public abstract class PlayerEntityRendererMixin {

    @Inject(method = "render(Lnet/minecraft/client/network/AbstractClientPlayerEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V", at = @At("HEAD"))
    private void alienmod$injectRayGunPose(class_742 player, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, CallbackInfo ci) {
        // Obter o modelo do jogador (PlayerEntityModel)
        // Isso é seguro porque `this` é uma instância de PlayerEntityRenderer.
        class_591<class_742> model = ((class_1007)(Object)this).method_4038();

        class_1799 mainHandStack = player.method_6047();
        class_1799 offHandStack = player.method_6079();

        // Define a pose padrão que você deseja
        class_572.class_573 rayGunArmPose = class_572.class_573.field_3408;

        // Verifica se a RayGun está na mão principal ou na secundária e aplica a pose
        if (player.method_6068() == class_1306.field_6183) { // Se a mão principal do jogador é a direita
            if (mainHandStack.method_7909() instanceof RayGunItem) {
                model.field_3395 = rayGunArmPose;
            } else {
                // Se a RayGun não está na mão principal, mas está na secundária,
                // e você quer que a outra mão também adote a pose de arco (como no vanilla),
                // você pode ajustar aqui.
                // No entanto, para ser mais preciso:
                if (offHandStack.method_7909() instanceof RayGunItem) {
                    model.field_3399 = rayGunArmPose;
                    // Se você quiser que a mão principal também se ajuste ao segurar algo na off-hand (como o arco),
                    // você pode adicionar lógica para model.rightArmPose = BipedEntityModel.ArmPose.EMPTY;
                    // ou alguma outra pose de 'prontidão'.
                }
            }
        } else { // Se a mão principal do jogador é a esquerda
            if (mainHandStack.method_7909() instanceof RayGunItem) {
                model.field_3399 = rayGunArmPose;
            } else {
                if (offHandStack.method_7909() instanceof RayGunItem) {
                    model.field_3395 = rayGunArmPose;
                    // Similarmente para a mão direita se a RayGun estiver na mão esquerda
                }
            }
        }
    }
}