package com.hugouououo.alienmod.structures;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.hugouououo.alienmod.AlienMod;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3778;
import net.minecraft.class_3785;
import net.minecraft.class_5434;
import net.minecraft.class_5868;
import net.minecraft.class_6122;
import net.minecraft.class_6880;
import net.minecraft.class_7151;
import net.minecraft.class_8891;
import net.minecraft.class_9778;
import net.minecraft.class_9822;

public class SkyStructures extends class_3195 {

    /// A custom codec that changes the size limit for our code_structure_sky_fan.json's config to not be capped at 7.
    /// With this, we can have a structure with a size limit up to 30 if we want to have extremely long branches of pieces in the structure.
    public static final MapCodec<SkyStructures> CODEC = RecordCodecBuilder.mapCodec(instance ->
                    instance.group(SkyStructures.method_42697(instance),
            class_3785.field_24954.fieldOf("start_pool").forGetter(structure -> structure.startPool),
            class_2960.field_25139.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName),
            Codec.intRange(0, 30).fieldOf("size").forGetter(structure -> structure.size),
            class_6122.field_31540.fieldOf("start_height").forGetter(structure -> structure.startHeight),
            class_2902.class_2903.field_24772.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap),
            Codec.intRange(1, 128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter),
            class_9778.field_51952.optionalFieldOf("dimension_padding", class_5434.field_51911).forGetter(structure -> structure.dimensionPadding),
            class_9822.field_52239.optionalFieldOf("liquid_settings", class_5434.field_52235).forGetter(structure -> structure.liquidSettings)
    ).apply(instance, SkyStructures::new));

    private final class_6880<class_3785> startPool;
    private final Optional<class_2960> startJigsawName;
    private final int size;
    private final class_6122 startHeight;
    private final Optional<class_2902.class_2903> projectStartToHeightmap;
    private final int maxDistanceFromCenter;
    private final class_9778 dimensionPadding;
    private final class_9822 liquidSettings;

    public SkyStructures(class_7302 config,
                         class_6880<class_3785> startPool,
                         Optional<class_2960> startJigsawName,
                         int size,
                         class_6122 startHeight,
                         Optional<class_2902.class_2903> projectStartToHeightmap,
                         int maxDistanceFromCenter,
                         class_9778 dimensionPadding,
                         class_9822 liquidSettings)
    {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.dimensionPadding = dimensionPadding;
        this.liquidSettings = liquidSettings;
    }

    /**
     * This is where extra checks can be done to determine if the structure can spawn here.
     * This only needs to be overridden if you're adding additional spawn conditions.
     *
     * Fun fact, if you set your structure separation/spacing to be 0/1, you can use
     * isFeatureChunk to return true only if certain chunk coordinates are passed in
     * which allows you to spawn structures only at certain coordinates in the world.
     *
     * Basically, this method is used for determining if the land is at a suitable height,
     * if certain other structures are too close or not, or some other restrictive condition.
     *
     * For example, Pillager Outposts added a check to make sure it cannot spawn within 10 chunk of a Village.
     * (Bedrock Edition seems to not have the same check)
     *
     * If you are doing Nether structures, you'll probably want to spawn your structure on top of ledges.
     * Best way to do that is to use getBaseColumn to grab a column of blocks at the structure's x/z position.
     * Then loop through it and look for land with air above it and set blockpos's Y value to it.
     * Make sure to set the final boolean in JigsawPlacement.addPieces to false so
     * that the structure spawns at blockpos's y value instead of placing the structure on the Bedrock roof!
     *
     * Also, please for the love of god, do not do dimension checking here.
     * If you do and another mod's dimension is trying to spawn your structure,
     * the locate command will make minecraft hang forever and break the game.
     * Use the biome tags for where to spawn the structure and users can datapack
     * it to spawn in specific biomes that aren't in the dimension they don't like if they wish.
     */

    private static boolean extraSpawningChecks(class_7149 context) {
        // Grabs the chunk position we are at
        class_1923 chunkpos = context.comp_568();

        // Checks to make sure our structure does not spawn above land that's higher than y = 150
        // to demonstrate how this method is good for checking extra conditions for spawning
        return context.comp_562().method_18028(
                chunkpos.method_8326(),
                chunkpos.method_8328(),
                class_2902.class_2903.field_13203,
                context.comp_569(),
                context.comp_564()) < 300;  // !!! -> Limite de altura
    }

    @Override
    public Optional<class_7150> method_38676(class_7149 context) {

        // Check if the spot is valid for our structure. This is just as another method for cleanness.
        // Returning an empty optional tells the game to skip this spot as it will not generate the structure.
        if (!SkyStructures.extraSpawningChecks(context)) {
            return Optional.empty();
        }

        // Set's our spawning blockpos's y offset.
        int startY = this.startHeight.method_35391(context.comp_566(), new class_5868(context.comp_562(), context.comp_569()));

        // Turns the chunk coordinates into actual coordinates we can use. (Gets corner of that chunk)
        class_1923 chunkPos = context.comp_568();
        class_2338 blockPos = new class_2338(chunkPos.method_8326(), startY, chunkPos.method_8328());

        Optional<class_7150> structurePiecesGenerator =
                class_3778.method_30419(
                    context, // Used for StructurePoolBasedGenerator to get all the proper behaviors done.
                    this.startPool, // The starting pool to use to create the structure layout from
                    this.startJigsawName, // Can be used to only spawn from one Jigsaw block. But we don't need to worry about this.
                    this.size, // How deep a branch of pieces can go away from center piece. (5 means branches cannot be longer than 5 pieces from center piece)
                    blockPos, // Where to spawn the structure.
                    false, // "useExpansionHack" This is for legacy villages to generate properly. You should keep this false always.
                    this.projectStartToHeightmap, // Adds the terrain height's y value to the passed in blockpos's y value. (This uses WORLD_SURFACE_WG heightmap which stops at top water too)
                        // Here at projectStartToHeightmap, start_height's y value is 60 which means the structure spawn 60 blocks above terrain height if start_height and project_start_to_heightmap is defined in structure JSON.
                        // Set projectStartToHeightmap to be empty optional for structure to be place only at the passed in blockpos's Y value instead.
                        // Definitely keep this an empty optional when placing structures in the nether as otherwise, heightmap placing will put the structure on the Bedrock roof.
                    this.maxDistanceFromCenter, // Maximum limit for how far pieces can spawn from center. You cannot set this bigger than 128 or else pieces gets cutoff.
                    class_8891.field_46826, // Optional thing that allows swapping a template pool with another per structure json instance. We don't need this but see vanilla JigsawStructure class for how to wire it up if you want it.
                    this.dimensionPadding, // Optional thing to prevent generating too close to the bottom or top of the dimension.
                    this.liquidSettings); // Optional thing to control whether the structure will be waterlogged when replacing pre-existing water in the world.

        /*
         * Note, you are always free to make your own StructurePoolBasedGenerator class and implementation of how the structure
         * should generate. It is tricky but extremely powerful if you are doing something that vanilla's jigsaw system cannot do.
         * Such as for example, forcing 3 pieces to always spawn every time, limiting how often a piece spawns, or remove the intersection limitation of pieces.
         */

        // Return the pieces generator that is now set up so that the game runs it when it needs to create the layout of structure pieces.
        return structurePiecesGenerator;
    }


    @Override
    public class_7151<?> method_41618() {
        return ModStructures.SKY_STRUCTURES; // Helps the game know how to turn this structure back to json to save to chunks
    }
}
