/*
 * Decompiled with CFR 0.152.
 */
package com.ruanmr.client.config;

import com.ruanmr.client.config.data.AutoCmdData;
import com.ruanmr.client.config.data.AutoMsgData;
import com.ruanmr.client.config.data.ShortcutKeyData;
import com.ruanmr.client.config.data.TimingMsgData;
import com.ruanmr.client.enums.ShortcutKeyRel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import me.shedaniel.clothconfig2.api.Modifier;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Config(name="ryymc")
@Environment(value=EnvType.CLIENT)
public class RyymrConfig
implements ConfigData {
    private Map<String, ShortcutKeyData> shortcutKeyDataMap;
    private TimingMsgData timingMsgData;
    private AutoMsgData autoMsgData;
    private AutoCmdData autoCmdData;
    private String userName;

    public void init() {
        AutoConfig.register(RyymrConfig.class, GsonConfigSerializer::new);
        this.reload();
    }

    public void reload() {
        RyymrConfig config = (RyymrConfig)AutoConfig.getConfigHolder(RyymrConfig.class).getConfig();
        this.setShortcutKeyDataMap(config.getShortcutKeyDataMap());
        this.setTimingMsgData(config.getTimingMsgData());
        this.setAutoMsgData(config.getAutoMsgData());
        this.setAutoCmdData(config.getAutoCmdData());
        this.setUserName(config.getUserName());
        if (this.timingMsgData == null) {
            this.timingMsgData = new TimingMsgData();
            this.timingMsgData.setMsg("\u5927\u5bb6\u597d\u554a\uff0c\u4f60\u4eec\u5728\u505a\u4ec0\u4e48");
            this.timingMsgData.setTime(3600);
        }
        if (this.autoMsgData == null) {
            this.autoMsgData = new AutoMsgData();
            this.autoMsgData.setMsg("\u4f60\u597d\uff0c\u6211\u73b0\u5728\u6709\u4e8b\u4e0d\u5728\uff0c\u8bf7\u7a0d\u5019\u518d\u8054\u7cfb");
        }
        if (this.autoCmdData == null) {
            this.autoCmdData = new AutoCmdData();
        }
        if (this.shortcutKeyDataMap == null) {
            this.shortcutKeyDataMap = new HashMap<String, ShortcutKeyData>();
        }
        ShortcutKeyRel[] values = ShortcutKeyRel.values();
        ArrayList<String> removeKeys = new ArrayList<String>(this.shortcutKeyDataMap.keySet());
        for (ShortcutKeyRel rel : values) {
            ModifierKeyCode defaultData = rel.getDefaultData();
            Modifier modifier = defaultData.getModifier();
            if (this.shortcutKeyDataMap.containsKey(rel.getRelName())) {
                this.shortcutKeyDataMap.get(rel.getRelName()).setDefaultData(defaultData);
            } else {
                this.shortcutKeyDataMap.put(rel.getRelName(), ShortcutKeyData.create(modifier.hasAlt(), modifier.hasControl(), modifier.hasShift(), defaultData.getKeyCode().method_1444(), defaultData));
            }
            removeKeys.remove(rel.getRelName());
        }
        for (String key : removeKeys) {
            this.shortcutKeyDataMap.remove(key);
        }
    }

    public void save() {
        ConfigHolder configHolder = AutoConfig.getConfigHolder(RyymrConfig.class);
        RyymrConfig config = (RyymrConfig)configHolder.getConfig();
        config.setShortcutKeyDataMap(this.getShortcutKeyDataMap());
        config.setTimingMsgData(this.getTimingMsgData());
        config.setAutoMsgData(this.getAutoMsgData());
        config.setAutoCmdData(this.getAutoCmdData());
        config.setUserName(this.getUserName());
        configHolder.save();
    }

    public Map<String, ShortcutKeyData> getShortcutKeyDataMap() {
        return this.shortcutKeyDataMap;
    }

    public void setShortcutKeyDataMap(Map<String, ShortcutKeyData> shortcutKeyDataMap) {
        this.shortcutKeyDataMap = shortcutKeyDataMap;
    }

    public AutoCmdData getAutoCmdData() {
        return this.autoCmdData;
    }

    public void setAutoCmdData(AutoCmdData autoCmdData) {
        this.autoCmdData = autoCmdData;
    }

    public TimingMsgData getTimingMsgData() {
        return this.timingMsgData;
    }

    public void setTimingMsgData(TimingMsgData timingMsgData) {
        this.timingMsgData = timingMsgData;
    }

    public AutoMsgData getAutoMsgData() {
        return this.autoMsgData;
    }

    public void setAutoMsgData(AutoMsgData autoMsgData) {
        this.autoMsgData = autoMsgData;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }
}

