/*
 * Decompiled with CFR 0.152.
 */
package com.ruanmr.client.screen;

import com.nimbusds.oauth2.sdk.util.CollectionUtils;
import com.ruanmr.client.RyymrClient;
import com.ruanmr.client.config.data.AutoCmdData;
import com.ruanmr.client.config.data.AutoCmdExecData;
import com.ruanmr.client.config.data.AutoMsgData;
import com.ruanmr.client.config.data.ShortcutKeyData;
import com.ruanmr.client.config.data.TimingMsgData;
import com.ruanmr.client.enums.ShortcutKeyRel;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.StringListListEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

@Environment(value=EnvType.CLIENT)
public class MainMenuScreen {
    private final ConfigBuilder builder = ConfigBuilder.create();
    private final ConfigEntryBuilder entryBuilder;
    private final ConfigCategory categoryGeneral;
    private final ConfigCategory categoryKeys;
    private boolean isUpdateCmdList = false;

    public MainMenuScreen(class_437 parent) {
        this.builder.setParentScreen(parent);
        this.builder.setTitle(RyymrClient.GLOBAL_FACTORY.getLangText("main.title"));
        this.categoryGeneral = this.builder.getOrCreateCategory(RyymrClient.GLOBAL_FACTORY.getLangText("main.general"));
        this.categoryKeys = this.builder.getOrCreateCategory(RyymrClient.GLOBAL_FACTORY.getLangText("main.keys"));
        this.builder.setSavingRunnable(() -> {
            RyymrClient.RYYMR_CONFIG.save();
            if (this.isUpdateCmdList) {
                RyymrClient.AUTO_CMD_SERVICE.reloadAutoCmd();
            }
        });
        this.entryBuilder = this.builder.entryBuilder();
        this.general();
        this.shortcutKeys();
    }

    private void general() {
        TimingMsgData timingMsgData = RyymrClient.RYYMR_CONFIG.getTimingMsgData();
        this.categoryGeneral.addEntry((AbstractConfigListEntry)this.entryBuilder.startBooleanToggle(RyymrClient.GLOBAL_FACTORY.getLangText("main.general.timingMsg.result"), timingMsgData.isResult()).setTooltip(new class_2561[]{RyymrClient.GLOBAL_FACTORY.getLangText("main.general.timingMsg.result.tip")}).setDefaultValue(false).setSaveConsumer(timingMsgData::setResult).build());
        this.categoryGeneral.addEntry((AbstractConfigListEntry)this.entryBuilder.startTextField(RyymrClient.GLOBAL_FACTORY.getLangText("main.general.timingMsg.msg"), timingMsgData.getMsg()).setTooltip(new class_2561[]{RyymrClient.GLOBAL_FACTORY.getLangText("main.general.timingMsg.msg.tip")}).setSaveConsumer(timingMsgData::setMsg).build());
        this.categoryGeneral.addEntry((AbstractConfigListEntry)this.entryBuilder.startIntField(RyymrClient.GLOBAL_FACTORY.getLangText("main.general.timingMsg.time"), timingMsgData.getTime()).setTooltip(new class_2561[]{RyymrClient.GLOBAL_FACTORY.getLangText("main.general.timingMsg.time.tip")}).setDefaultValue(600).setMin(1).setMax(36000).setSaveConsumer(timingMsgData::setTime).build());
        AutoMsgData autoMsgData = RyymrClient.RYYMR_CONFIG.getAutoMsgData();
        this.categoryGeneral.addEntry((AbstractConfigListEntry)this.entryBuilder.startBooleanToggle(RyymrClient.GLOBAL_FACTORY.getLangText("main.general.autoMsg.result"), autoMsgData.isResult()).setTooltip(new class_2561[]{RyymrClient.GLOBAL_FACTORY.getLangText("main.general.autoMsg.result.tip")}).setDefaultValue(false).setSaveConsumer(autoMsgData::setResult).build());
        this.categoryGeneral.addEntry((AbstractConfigListEntry)this.entryBuilder.startTextField(RyymrClient.GLOBAL_FACTORY.getLangText("main.general.autoMsg.msg"), autoMsgData.getMsg()).setTooltip(new class_2561[]{RyymrClient.GLOBAL_FACTORY.getLangText("main.general.autoMsg.msg.tip")}).setSaveConsumer(autoMsgData::setMsg).build());
        this.categoryGeneral.addEntry((AbstractConfigListEntry)this.entryBuilder.startTextField(RyymrClient.GLOBAL_FACTORY.getLangText("main.general.autoMsg.rules"), StringUtils.join(autoMsgData.getRules(), (String)" ")).setTooltip(new class_2561[]{RyymrClient.GLOBAL_FACTORY.getLangText("main.general.autoMsg.rules.tip")}).setSaveConsumer(newValue -> autoMsgData.setRules(Arrays.asList(StringUtils.split((String)newValue, (String)" ")))).build());
        AutoCmdData autoCmdData = RyymrClient.RYYMR_CONFIG.getAutoCmdData();
        this.categoryGeneral.addEntry((AbstractConfigListEntry)this.entryBuilder.startBooleanToggle(RyymrClient.GLOBAL_FACTORY.getLangText("main.general.isLeftLower"), autoCmdData.isLeftLower()).setTooltip(new class_2561[]{RyymrClient.GLOBAL_FACTORY.getLangText("main.general.isLeftLower.tip")}).setDefaultValue(true).setSaveConsumer(autoCmdData::setLeftLower).build());
        this.categoryGeneral.addEntry((AbstractConfigListEntry)this.entryBuilder.startBooleanToggle(RyymrClient.GLOBAL_FACTORY.getLangText("main.general.autoCmd.result"), autoCmdData.isResult()).setTooltip(new class_2561[]{RyymrClient.GLOBAL_FACTORY.getLangText("main.general.autoCmd.result.tip")}).setDefaultValue(false).setSaveConsumer(autoCmdData::setResult).build());
        List<AutoCmdExecData> autoCmdDatas = autoCmdData.getDatas();
        ArrayList<CallSite> autCmds = new ArrayList<CallSite>();
        for (AutoCmdExecData data : autoCmdDatas) {
            autCmds.add((CallSite)((Object)(data.getCmd() + "---" + data.getSeconds())));
        }
        this.categoryGeneral.addEntry((AbstractConfigListEntry)this.entryBuilder.startStrList(RyymrClient.GLOBAL_FACTORY.getLangText("main.general.autoCmd.datas"), autCmds).setTooltip(new class_2561[]{RyymrClient.GLOBAL_FACTORY.getLangText("main.general.autoCmd.datas.tip")}).setDefaultValue(new ArrayList()).setSaveConsumer(values -> {
            this.isUpdateCmdList = false;
            ArrayList<AutoCmdExecData> list = new ArrayList<AutoCmdExecData>();
            int index = 0;
            if (CollectionUtils.isNotEmpty((Collection)values)) {
                for (String str : values) {
                    int seconds;
                    Object[] split;
                    if (StringUtils.isEmpty((CharSequence)str) || ArrayUtils.isEmpty((Object[])(split = str.split("---"))) || split.length != 2 || StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{split[0], split[1]})) continue;
                    try {
                        seconds = Integer.parseInt((String)split[1]);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    AutoCmdExecData data = new AutoCmdExecData();
                    data.setCmd((String)split[0]);
                    data.setSeconds(seconds);
                    ++index;
                    list.add(data);
                }
            }
            if (list.size() == autoCmdDatas.size()) {
                for (int i = 0; i < list.size(); ++i) {
                    if (((AutoCmdExecData)list.get(i)).equals(autoCmdDatas.get(i))) continue;
                    this.isUpdateCmdList = true;
                    break;
                }
            } else {
                this.isUpdateCmdList = true;
            }
            if (this.isUpdateCmdList) {
                autoCmdData.setDatas(list);
            }
        }).setCreateNewInstance(entity -> new StringListListEntry.StringListCell("\u6307\u4ee4---\u95f4\u9694\u65f6\u95f4", entity)).build());
    }

    private void shortcutKeys() {
        Map<String, ShortcutKeyData> dataMap = RyymrClient.RYYMR_CONFIG.getShortcutKeyDataMap();
        String key = ShortcutKeyRel.Menu.getRelName();
        this.shortcutKeys(key, dataMap.get(key));
        key = ShortcutKeyRel.TimingMsg.getRelName();
        this.shortcutKeys(key, dataMap.get(key));
        key = ShortcutKeyRel.AutoMsg.getRelName();
        this.shortcutKeys(key, dataMap.get(key));
        key = ShortcutKeyRel.AutoCmd.getRelName();
        this.shortcutKeys(key, dataMap.get(key));
        key = ShortcutKeyRel.AutoCmdTop.getRelName();
        this.shortcutKeys(key, dataMap.get(key));
        key = ShortcutKeyRel.AutoCmdNext.getRelName();
        this.shortcutKeys(key, dataMap.get(key));
        key = ShortcutKeyRel.AutoCmdNow.getRelName();
        this.shortcutKeys(key, dataMap.get(key));
        key = ShortcutKeyRel.IsLeftLower.getRelName();
        this.shortcutKeys(key, dataMap.get(key));
    }

    private void shortcutKeys(String key, ShortcutKeyData data) {
        if (key.startsWith("main.shortcutKey")) {
            this.categoryKeys.addEntry((AbstractConfigListEntry)this.entryBuilder.startModifierKeyCodeField(RyymrClient.GLOBAL_FACTORY.getLangText(key), data.modifierKeyCode()).setTooltip(new class_2561[]{RyymrClient.GLOBAL_FACTORY.getLangText(key + ".tip")}).setDefaultValue(data.getDefaultData()).setModifierSaveConsumer(data::modifierKeyCode).build());
        }
    }

    public class_437 builder() {
        return this.builder.build();
    }

    public static class_437 create(class_437 parent) {
        return new MainMenuScreen(parent).builder();
    }
}

