/*
 * Decompiled with CFR 0.152.
 */
package com.ruanmr.client;

import com.ruanmr.client.config.RyymrConfig;
import com.ruanmr.client.factory.GlobalFactory;
import com.ruanmr.client.factory.GlobalFactoryImpl;
import com.ruanmr.client.service.AutoCmdService;
import com.ruanmr.client.service.AutoMsgService;
import com.ruanmr.client.service.ShortcutKeyService;
import com.ruanmr.client.service.TimingMsgService;
import java.lang.reflect.Field;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_320;
import org.apache.commons.lang3.StringUtils;

@Environment(value=EnvType.CLIENT)
public class RyymrClient
implements ClientModInitializer {
    public static final GlobalFactory GLOBAL_FACTORY = new GlobalFactoryImpl();
    public static final RyymrConfig RYYMR_CONFIG = new RyymrConfig();
    public static final TimingMsgService TIMING_MSG_SERVICE = new TimingMsgService();
    public static final AutoMsgService AUTO_MSG_SERVICE = new AutoMsgService();
    public static final AutoCmdService AUTO_CMD_SERVICE = new AutoCmdService();
    public static final ShortcutKeyService SHORTCUT_KEY_SERVICE = new ShortcutKeyService();

    public void onInitializeClient() {
        RYYMR_CONFIG.init();
        TIMING_MSG_SERVICE.init();
        AUTO_MSG_SERVICE.init();
        AUTO_CMD_SERVICE.init();
        SHORTCUT_KEY_SERVICE.init();
        RyymrClient.updatePlayerName(RYYMR_CONFIG.getUserName());
    }

    public static void updatePlayerName(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return;
        }
        try {
            class_320 session = class_310.method_1551().method_1548();
            Field usernameField = session.getClass().getDeclaredField("username");
            usernameField.setAccessible(true);
            usernameField.set(session, name);
        }
        catch (Exception e) {
            GlobalFactory.LOGGER.error("updatePlayerName\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
    }
}

