/*
 * Decompiled with CFR 0.152.
 */
package com.ruanmr.client.service;

import com.nimbusds.oauth2.sdk.util.CollectionUtils;
import com.ruanmr.client.RyymrClient;
import com.ruanmr.client.config.data.AutoCmdData;
import com.ruanmr.client.config.data.AutoCmdExecData;
import com.ruanmr.client.factory.GlobalFactory;
import com.ruanmr.client.utils.DataTypeUtils;
import com.ruanmr.client.utils.PlayerUtils;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_9779;

@Environment(value=EnvType.CLIENT)
public class AutoCmdService {
    protected int lastIndex = 0;
    protected long lastTime = 0L;

    public void init() {
        ClientTickEvents.END_CLIENT_TICK.register(this::onTick);
        HudRenderCallback.EVENT.register(this::onLeftLower);
    }

    public void onLeftLower(class_332 drawContext, class_9779 tickDelta) {
        try {
            class_5250 text;
            class_310 client = class_310.method_1551();
            if (client == null || client.field_1687 == null || client.field_1724 == null || client.field_1690.field_1842) {
                return;
            }
            class_327 textRenderer = client.field_1772;
            AutoCmdData data = RyymrClient.RYYMR_CONFIG.getAutoCmdData();
            if (!data.isResult() || !data.isLeftLower()) {
                return;
            }
            AutoCmdExecData execData = this.getExecData(this.lastIndex, true);
            if (execData == null) {
                text = class_2561.method_43470((String)"\u8fd8\u672a\u8bbe\u7f6e\u6307\u4ee4").method_27692(class_124.field_1061);
            } else {
                if (this.lastTime == 0L) {
                    return;
                }
                long[] timeRemaining = DataTypeUtils.toMinuteAndSeconds((execData.getSeconds() * 1000L - (System.currentTimeMillis() - this.lastTime)) / 1000L);
                text = class_2561.method_43470((String)("|| \u5e8f\u53f7[" + (this.lastIndex + 1) + "/" + data.getDatas().size() + "]\uff0c\u5269\u4f59[" + timeRemaining[0] + ":" + timeRemaining[1] + "]")).method_27692(class_124.field_1080);
            }
            int x = 0;
            int n = client.method_22683().method_4502();
            Objects.requireNonNull(textRenderer);
            int y = n - 9 - 25;
            int n2 = x + textRenderer.method_27525((class_5348)text) + 2;
            Objects.requireNonNull(textRenderer);
            drawContext.method_25294(x - 2, y - 2, n2, y + 9 + 2, 0x40000000);
            drawContext.method_51439(textRenderer, (class_2561)text, x, y, 0xFFFFFF, true);
        }
        catch (Exception e) {
            GlobalFactory.LOGGER.error("\u5de6\u4e0b\u89d2\u63d0\u793a\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
    }

    private void onTick(class_310 client) {
        if (client == null || client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        AutoCmdData data = RyymrClient.RYYMR_CONFIG.getAutoCmdData();
        if (!data.isResult()) {
            return;
        }
        AutoCmdExecData execData = this.getExecData(this.lastIndex, true);
        if (execData == null) {
            return;
        }
        if (System.currentTimeMillis() - this.lastTime > execData.getSeconds() * 1000L) {
            this.exec(execData);
            this.lastTime = System.currentTimeMillis();
            ++this.lastIndex;
        }
    }

    public void reloadAutoCmd() {
        this.lastIndex = 0;
        this.lastTime = 0L;
    }

    protected void execNow() {
        this.exec(this.lastIndex);
    }

    protected void execTop() {
        this.exec(this.lastIndex - 1);
    }

    protected void execNext() {
        this.exec(this.lastIndex + 1);
    }

    protected void exec(int index) {
        AutoCmdExecData execData = this.getExecData(index, true);
        if (execData == null) {
            return;
        }
        this.exec(execData);
    }

    protected void exec(AutoCmdExecData execData) {
        try {
            PlayerUtils.sendChatCommand(execData.getCmd());
            PlayerUtils.sendMessage("\u6267\u884c\u6307\u4ee4\uff1a" + execData.getCmd() + "\uff0c\u5e8f\u53f7\uff1a" + (this.lastIndex + 1) + "\uff0c\u8ddd\u79bb\u4e0b\u6b21\uff1a" + execData.getSeconds() + "\u79d2", class_124.field_1076, true);
        }
        catch (Exception e) {
            GlobalFactory.LOGGER.error("\u81ea\u52a8\u5faa\u73af\u6267\u884c\u6307\u4ee4\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
    }

    protected AutoCmdExecData getExecData(int index, boolean isUpdateLastIndex) {
        List<AutoCmdExecData> execDatas = RyymrClient.RYYMR_CONFIG.getAutoCmdData().getDatas();
        if (CollectionUtils.isEmpty(execDatas)) {
            return null;
        }
        if (index >= execDatas.size()) {
            index = 0;
        }
        if (index < 0) {
            index = execDatas.size() - 1;
        }
        if (isUpdateLastIndex) {
            this.lastIndex = index;
        }
        return execDatas.get(index);
    }
}

