/*
 * Decompiled with CFR 0.152.
 */
package com.ruanmr.client.utils;

import com.nimbusds.oauth2.sdk.util.CollectionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class InputKeyUtils {
    private static final Map<Integer, String> GLFW_KEY_MAP = new HashMap<Integer, String>();
    private static final String Key_Unknown = "None";

    private static void initKeyboardMapping() {
        GLFW_KEY_MAP.put(65, "A");
        GLFW_KEY_MAP.put(66, "B");
        GLFW_KEY_MAP.put(67, "C");
        GLFW_KEY_MAP.put(68, "D");
        GLFW_KEY_MAP.put(69, "E");
        GLFW_KEY_MAP.put(70, "F");
        GLFW_KEY_MAP.put(71, "G");
        GLFW_KEY_MAP.put(72, "H");
        GLFW_KEY_MAP.put(73, "I");
        GLFW_KEY_MAP.put(74, "J");
        GLFW_KEY_MAP.put(75, "K");
        GLFW_KEY_MAP.put(76, "L");
        GLFW_KEY_MAP.put(77, "M");
        GLFW_KEY_MAP.put(78, "N");
        GLFW_KEY_MAP.put(79, "O");
        GLFW_KEY_MAP.put(80, "P");
        GLFW_KEY_MAP.put(81, "Q");
        GLFW_KEY_MAP.put(82, "R");
        GLFW_KEY_MAP.put(83, "S");
        GLFW_KEY_MAP.put(84, "T");
        GLFW_KEY_MAP.put(85, "U");
        GLFW_KEY_MAP.put(86, "V");
        GLFW_KEY_MAP.put(87, "W");
        GLFW_KEY_MAP.put(88, "X");
        GLFW_KEY_MAP.put(89, "Y");
        GLFW_KEY_MAP.put(90, "Z");
        GLFW_KEY_MAP.put(48, "0");
        GLFW_KEY_MAP.put(49, "1");
        GLFW_KEY_MAP.put(50, "2");
        GLFW_KEY_MAP.put(51, "3");
        GLFW_KEY_MAP.put(52, "4");
        GLFW_KEY_MAP.put(53, "5");
        GLFW_KEY_MAP.put(54, "6");
        GLFW_KEY_MAP.put(55, "7");
        GLFW_KEY_MAP.put(56, "8");
        GLFW_KEY_MAP.put(57, "9");
        GLFW_KEY_MAP.put(290, "F1");
        GLFW_KEY_MAP.put(291, "F2");
        GLFW_KEY_MAP.put(292, "F3");
        GLFW_KEY_MAP.put(293, "F4");
        GLFW_KEY_MAP.put(294, "F5");
        GLFW_KEY_MAP.put(295, "F6");
        GLFW_KEY_MAP.put(296, "F7");
        GLFW_KEY_MAP.put(297, "F8");
        GLFW_KEY_MAP.put(298, "F9");
        GLFW_KEY_MAP.put(299, "F10");
        GLFW_KEY_MAP.put(300, "F11");
        GLFW_KEY_MAP.put(301, "F12");
        GLFW_KEY_MAP.put(302, "F13");
        GLFW_KEY_MAP.put(303, "F14");
        GLFW_KEY_MAP.put(304, "F15");
        GLFW_KEY_MAP.put(305, "F16");
        GLFW_KEY_MAP.put(306, "F17");
        GLFW_KEY_MAP.put(307, "F18");
        GLFW_KEY_MAP.put(308, "F19");
        GLFW_KEY_MAP.put(309, "F20");
        GLFW_KEY_MAP.put(310, "F21");
        GLFW_KEY_MAP.put(311, "F22");
        GLFW_KEY_MAP.put(312, "F23");
        GLFW_KEY_MAP.put(313, "F24");
        GLFW_KEY_MAP.put(32, "Space");
        GLFW_KEY_MAP.put(256, "Escape");
        GLFW_KEY_MAP.put(257, "Enter");
        GLFW_KEY_MAP.put(258, "Tab");
        GLFW_KEY_MAP.put(259, "Backspace");
        GLFW_KEY_MAP.put(260, "Insert");
        GLFW_KEY_MAP.put(261, "Delete");
        GLFW_KEY_MAP.put(262, "Right");
        GLFW_KEY_MAP.put(263, "Left");
        GLFW_KEY_MAP.put(264, "Down");
        GLFW_KEY_MAP.put(265, "Up");
        GLFW_KEY_MAP.put(266, "Page_Up");
        GLFW_KEY_MAP.put(267, "Page_Down");
        GLFW_KEY_MAP.put(268, "Home");
        GLFW_KEY_MAP.put(269, "End");
        GLFW_KEY_MAP.put(280, "Caps_Lock");
        GLFW_KEY_MAP.put(281, "Scroll_Lock");
        GLFW_KEY_MAP.put(282, "Num_Lock");
        GLFW_KEY_MAP.put(283, "Print_Screen");
        GLFW_KEY_MAP.put(284, "Pause");
        GLFW_KEY_MAP.put(340, "Left_Shift");
        GLFW_KEY_MAP.put(341, "Left_Ctrl");
        GLFW_KEY_MAP.put(342, "Left_Alt");
        GLFW_KEY_MAP.put(343, "Left_Super");
        GLFW_KEY_MAP.put(344, "Right_Shift");
        GLFW_KEY_MAP.put(345, "Right_Ctrl");
        GLFW_KEY_MAP.put(346, "Right_Alt");
        GLFW_KEY_MAP.put(347, "Right_Super");
        GLFW_KEY_MAP.put(348, "Menu");
        GLFW_KEY_MAP.put(39, "'");
        GLFW_KEY_MAP.put(44, ",");
        GLFW_KEY_MAP.put(45, "-");
        GLFW_KEY_MAP.put(46, ".");
        GLFW_KEY_MAP.put(47, "/");
        GLFW_KEY_MAP.put(59, ";");
        GLFW_KEY_MAP.put(61, "=");
        GLFW_KEY_MAP.put(91, "[");
        GLFW_KEY_MAP.put(92, "\\");
        GLFW_KEY_MAP.put(93, "]");
        GLFW_KEY_MAP.put(96, "`");
        GLFW_KEY_MAP.put(320, "Kp_0");
        GLFW_KEY_MAP.put(321, "Kp_1");
        GLFW_KEY_MAP.put(322, "Kp_2");
        GLFW_KEY_MAP.put(323, "Kp_3");
        GLFW_KEY_MAP.put(324, "Kp_4");
        GLFW_KEY_MAP.put(325, "Kp_5");
        GLFW_KEY_MAP.put(326, "Kp_6");
        GLFW_KEY_MAP.put(327, "Kp_7");
        GLFW_KEY_MAP.put(328, "Kp_8");
        GLFW_KEY_MAP.put(329, "Kp_9");
        GLFW_KEY_MAP.put(330, "Kp_.");
        GLFW_KEY_MAP.put(331, "Kp_/");
        GLFW_KEY_MAP.put(332, "Kp_*");
        GLFW_KEY_MAP.put(333, "Kp_-");
        GLFW_KEY_MAP.put(334, "Kp_+");
        GLFW_KEY_MAP.put(335, "Kp_Enter");
        GLFW_KEY_MAP.put(336, "Kp_=");
        GLFW_KEY_MAP.put(161, "World_1");
        GLFW_KEY_MAP.put(162, "World_2");
    }

    private static void initMouseMapping() {
        GLFW_KEY_MAP.put(0, "Button_Left");
        GLFW_KEY_MAP.put(1, "Button_Right");
        GLFW_KEY_MAP.put(2, "Button_Middle");
        GLFW_KEY_MAP.put(3, "Button_4");
        GLFW_KEY_MAP.put(4, "Button_5");
        GLFW_KEY_MAP.put(5, "Button_6");
        GLFW_KEY_MAP.put(6, "Button_7");
        GLFW_KEY_MAP.put(7, "Button_8");
    }

    public static String getKeyName(int keyCode) {
        return GLFW_KEY_MAP.getOrDefault(keyCode, Key_Unknown);
    }

    public static List<String> getKeyNames(List<Integer> keyCodes) {
        if (CollectionUtils.isEmpty(keyCodes)) {
            return List.of(Key_Unknown);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i : keyCodes) {
            list.add(InputKeyUtils.getKeyName(i));
        }
        return list;
    }

    public static Map<Integer, String> getMapping() {
        return new HashMap<Integer, String>(GLFW_KEY_MAP);
    }

    public static boolean isMouseButton(int keyCode) {
        return keyCode >= 0 && keyCode <= 7;
    }

    public static boolean isKeyboardKey(int keyCode) {
        return !InputKeyUtils.isMouseButton(keyCode);
    }

    static {
        InputKeyUtils.initKeyboardMapping();
        InputKeyUtils.initMouseMapping();
    }
}

