/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.api.modules.template;

import net.creeperhost.polylib.data.serializable.BooleanData;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import vswe.stevescarts.api.modules.template.ModuleStorage;
import vswe.stevescarts.api.slots.SlotChest;
import vswe.stevescarts.api.slots.SlotStevesCarts;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.entities.ModularMinecart;
import vswe.stevescarts.polylib.EntityData;

public abstract class ModuleChest
extends ModuleStorage {
    private float chestAngle;
    private final EntityData<Boolean> isOpen = new EntityData(this.getCart(), new BooleanData(false));

    public ModuleChest(ModularMinecart cart) {
        super(cart);
    }

    @Override
    public void update() {
        super.update();
        this.handleChest();
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    protected SlotStevesCarts getSlot(int slotId, int x, int y) {
        return new SlotChest(this.getCart(), slotId, 8 + x * 18, 16 + y * 18);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.drawString(guiGraphics, gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    public int guiWidth() {
        return 15 + this.getInventoryWidth() * 18;
    }

    @Override
    public int guiHeight() {
        return 20 + this.getInventoryHeight() * 18;
    }

    public float getChestAngle() {
        return this.chestAngle;
    }

    protected boolean lidClosed() {
        return this.chestAngle <= 0.0f;
    }

    protected float getLidSpeed() {
        return 0.15707964f;
    }

    protected float chestFullyOpenAngle() {
        return 1.3744469f;
    }

    protected boolean hasVisualChest() {
        return true;
    }

    protected boolean playChestSound() {
        return this.hasVisualChest();
    }

    public void openChest() {
        if (this.hasVisualChest()) {
            this.isOpen.set(true);
        }
    }

    public void closeChest() {
        if (this.hasVisualChest()) {
            this.isOpen.set(false);
        }
    }

    protected boolean isChestActive() {
        if (!this.hasVisualChest()) {
            return false;
        }
        if (this.isPlaceholder()) {
            return this.getSimInfo().getChestActive();
        }
        return this.isOpen.get();
    }

    protected void handleChest() {
        if (!this.hasVisualChest()) {
            return;
        }
        if (this.isChestActive() && this.lidClosed() && this.playChestSound()) {
            this.getCart().level().playSound(null, this.getCart().blockPosition(), SoundEvents.CHEST_OPEN, SoundSource.PLAYERS, 0.5f, this.getCart().level().random.nextFloat() * 0.1f + 0.9f);
        }
        if (this.isChestActive() && this.chestAngle < this.chestFullyOpenAngle()) {
            this.chestAngle += this.getLidSpeed();
            if (this.chestAngle > this.chestFullyOpenAngle()) {
                this.chestAngle = this.chestFullyOpenAngle();
            }
        } else if (!this.isChestActive() && !this.lidClosed()) {
            float lastAngle = this.chestAngle;
            this.chestAngle -= this.getLidSpeed();
            if ((double)this.chestAngle < 1.1780972450961724 && (double)lastAngle >= 1.1780972450961724 && this.playChestSound()) {
                this.getCart().level().playSound(null, this.getCart().blockPosition(), SoundEvents.CHEST_CLOSE, SoundSource.PLAYERS, 0.5f, this.getCart().level().random.nextFloat() * 0.1f + 0.9f);
            }
            if (this.chestAngle < 0.0f) {
                this.chestAngle = 0.0f;
            }
        }
    }

    public boolean isCompletelyFilled() {
        for (int i = 0; i < this.getInventorySize(); ++i) {
            if (!this.getStack(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isCompletelyEmpty() {
        for (int i = 0; i < this.getInventorySize(); ++i) {
            if (this.getStack(i).isEmpty()) continue;
            return false;
        }
        return true;
    }
}

