/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.arcade.invaders;

import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import vswe.stevescarts.arcade.ArcadeGame;
import vswe.stevescarts.arcade.invaders.Building;
import vswe.stevescarts.arcade.invaders.InvaderGhast;
import vswe.stevescarts.arcade.invaders.Player;
import vswe.stevescarts.arcade.invaders.Projectile;
import vswe.stevescarts.arcade.invaders.Unit;
import vswe.stevescarts.arcade.tracks.TrackStory;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.realtimers.ModuleArcade;

public class ArcadeInvaders
extends ArcadeGame {
    protected ArrayList<Unit> invaders = new ArrayList();
    private final ArrayList<Player> lives;
    private final ArrayList<Unit> buildings = new ArrayList();
    protected ArrayList<Projectile> projectiles;
    private Player player;
    protected int moveDirection;
    protected int moveSpeed;
    protected int moveDown;
    private int fireDelay;
    private int score;
    private int highscore;
    protected boolean hasPahighast;
    protected boolean canSpawnPahighast;
    private boolean newHighscore;
    private int gameoverCounter;
    private static String texture = "/gui/invaders.png";
    private static final String[][] numbers = new String[][]{{"XXXX", "X  X", "X  X", "X  X", "X  X", "X  X", "XXXX"}, {"   X", "   X", "   X", "   X", "   X", "   X", "   X"}, {"XXXX", "   X", "   X", "XXXX", "X   ", "X   ", "XXXX"}, {"XXXX", "   X", "   X", "XXXX", "   X", "   X", "XXXX"}, {"X  X", "X  X", "X  X", "XXXX", "   X", "   X", "   X"}, {"XXXX", "X   ", "X   ", "XXXX", "   X", "   X", "XXXX"}, {"XXXX", "X   ", "X   ", "XXXX", "X  X", "X  X", "XXXX"}, {"XXXX", "   X", "   X", "   X", "   X", "   X", "   X"}, {"XXXX", "X  X", "X  X", "XXXX", "X  X", "X  X", "XXXX"}, {"XXXX", "X  X", "X  X", "XXXX", "   X", "   X", "XXXX"}};

    public ArcadeInvaders(ModuleArcade module) {
        super(module, Localization.ARCADE.GHAST);
        this.lives = new ArrayList();
        this.projectiles = new ArrayList();
        this.start();
    }

    private void start() {
        int i;
        this.buildings.clear();
        this.lives.clear();
        this.projectiles.clear();
        this.player = new Player(this);
        for (i = 0; i < 3; ++i) {
            this.lives.add(new Player(this, 10 + i * 20, 190));
        }
        for (i = 0; i < 4; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.buildings.add(new Building(this, 48 + i * 96 + j * 16, 120));
            }
        }
        this.moveSpeed = 0;
        this.fireDelay = 0;
        this.score = 0;
        this.canSpawnPahighast = false;
        this.newHighscore = false;
        this.spawnInvaders();
    }

    private void spawnInvaders() {
        this.invaders.clear();
        this.hasPahighast = false;
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < 14; ++i) {
                this.invaders.add(new InvaderGhast(this, 20 + i * 20, 10 + 25 * j));
            }
        }
        ++this.moveSpeed;
        this.moveDirection = 1;
        this.moveDown = 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void update() {
        super.update();
        if (this.player != null) {
            if (this.player.ready) {
                int i;
                boolean flag = false;
                boolean flag2 = false;
                for (i = this.invaders.size() - 1; i >= 0; --i) {
                    Unit invader = this.invaders.get(i);
                    Unit.UPDATE_RESULT result = invader.update();
                    if (result == Unit.UPDATE_RESULT.DEAD) {
                        if (((InvaderGhast)invader).isPahighast) {
                            this.hasPahighast = false;
                        }
                        ArcadeGame.playSound(SoundEvents.GHAST_HURT, 0.15f, 1.0f);
                        this.invaders.remove(i);
                        ++this.score;
                        continue;
                    }
                    if (result == Unit.UPDATE_RESULT.TURN_BACK) {
                        flag = true;
                        continue;
                    }
                    if (result != Unit.UPDATE_RESULT.GAME_OVER) continue;
                    flag2 = true;
                }
                if (this.moveDown > 0) {
                    --this.moveDown;
                }
                if (flag) {
                    this.moveDirection *= -1;
                    this.moveDown = 5;
                }
                if (this.invaders.size() == 0 || this.hasPahighast && this.invaders.size() == 1) {
                    this.score += this.hasPahighast ? 200 : 50;
                    this.canSpawnPahighast = true;
                    this.spawnInvaders();
                }
                if (flag2) {
                    this.lives.clear();
                    this.projectiles.clear();
                    this.player = null;
                    this.newHighScore();
                    return;
                }
                for (i = this.buildings.size() - 1; i >= 0; --i) {
                    if (this.buildings.get(i).update() != Unit.UPDATE_RESULT.DEAD) continue;
                    this.buildings.remove(i);
                }
                for (i = this.projectiles.size() - 1; i >= 0; --i) {
                    if (this.projectiles.get(i).update() != Unit.UPDATE_RESULT.DEAD) continue;
                    this.projectiles.remove(i);
                }
                if (this.isKeyDown(65)) {
                    this.player.move(-1);
                } else if (this.isKeyDown(68)) {
                    this.player.move(1);
                }
                if (this.fireDelay == 0 && this.isKeyDown(87)) {
                    this.projectiles.add(new Projectile(this, this.player.x + 8 - 2, this.player.y - 15, true));
                    ArcadeGame.playSound(SoundEvents.ARROW_SHOOT, 0.8f, 1.0f / (this.getModule().getCart().getRandom().nextFloat() * 0.4f + 1.2f) + 0.5f);
                    this.fireDelay = 10;
                } else if (this.fireDelay > 0) {
                    --this.fireDelay;
                }
            }
            if (this.player.update() == Unit.UPDATE_RESULT.DEAD) {
                this.projectiles.clear();
                if (this.lives.size() != 0) {
                    this.lives.get(0).setTarget(this.player.x, this.player.y);
                    this.player = this.lives.get(0);
                    this.lives.remove(0);
                } else {
                    this.player = null;
                    this.newHighScore();
                }
            }
        } else if (this.gameoverCounter == 0) {
            boolean flag = false;
            for (int j = this.invaders.size() - 1; j >= 0; --j) {
                Unit invader2 = this.invaders.get(j);
                if (invader2.update() != Unit.UPDATE_RESULT.TARGET) continue;
                flag = true;
            }
            if (!flag) {
                this.gameoverCounter = 1;
            }
        } else if (this.newHighscore && this.gameoverCounter < 5) {
            ++this.gameoverCounter;
            if (this.gameoverCounter == 5) {
                // empty if block
            }
        }
    }

    public boolean isKeyDown(int id) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(GuiGraphics guiGraphics, GuiMinecart gui, int x, int y) {
        int i;
        ResourceLocation texture = ResourceHelper.getResource(ArcadeInvaders.texture);
        for (i = 0; i < 27; ++i) {
            this.getModule().drawImage(guiGraphics, texture, gui, 5 + i * 16, 150, 16, 32, 16, 16);
        }
        for (i = 0; i < 5; ++i) {
            this.getModule().drawImage(guiGraphics, texture, gui, 3 + i * 16, 190, 16, 32, 16, 16);
        }
        for (Unit unit : this.invaders) {
            unit.draw(guiGraphics, texture, gui);
        }
        if (this.player != null) {
            this.player.draw(guiGraphics, texture, gui);
        }
        for (Unit unit : this.lives) {
            unit.draw(guiGraphics, texture, gui);
        }
        for (Unit unit : this.projectiles) {
            unit.draw(guiGraphics, texture, gui);
        }
        for (Unit unit : this.buildings) {
            unit.draw(guiGraphics, texture, gui);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(GuiGraphics guiGraphics, GuiMinecart gui) {
        this.getModule().drawString(guiGraphics, gui, Localization.ARCADE.EXTRA_LIVES.translate(new String[0]) + ":", 10, 180, 0x404040);
        this.getModule().drawString(guiGraphics, gui, Localization.ARCADE.HIGH_SCORE.translate(String.valueOf(this.highscore)), 10, 210, 0x404040);
        this.getModule().drawString(guiGraphics, gui, Localization.ARCADE.SCORE.translate(String.valueOf(this.score)), 10, 220, 0x404040);
        this.getModule().drawString(guiGraphics, gui, "W - " + Localization.ARCADE.INSTRUCTION_SHOOT.translate(new String[0]), 330, 180, 0x404040);
        this.getModule().drawString(guiGraphics, gui, "A - " + Localization.ARCADE.INSTRUCTION_LEFT.translate(new String[0]), 330, 190, 0x404040);
        this.getModule().drawString(guiGraphics, gui, "D - " + Localization.ARCADE.INSTRUCTION_RIGHT.translate(new String[0]), 330, 200, 0x404040);
        this.getModule().drawString(guiGraphics, gui, "R - " + Localization.ARCADE.INSTRUCTION_RESTART.translate(new String[0]), 330, 220, 0x404040);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void keyPress(GuiMinecart gui, int character, int extraInformation) {
        if (character == 19) {
            this.start();
        }
    }

    private void newHighScore() {
        int i;
        this.buildings.clear();
        int digits = this.score == 0 ? 1 : (int)Math.floor(Math.log10(this.score)) + 1;
        this.canSpawnPahighast = false;
        int currentGhast = 0;
        for (i = 0; i < digits; ++i) {
            int digit = this.score / (int)Math.pow(10.0, digits - i - 1) % 10;
            String[] number = numbers[digit];
            for (int j = 0; j < number.length; ++j) {
                String line = number[j];
                for (int k = 0; k < line.length(); ++k) {
                    InvaderGhast ghast;
                    if (line.charAt(k) != 'X') continue;
                    int x = (443 - (digits * 90 - 10)) / 2 + i * 90 + k * 20;
                    int y = 5 + j * 20;
                    if (currentGhast >= this.invaders.size()) {
                        ghast = new InvaderGhast(this, x, -20);
                        this.invaders.add(ghast);
                        ++currentGhast;
                    } else {
                        ghast = (InvaderGhast)this.invaders.get(currentGhast++);
                    }
                    ghast.setTarget(x, y);
                }
            }
        }
        for (i = currentGhast; i < this.invaders.size(); ++i) {
            InvaderGhast ghast2 = (InvaderGhast)this.invaders.get(i);
            ghast2.setTarget(ghast2.x, -25);
        }
        this.gameoverCounter = 0;
        if (this.score > this.highscore) {
            this.newHighscore = true;
            int val = this.score;
            byte byte1 = (byte)(val & 0xFF);
            byte byte2 = (byte)((val & 0xFF00) >> 8);
            this.getModule().sendPacket(2, new byte[]{byte1, byte2});
        }
    }

    @Override
    public void receivePacket(int id, byte[] data, net.minecraft.world.entity.player.Player player) {
        if (id == 2) {
            short data2 = data[0];
            short data3 = data[1];
            if (data2 < 0) {
                data2 = (short)(data2 + 256);
            }
            if (data3 < 0) {
                data3 = (short)(data3 + 256);
            }
            this.highscore = data2 | data3 << 8;
        }
    }

    @Override
    public void checkGuiData(Object[] info) {
        this.getModule().updateGuiData(info, TrackStory.stories.size() + 1, (short)this.highscore);
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id == TrackStory.stories.size() + 1) {
            this.highscore = data;
        }
    }

    @Override
    public void Save(ValueOutput output, int id) {
        output.putShort(this.getModule().generateNBTName("HighscoreGhast", id), (short)this.highscore);
    }

    @Override
    public void Load(ValueInput input, int id) {
        this.highscore = input.getShortOr(this.getModule().generateNBTName("HighscoreGhast", id), (short)0);
    }
}

