/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.arcade.tetris;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import vswe.stevescarts.arcade.tetris.ArcadeTetris;
import vswe.stevescarts.arcade.tetris.TetrisBlock;
import vswe.stevescarts.client.guis.GuiMinecart;

public class TetrisPiecePart {
    private TetrisBlock block;
    private int offX;
    private int offY;

    public TetrisPiecePart(TetrisBlock block, int offX, int offY) {
        this.block = block;
        this.offX = offX;
        this.offY = offY;
    }

    public void render(GuiGraphics guiGraphics, ResourceLocation texture, ArcadeTetris game, GuiMinecart gui, int x, int y) {
        this.block.render(guiGraphics, texture, game, gui, x + this.offX, y + this.offY);
    }

    public void rotate(int offSet) {
        this.block.rotate();
        int temp = this.offX;
        this.offX = -this.offY + offSet;
        this.offY = temp;
    }

    public void placeInBoard(TetrisBlock[][] board, int x, int y) {
        board[x + this.offX][y + this.offY] = this.block;
    }

    public boolean canMoveTo(TetrisBlock[][] board, int x, int y) {
        return this.isValidAt(board, x + this.offX, y + this.offY);
    }

    public boolean isValidAt(TetrisBlock[][] board, int x, int y) {
        return x >= 0 && x < board.length && y < board[0].length && (y < 0 || board[x][y] == null);
    }

    public boolean canRotate(TetrisBlock[][] board, int x, int y, int offSet) {
        return this.isValidAt(board, x - this.offY + offSet, y + this.offX);
    }

    public boolean canPlaceInBoard(int y) {
        return y + this.offY >= 0;
    }
}

