/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.arcade.tracks;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import vswe.stevescarts.arcade.tracks.ArcadeTracks;
import vswe.stevescarts.arcade.tracks.TrackOrientation;
import vswe.stevescarts.client.guis.GuiMinecart;

public class Cart {
    private int x;
    private int y;
    private TrackOrientation.DIRECTION dir;
    private int imageIndex;
    private boolean enabled;

    public Cart(int imageIndex) {
        this.imageIndex = imageIndex;
        this.enabled = true;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public TrackOrientation.DIRECTION getDireciotn() {
        return this.dir;
    }

    public void setX(int val) {
        this.x = val;
    }

    public void setY(int val) {
        this.y = val;
    }

    public void setDirection(TrackOrientation.DIRECTION val) {
        this.dir = val;
    }

    public void setAlive(boolean val) {
        this.enabled = val;
    }

    public void move(ArcadeTracks game) {
        if (!this.enabled) {
            return;
        }
        this.x += this.dir.getX();
        this.y += this.dir.getY();
        if (this.x < 0 || this.y < 0 || this.x >= game.getTrackMap().length || this.y >= game.getTrackMap()[0].length || game.getTrackMap()[this.x][this.y] == null) {
            if (this.dir != TrackOrientation.DIRECTION.STILL) {
                this.onCrash();
            }
            this.dir = TrackOrientation.DIRECTION.STILL;
        } else {
            game.getTrackMap()[this.x][this.y].travel(game, this);
            this.dir = game.getTrackMap()[this.x][this.y].getOrientation().travel(this.dir.getOpposite());
        }
        if (game.isItemOnGround() && this.x == game.getItemX() && this.y == game.getItemY()) {
            this.onItemPickUp();
            game.pickItemUp();
        }
    }

    public void onItemPickUp() {
    }

    public void onCrash() {
    }

    public void render(GuiGraphics guiGraphics, ResourceLocation texture, ArcadeTracks game, GuiMinecart gui, int tick) {
        if (!this.enabled) {
            return;
        }
        int x = 7 + (int)(16.0f * ((float)this.x + (float)this.dir.getX() * ((float)tick / 4.0f)));
        int y = 7 + (int)(16.0f * ((float)this.y + (float)this.dir.getY() * ((float)tick / 4.0f)));
        int u = 256 - 12 * (this.imageIndex + 1);
        int v = 244;
        int w = 12;
        int h = 12;
        game.drawImageInArea(guiGraphics, texture, gui, x, y, u, 244, 12, 12);
    }

    public boolean isAlive() {
        return this.enabled;
    }
}

