/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.NewMinecartBehavior;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.entities.ModularMinecart;

public class BlockRailJunction
extends BaseRailBlock {
    public static final MapCodec<BlockRailJunction> CODEC = BlockRailJunction.simpleCodec(BlockRailJunction::new);
    public static final EnumProperty<RailShape> SHAPE = BlockStateProperties.RAIL_SHAPE_STRAIGHT;

    public BlockRailJunction(BlockBehaviour.Properties builder) {
        super(true, builder);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(SHAPE, (Comparable)RailShape.NORTH_SOUTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SHAPE, WATERLOGGED});
    }

    @NotNull
    public Property<RailShape> getShapeProperty() {
        return SHAPE;
    }

    public boolean canMakeSlopes(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    @NotNull
    public RailShape getRailDirection(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @Nullable AbstractMinecart cart) {
        ModularMinecart modularMinecart;
        RailShape railShape;
        if (cart instanceof ModularMinecart && (railShape = (modularMinecart = (ModularMinecart)cart).getRailDirection(pos)) != null) {
            return railShape;
        }
        if (cart != null) {
            Direction direction = cart.behavior.getMotionDirection();
            if (cart.behavior instanceof NewMinecartBehavior) {
                direction = direction.getCounterClockWise();
            }
            return switch (direction) {
                case Direction.NORTH -> RailShape.NORTH_SOUTH;
                case Direction.SOUTH -> RailShape.NORTH_SOUTH;
                case Direction.WEST -> RailShape.EAST_WEST;
                case Direction.EAST -> RailShape.EAST_WEST;
                default -> super.getRailDirection(state, world, pos, cart);
            };
        }
        return super.getRailDirection(state, world, pos, cart);
    }

    protected MapCodec<? extends BaseRailBlock> codec() {
        return CODEC;
    }
}

