/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks.tileentities;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.api.slots.SlotChest;
import vswe.stevescarts.blocks.BlockCargoManager;
import vswe.stevescarts.blocks.tileentities.TileEntityManager;
import vswe.stevescarts.containers.ContainerCargo;
import vswe.stevescarts.containers.slots.ISlotExplosions;
import vswe.stevescarts.containers.slots.SlotArrow;
import vswe.stevescarts.containers.slots.SlotBridge;
import vswe.stevescarts.containers.slots.SlotBuilder;
import vswe.stevescarts.containers.slots.SlotCake;
import vswe.stevescarts.containers.slots.SlotCargo;
import vswe.stevescarts.containers.slots.SlotFertilizer;
import vswe.stevescarts.containers.slots.SlotFirework;
import vswe.stevescarts.containers.slots.SlotFuel;
import vswe.stevescarts.containers.slots.SlotMilker;
import vswe.stevescarts.containers.slots.SlotSapling;
import vswe.stevescarts.containers.slots.SlotSeed;
import vswe.stevescarts.containers.slots.SlotTorch;
import vswe.stevescarts.helpers.CargoItemSelection;
import vswe.stevescarts.helpers.ComponentTypes;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.storages.TransferHandler;
import vswe.stevescarts.helpers.storages.TransferManager;
import vswe.stevescarts.init.ModBlocks;
import vswe.stevescarts.init.ModItems;
import vswe.stevescarts.init.StevesCartsModules;

public class TileEntityCargo
extends TileEntityManager
implements MenuProvider {
    public static ArrayList<CargoItemSelection> itemSelections;
    public int[] target;
    public ArrayList<SlotCargo> cargoSlots;
    public int lastLayout = -1;
    private TransferManager latestTransferToBeUsed;
    protected final SimpleContainerData dataAccess = new SimpleContainerData(21){

        public int get(int id) {
            return switch (id) {
                case 0 -> TileEntityCargo.this.layoutType;
                case 1 -> TileEntityCargo.this.color[0];
                case 2 -> TileEntityCargo.this.color[1];
                case 3 -> TileEntityCargo.this.color[2];
                case 4 -> TileEntityCargo.this.color[3];
                case 5 -> {
                    if (TileEntityCargo.this.toCart[0]) {
                        yield 1;
                    }
                    yield 0;
                }
                case 6 -> {
                    if (TileEntityCargo.this.toCart[1]) {
                        yield 1;
                    }
                    yield 0;
                }
                case 7 -> {
                    if (TileEntityCargo.this.toCart[2]) {
                        yield 1;
                    }
                    yield 0;
                }
                case 8 -> {
                    if (TileEntityCargo.this.toCart[3]) {
                        yield 1;
                    }
                    yield 0;
                }
                case 9 -> TileEntityCargo.this.target[0];
                case 10 -> TileEntityCargo.this.target[1];
                case 11 -> TileEntityCargo.this.target[2];
                case 12 -> TileEntityCargo.this.target[3];
                case 13 -> {
                    if (TileEntityCargo.this.doReturn[0]) {
                        yield 1;
                    }
                    yield 0;
                }
                case 14 -> {
                    if (TileEntityCargo.this.doReturn[1]) {
                        yield 1;
                    }
                    yield 0;
                }
                case 15 -> {
                    if (TileEntityCargo.this.doReturn[2]) {
                        yield 1;
                    }
                    yield 0;
                }
                case 16 -> {
                    if (TileEntityCargo.this.doReturn[3]) {
                        yield 1;
                    }
                    yield 0;
                }
                case 17 -> TileEntityCargo.this.amount[0];
                case 18 -> TileEntityCargo.this.amount[1];
                case 19 -> TileEntityCargo.this.amount[2];
                case 20 -> TileEntityCargo.this.amount[3];
                default -> throw new IllegalArgumentException("Invalid index: " + id);
            };
        }

        public void set(int p_221477_1_, int p_221477_2_) {
            throw new IllegalStateException("Cannot set values through IIntArray");
        }
    };

    public TileEntityCargo(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlocks.CARGO_MANAGER_TILE.get(), blockPos, blockState);
        this.target = new int[]{0, 0, 0, 0};
    }

    public static void loadSelectionSettings() {
        itemSelections = new ArrayList<CargoItemSelection>();
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_ALL, Slot.class, new ItemStack((ItemLike)ModItems.CARTS.get(), 1)));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_ENGINE, SlotFuel.class, new ItemStack((ItemLike)ModItems.MODULES.get(StevesCartsModules.COAL_ENGINE).get())));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_RAILER, SlotBuilder.class, new ItemStack((ItemLike)Items.RAIL)));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_STORAGE, SlotChest.class, new ItemStack((ItemLike)Blocks.CHEST, 1)));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_TORCHES, SlotTorch.class, new ItemStack((ItemLike)Blocks.TORCH, 1)));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_EXPLOSIVES, ISlotExplosions.class, ComponentTypes.DYNAMITE.getItemStack()));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_ARROWS, SlotArrow.class, new ItemStack((ItemLike)Items.ARROW, 1)));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_BRIDGE, SlotBridge.class, new ItemStack((ItemLike)Blocks.BRICKS, 1)));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_SEEDS, SlotSeed.class, new ItemStack((ItemLike)Items.WHEAT_SEEDS, 1)));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_FERTILIZER, SlotFertilizer.class, new ItemStack((ItemLike)Items.BONE_MEAL, 1)));
        itemSelections.add(new CargoItemSelection(null, null, ItemStack.EMPTY));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_SAPLINGS, SlotSapling.class, new ItemStack((ItemLike)Blocks.OAK_SAPLING, 1)));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_FIREWORK, SlotFirework.class, new ItemStack((ItemLike)Items.FIREWORK_ROCKET, 1)));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_BUCKETS, SlotMilker.class, new ItemStack((ItemLike)Items.BUCKET, 1)));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_CAKES, SlotCake.class, new ItemStack((ItemLike)Items.CAKE, 1)));
    }

    @Override
    protected void updateLayout() {
        if (this.cargoSlots != null && this.lastLayout != this.layoutType) {
            for (SlotCargo slot : this.cargoSlots) {
                slot.updatePosition();
            }
            this.lastLayout = this.layoutType;
        }
    }

    @Override
    protected boolean isTargetValid(TransferManager transfer) {
        return this.target[transfer.getSetting()] >= 0 && this.target[transfer.getSetting()] < itemSelections.size();
    }

    @Override
    protected void receiveClickData(int packetid, int id, int dif) {
        if (packetid == 1) {
            int[] target = this.target;
            int n = id;
            target[n] = target[n] + dif;
            if (this.target[id] >= itemSelections.size()) {
                this.target[id] = 0;
            } else if (this.target[id] < 0) {
                this.target[id] = itemSelections.size() - 1;
            }
            if (this.color[id] - 1 == this.getSide()) {
                this.reset();
            }
            if (itemSelections.get(this.target[id]).getValidSlot() == null && dif != 0) {
                this.receiveClickData(packetid, id, dif);
            }
            this.setChanged();
        }
    }

    public int getAmount(int id) {
        int val = this.getAmountId(id);
        switch (val) {
            case 1: 
            case 7: {
                return 1;
            }
            case 2: 
            case 9: {
                return 3;
            }
            case 3: {
                return 8;
            }
            case 4: {
                return 16;
            }
            case 5: {
                return 32;
            }
            case 6: {
                return 64;
            }
            case 8: {
                return 2;
            }
            case 10: {
                return 5;
            }
        }
        return 0;
    }

    public int getAmountType(int id) {
        int val = this.getAmountId(id);
        if (val == 0) {
            return 0;
        }
        if (val <= 6) {
            return 1;
        }
        return 2;
    }

    @Override
    public int getAmountCount() {
        return 11;
    }

    @Override
    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.setWorkload(input.getByteOr("workload", (byte)0));
        for (int i = 0; i < 4; ++i) {
            this.target[i] = input.getByteOr("target" + i, (byte)0);
        }
    }

    @Override
    public void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.putByte("workload", (byte)this.getWorkload());
        for (int i = 0; i < 4; ++i) {
            output.putByte("target" + i, (byte)this.target[i]);
        }
    }

    @Override
    public void receivePacket(int id, byte[] data, Player player) {
        if (id == 0) {
            byte railID = data[0];
            boolean bl = this.toCart[railID] = !this.toCart[railID];
            if (this.color[railID] - 1 == this.getSide()) {
                this.reset();
            }
        } else if (id == 4) {
            byte railID = data[0];
            if (this.color[railID] != 5) {
                this.doReturn[this.color[railID] - 1] = !this.doReturn[this.color[railID] - 1];
            }
        } else if (id == 5) {
            byte difference = data[0];
            this.layoutType += difference;
            if (this.layoutType > 2) {
                this.layoutType = 0;
            } else if (this.layoutType < 0) {
                this.layoutType = 2;
            }
            this.reset();
        } else {
            byte railsAndDifferenceCombined = data[0];
            int railID2 = railsAndDifferenceCombined & 3;
            int k = (railsAndDifferenceCombined & 4) >> 2;
            int difference2 = k == 0 ? 1 : -1;
            if (id == 2) {
                int n = railID2;
                this.amount[n] = this.amount[n] + difference2;
                if (this.amount[railID2] >= this.getAmountCount()) {
                    this.amount[railID2] = 0;
                } else if (this.amount[railID2] < 0) {
                    this.amount[railID2] = this.getAmountCount() - 1;
                }
                if (this.color[railID2] - 1 == this.getSide()) {
                    this.reset();
                }
            } else if (id == 3) {
                int n2;
                if (this.color[railID2] != 5) {
                    boolean willStillExist = false;
                    for (int side = 0; side < 4; ++side) {
                        if (side == railID2 || this.color[railID2] != this.color[side]) continue;
                        willStillExist = true;
                        break;
                    }
                    if (!willStillExist) {
                        this.doReturn[this.color[railID2] - 1] = false;
                    }
                }
                int[] color = this.color;
                int n = n2 = railID2;
                color[n] = color[n] + difference2;
                if (this.color[railID2] > 5) {
                    this.color[railID2] = 1;
                } else if (this.color[railID2] < 1) {
                    this.color[railID2] = 5;
                }
                if (this.color[railID2] - 1 == this.getSide()) {
                    this.reset();
                }
            } else {
                this.receiveClickData(id, railID2, difference2);
            }
        }
    }

    @Override
    protected boolean doTransfer(TransferManager transfer) {
        Class<SlotCargo> toValid;
        AbstractContainerMenu toCont;
        MenuProvider toInv;
        Class<SlotCargo> fromValid;
        AbstractContainerMenu fromCont;
        MenuProvider fromInv;
        Class<SlotCargo> slotCart = itemSelections.get(this.target[transfer.getSetting()]).getValidSlot();
        if (slotCart == null) {
            transfer.setLowestSetting(transfer.getSetting() + 1);
            return true;
        }
        Class<SlotCargo> slotCargo = SlotCargo.class;
        if (this.toCart[transfer.getSetting()]) {
            fromInv = this;
            fromCont = new ContainerCargo(0, null, this, new SimpleContainerData(0));
            fromValid = slotCargo;
            toInv = transfer.getCart();
            toCont = transfer.getCart().getCon(null);
            toValid = slotCart;
        } else {
            fromInv = transfer.getCart();
            fromCont = transfer.getCart().getCon(null);
            fromValid = slotCart;
            toInv = this;
            toCont = new ContainerCargo(0, null, this, new SimpleContainerData(0));
            toValid = slotCargo;
        }
        this.latestTransferToBeUsed = transfer;
        for (int i = 0; i < fromInv.getContainerSize(); ++i) {
            if (!TransferHandler.isSlotOfType(fromCont.getSlot(i), fromValid) || fromInv.getItem(i).isEmpty()) continue;
            ItemStack iStack = fromInv.getItem(i);
            int stacksize = iStack.getCount();
            int maxNumber = this.getAmountType(transfer.getSetting()) == 1 ? this.getAmount(transfer.getSetting()) - transfer.getWorkload() : -1;
            TransferHandler.TransferItem(iStack, (Container)toInv, toCont, toValid, maxNumber, TransferHandler.TRANSFER_TYPE.MANAGER);
            if (iStack.getCount() == stacksize) continue;
            if (this.getAmountType(transfer.getSetting()) == 1) {
                transfer.setWorkload(transfer.getWorkload() + stacksize - iStack.getCount());
            } else if (this.getAmountType(transfer.getSetting()) == 2) {
                transfer.setWorkload(transfer.getWorkload() + 1);
            }
            this.setChanged();
            transfer.getCart().setChanged();
            if (iStack.getCount() == 0) {
                fromInv.setItem(i, ItemStack.EMPTY);
            }
            if (transfer.getWorkload() >= this.getAmount(transfer.getSetting()) && this.getAmountType(transfer.getSetting()) != 0) {
                transfer.setLowestSetting(transfer.getSetting() + 1);
            }
            return true;
        }
        return false;
    }

    public TransferManager getCurrentTransferForSlots() {
        return this.latestTransferToBeUsed;
    }

    @NotNull
    public IItemHandlerModifiable createHandler() {
        BlockState state = this.getBlockState();
        if (!(state.getBlock() instanceof BlockCargoManager)) {
            return new ItemStackHandler(0);
        }
        return new InvWrapper((Container)this);
    }

    @Override
    public int getContainerSize() {
        return 60;
    }

    public boolean stillValid(@NotNull Player playerEntity) {
        return true;
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"screen.cargo.manager");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
        return new ContainerCargo(id, playerInventory, this, this.dataAccess);
    }
}

