/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks.tileentities;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.StevesCartsClient;
import vswe.stevescarts.blocks.tileentities.TileEntityBase;
import vswe.stevescarts.entities.ModularMinecart;
import vswe.stevescarts.helpers.storages.TransferManager;
import vswe.stevescarts.network.packets.PacketCargpManager;

public abstract class TileEntityManager
extends TileEntityBase
implements Container {
    private final TransferManager standardTransferHandler;
    private NonNullList<ItemStack> cargoItemStacks;
    public int layoutType;
    public int moveTime = 0;
    public boolean[] toCart = new boolean[]{true, true, true, true};
    public boolean[] doReturn = new boolean[]{false, false, false, false};
    public int[] amount = new int[]{0, 0, 0, 0};
    public int[] color = new int[]{1, 2, 3, 4};

    public TileEntityManager(BlockEntityType<?> p_i48289_1_, BlockPos blockPos, BlockState blockState) {
        super(p_i48289_1_, blockPos, blockState);
        this.cargoItemStacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        this.standardTransferHandler = new TransferManager();
    }

    @NotNull
    public ItemStack getItem(int i) {
        return (ItemStack)this.cargoItemStacks.get(i);
    }

    public void setItem(int i, @NotNull ItemStack itemstack) {
        this.cargoItemStacks.set(i, (Object)itemstack);
        if (!itemstack.isEmpty() && itemstack.getCount() > this.getMaxStackSize()) {
            itemstack.setCount(this.getMaxStackSize());
        }
        this.setChanged();
    }

    public void clearContent() {
        this.cargoItemStacks.clear();
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.cargoItemStacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        for (ItemStackWithSlot itemstackwithslot : input.listOrEmpty("Items", ItemStackWithSlot.CODEC)) {
            this.cargoItemStacks.set(itemstackwithslot.slot(), (Object)itemstackwithslot.stack());
        }
        this.moveTime = input.getByteOr("movetime", (byte)0);
        this.setLowestSetting(input.getByteOr("lowestNumber", (byte)0));
        this.layoutType = input.getByteOr("layout", (byte)0);
        byte temp = input.getByteOr("tocart", (byte)0);
        byte temp2 = input.getByteOr("doReturn", (byte)0);
        for (int j = 0; j < 4; ++j) {
            this.amount[j] = input.getByteOr("amount" + j, (byte)0);
            this.color[j] = input.getByteOr("color" + j, (byte)0);
            if (this.color[j] == 0) {
                this.color[j] = j + 1;
            }
            this.toCart[j] = (temp & 1 << j) != 0;
            this.doReturn[j] = (temp2 & 1 << j) != 0;
        }
    }

    public void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.putByte("movetime", (byte)this.moveTime);
        output.putByte("lowestNumber", (byte)this.getLowestSetting());
        output.putByte("layout", (byte)this.layoutType);
        byte temp = 0;
        byte temp2 = 0;
        for (int i = 0; i < 4; ++i) {
            output.putByte("amount" + i, (byte)this.amount[i]);
            output.putByte("color" + i, (byte)this.color[i]);
            if (this.toCart[i]) {
                temp = (byte)(temp | (byte)(1 << i));
            }
            if (!this.doReturn[i]) continue;
            temp2 = (byte)(temp2 | (byte)(1 << i));
        }
        output.putByte("tocart", temp);
        output.putByte("doReturn", temp2);
        ValueOutput.TypedOutputList typedoutputlist = output.list("Items", ItemStackWithSlot.CODEC);
        for (int i = 0; i < this.cargoItemStacks.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.cargoItemStacks.get(i);
            if (itemstack.isEmpty()) continue;
            typedoutputlist.add((Object)new ItemStackWithSlot(i, itemstack));
        }
    }

    public ModularMinecart getCart() {
        return this.standardTransferHandler.getCart();
    }

    public void setCart(ModularMinecart cart) {
        this.standardTransferHandler.setCart(cart);
    }

    public int getSetting() {
        return this.standardTransferHandler.getSetting();
    }

    public void setSetting(int val) {
        this.standardTransferHandler.setSetting(val);
    }

    public int getSide() {
        return this.standardTransferHandler.getSide();
    }

    public void setSide(int val) {
        this.standardTransferHandler.setSide(val);
    }

    public int getLastSetting() {
        return this.standardTransferHandler.getLastSetting();
    }

    public void setLastSetting(int val) {
        this.standardTransferHandler.setLastSetting(val);
    }

    public int getLowestSetting() {
        return this.standardTransferHandler.getLowestSetting();
    }

    public void setLowestSetting(int val) {
        this.standardTransferHandler.setLowestSetting(val);
    }

    public int getWorkload() {
        return this.standardTransferHandler.getWorkload();
    }

    public void setWorkload(int val) {
        this.standardTransferHandler.setWorkload(val);
    }

    @Override
    public void tick() {
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide) {
            this.updateLayout();
            return;
        }
        if (this.getCart() == null || this.getCart().isRemoved() || this.getSide() < 0 || this.getSide() > 3 || !this.getCart().isDisabled()) {
            this.standardTransferHandler.reset();
            return;
        }
        ++this.moveTime;
        if (this.moveTime >= 24 || this.getSetting() == -1 && this.color[0] - 1 != this.getSide()) {
            this.moveTime = 0;
            if (!this.exchangeItems(this.standardTransferHandler)) {
                this.getCart().releaseCart();
                if (this.doReturn[this.getSide()]) {
                    this.getCart().turnback();
                }
                this.standardTransferHandler.reset();
            }
        }
    }

    public boolean exchangeItems(TransferManager transfer) {
        transfer.setSetting(transfer.getLowestSetting());
        while (transfer.getSetting() < 4) {
            if (this.color[transfer.getSetting()] - 1 == transfer.getSide()) {
                transfer.setLowestSetting(transfer.getSetting());
                if (transfer.getLastSetting() != transfer.getSetting()) {
                    transfer.setWorkload(0);
                    transfer.setLastSetting(transfer.getSetting());
                    return true;
                }
                if (!(this.toCart[transfer.getSetting()] ? transfer.getToCartEnabled() : transfer.getFromCartEnabled()) || !this.isTargetValid(transfer)) {
                    transfer.setLowestSetting(transfer.getSetting() + 1);
                    return true;
                }
                if (this.doTransfer(transfer)) {
                    return true;
                }
            }
            transfer.setSetting(transfer.getSetting() + 1);
        }
        return false;
    }

    public void sendPacket(int id) {
        this.sendPacket(id, new byte[0]);
    }

    public void sendPacket(int id, byte data) {
        this.sendPacket(id, new byte[]{data});
    }

    public void sendPacket(int id, byte[] data) {
        StevesCartsClient.sendToServer(new PacketCargpManager(this.getBlockPos(), id, data));
    }

    public void receivePacket(int id, byte[] data, Player player) {
        if (id == 0) {
            byte railID = data[0];
            boolean bl = this.toCart[railID] = !this.toCart[railID];
            if (this.color[railID] - 1 == this.getSide()) {
                this.reset();
            }
        } else if (id == 4) {
            byte railID = data[0];
            if (this.color[railID] != 5) {
                this.doReturn[this.color[railID] - 1] = !this.doReturn[this.color[railID] - 1];
            }
        } else if (id == 5) {
            byte difference = data[0];
            this.layoutType += difference;
            if (this.layoutType > 2) {
                this.layoutType = 0;
            } else if (this.layoutType < 0) {
                this.layoutType = 2;
            }
            this.reset();
        } else {
            byte railsAndDifferenceCombined = data[0];
            int railID2 = railsAndDifferenceCombined & 3;
            int k = (railsAndDifferenceCombined & 4) >> 2;
            int difference2 = k == 0 ? 1 : -1;
            if (id == 2) {
                int n;
                int[] amount = this.amount;
                int n2 = n = railID2;
                amount[n2] = amount[n2] + difference2;
                if (this.amount[railID2] >= this.getAmountCount()) {
                    this.amount[railID2] = 0;
                } else if (this.amount[railID2] < 0) {
                    this.amount[railID2] = this.getAmountCount() - 1;
                }
                if (this.color[railID2] - 1 == this.getSide()) {
                    this.reset();
                }
            } else if (id == 3) {
                int n2;
                if (this.color[railID2] != 5) {
                    boolean willStillExist = false;
                    for (int side = 0; side < 4; ++side) {
                        if (side == railID2 || this.color[railID2] != this.color[side]) continue;
                        willStillExist = true;
                        break;
                    }
                    if (!willStillExist) {
                        this.doReturn[this.color[railID2] - 1] = false;
                    }
                }
                int[] color = this.color;
                int n = n2 = railID2;
                color[n] = color[n] + difference2;
                if (this.color[railID2] > 5) {
                    this.color[railID2] = 1;
                } else if (this.color[railID2] < 1) {
                    this.color[railID2] = 5;
                }
                if (this.color[railID2] - 1 == this.getSide()) {
                    this.reset();
                }
            } else {
                this.receiveClickData(id, railID2, difference2);
            }
        }
    }

    public int moveProgressScaled(int i) {
        return this.moveTime * i / 24;
    }

    @Nonnull
    public ItemStack getStackInSlotOnClosing(int par1) {
        if (!((ItemStack)this.cargoItemStacks.get(par1)).isEmpty()) {
            ItemStack var2 = (ItemStack)this.cargoItemStacks.get(par1);
            this.cargoItemStacks.set(par1, (Object)ItemStack.EMPTY);
            return var2;
        }
        return ItemStack.EMPTY;
    }

    protected void updateLayout() {
    }

    protected void receiveClickData(int packetid, int id, int dif) {
    }

    protected abstract boolean isTargetValid(TransferManager var1);

    protected abstract boolean doTransfer(TransferManager var1);

    public abstract int getAmountCount();

    protected void reset() {
        this.moveTime = 0;
        this.setWorkload(0);
    }

    protected int getAmountId(int id) {
        return this.amount[id];
    }

    public int getContainerSize() {
        return this.cargoItemStacks.size();
    }

    @NotNull
    public ItemStack removeItem(int id, int amount) {
        return ContainerHelper.removeItem(this.cargoItemStacks, (int)id, (int)amount);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int id) {
        return ItemStack.EMPTY;
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.cargoItemStacks) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

