/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks.tileentities;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vswe.stevescarts.blocks.BlockUpgrade;
import vswe.stevescarts.blocks.tileentities.TileEntityBase;
import vswe.stevescarts.blocks.tileentities.TileEntityCartAssembler;
import vswe.stevescarts.containers.ContainerUpgrade;
import vswe.stevescarts.helpers.storages.ITankHolder;
import vswe.stevescarts.helpers.storages.SCTank;
import vswe.stevescarts.helpers.storages.TransferHandler;
import vswe.stevescarts.init.ModBlocks;
import vswe.stevescarts.upgrades.AssemblerUpgrade;
import vswe.stevescarts.upgrades.InventoryUpgradeEffect;

public class TileEntityUpgrade
extends TileEntityBase
implements WorldlyContainer,
ITankHolder,
MenuProvider {
    public SCTank tank = new SCTank(this, 0, 0);
    private TileEntityCartAssembler master;
    private int type;
    private boolean initialized;
    private CompoundTag comp;
    private NonNullList<ItemStack> inventoryStacks;
    private int[] slotsForSide;
    private boolean isCreativeBroken;

    public TileEntityUpgrade(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlocks.UPGRADE_TILE.get(), blockPos, blockState);
    }

    public TileEntityUpgrade(AssemblerUpgrade assemblerUpgrade, BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlocks.UPGRADE_TILE.get(), blockPos, blockState);
        this.type = assemblerUpgrade.getId();
        this.setType(assemblerUpgrade.getId());
    }

    public void setMaster(TileEntityCartAssembler master, Direction side) {
        this.master = master;
        if (this.level == null) {
            return;
        }
        if (this.level.getBlockState(this.getBlockPos()).getBlock() instanceof BlockUpgrade) {
            if (side != null) {
                this.level.getBlockState(this.getBlockPos()).setValue((Property)BlockUpgrade.CONNECTED, (Comparable)Boolean.valueOf(master != null));
            }
            this.setChanged();
        }
    }

    public Direction getSide() {
        if (this.level == null) {
            return Direction.NORTH;
        }
        return (Direction)this.level.getBlockState(this.getBlockPos()).getValue(BlockUpgrade.FACING);
    }

    public TileEntityCartAssembler getMaster() {
        return this.master;
    }

    public void setType(int type) {
        this.type = type;
        if (!this.initialized) {
            this.initialized = true;
            AssemblerUpgrade upgrade = this.getUpgrade();
            if (upgrade != null) {
                this.comp = new CompoundTag();
                this.slotsForSide = new int[upgrade.getInventorySize()];
                upgrade.init(this);
                if (upgrade.getInventorySize() > 0) {
                    this.inventoryStacks = NonNullList.withSize((int)upgrade.getInventorySize(), (Object)ItemStack.EMPTY);
                    for (int i = 0; i < this.slotsForSide.length; ++i) {
                        this.slotsForSide[i] = i;
                    }
                }
            } else {
                this.inventoryStacks = null;
            }
        }
    }

    public CompoundTag getCompound() {
        return this.comp;
    }

    public void setComp(CompoundTag comp) {
        this.comp = comp;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public AssemblerUpgrade getUpgrade() {
        return AssemblerUpgrade.getUpgrade(this.type);
    }

    public boolean hasInventory() {
        return this.inventoryStacks != null;
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.setType(input.getByteOr("Type", (byte)0));
        ContainerHelper.loadAllItems((ValueInput)input, this.inventoryStacks);
        this.setChanged();
        AssemblerUpgrade upgrade = this.getUpgrade();
        if (upgrade != null) {
            upgrade.load(this, input);
        }
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        if (this.inventoryStacks != null) {
            ContainerHelper.saveAllItems((ValueOutput)output, this.inventoryStacks);
        }
        output.putByte("Type", (byte)this.type);
        AssemblerUpgrade upgrade = this.getUpgrade();
        if (upgrade != null) {
            upgrade.save(this, output);
        }
    }

    @Override
    public void tick() {
        if (this.getUpgrade() != null && this.getMaster() != null) {
            this.getUpgrade().update(this);
        }
    }

    public int getContainerSize() {
        if (this.inventoryStacks != null) {
            return this.inventoryStacks.size();
        }
        if (this.master == null) {
            return 0;
        }
        return this.master.getContainerSize();
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.inventoryStacks) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack getItem(int i) {
        if (this.inventoryStacks == null) {
            if (this.master == null) {
                return ItemStack.EMPTY;
            }
            return this.master.getItem(i);
        }
        if (i < 0 || i >= this.getContainerSize()) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)this.inventoryStacks.get(i);
    }

    @NotNull
    public ItemStack removeItem(int id, int amount) {
        ItemStack itemStack = ContainerHelper.removeItem(this.inventoryStacks, (int)id, (int)amount);
        if (!itemStack.isEmpty()) {
            this.setChanged();
        }
        return itemStack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int id) {
        ItemStack itemStack = (ItemStack)this.inventoryStacks.get(id);
        if (itemStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.inventoryStacks.set(id, (Object)ItemStack.EMPTY);
        return itemStack;
    }

    public void setItem(int i, @NotNull ItemStack itemstack) {
        if (this.inventoryStacks == null) {
            if (this.master != null) {
                this.master.setItem(i, itemstack);
            }
        } else {
            if (i < 0 || i >= this.getContainerSize()) {
                return;
            }
            this.inventoryStacks.set(i, (Object)itemstack);
            if (!itemstack.isEmpty() && itemstack.getCount() > this.getMaxStackSize()) {
                itemstack.setCount(this.getMaxStackSize());
            }
            this.setChanged();
        }
    }

    public void setChanged() {
        InventoryUpgradeEffect inv;
        super.setChanged();
        if (this.getUpgrade() != null && (inv = this.getUpgrade().getInventoryEffect()) != null) {
            inv.onInventoryChanged(this);
        }
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    @Override
    @NotNull
    public ItemStack getInputContainer(int tankid) {
        return this.getItem(0);
    }

    @Override
    public void setInputContainer(int tankid, ItemStack stack) {
        this.setItem(0, stack);
    }

    @Override
    public void addToOutputContainer(int tankid, @NotNull ItemStack item) {
        TransferHandler.TransferItem(item, (Container)this, 1, 1, new ContainerUpgrade(0, null, this, new SimpleContainerData(0)), Slot.class, null, -1);
    }

    @Override
    public void onFluidUpdated(int tankid) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawImage(GuiGraphics guiGraphics, int tankid, AbstractContainerScreen<?> gui, TextureAtlasSprite sprite, int targetX, int targetY, int width, int height, int colour) {
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, sprite, gui.getGuiLeft() + targetX, gui.getGuiTop() + targetY, width, height, colour);
    }

    public void setCreativeBroken() {
        this.isCreativeBroken = true;
    }

    public boolean isCreativeBroken() {
        return this.isCreativeBroken;
    }

    public int @NotNull [] getSlotsForFace(@NotNull Direction direction) {
        return new int[0];
    }

    public boolean canPlaceItemThroughFace(int id, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        return false;
    }

    public boolean canTakeItemThroughFace(int p_180461_1_, @NotNull ItemStack itemStack, @NotNull Direction direction) {
        return false;
    }

    public void clearContent() {
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)this.getUpgrade().getName());
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, @NotNull Inventory playerInventory, @NotNull Player player) {
        return new ContainerUpgrade(id, playerInventory, this, new SimpleContainerData(0));
    }
}

