/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.client.guis;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import vswe.stevescarts.StevesCartsClient;
import vswe.stevescarts.blocks.tileentities.TileEntityActivator;
import vswe.stevescarts.containers.ContainerActivator;
import vswe.stevescarts.helpers.ActivatorOption;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.network.packets.PacketActivator;

public class GuiActivator
extends AbstractContainerScreen<ContainerActivator> {
    private static ResourceLocation texture = ResourceHelper.getResource("/gui/activator.png");
    TileEntityActivator activator;
    Inventory invPlayer;

    public GuiActivator(ContainerActivator containerActivator, Inventory playerInventory, Component iTextComponent) {
        super((AbstractContainerMenu)containerActivator, playerInventory, iTextComponent);
        this.invPlayer = playerInventory;
        this.imageWidth = 255;
        this.imageHeight = 222;
        this.activator = containerActivator.getActivator();
    }

    protected void renderBg(GuiGraphics guiGraphics, float p_230450_2_, int mouseX, int mouseY) {
        int j = this.getGuiLeft();
        int k = this.getGuiTop();
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, j, k, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        mouseX -= this.getGuiLeft();
        mouseY -= this.getGuiTop();
        for (int i = 0; i < this.activator.getOptions().size(); ++i) {
            ActivatorOption option = this.activator.getOptions().get(i);
            int[] box = this.getBoxRect(i);
            int srcX = 0;
            if (this.inRect(mouseX, mouseY, box)) {
                srcX = 16;
            }
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, j + box[0], k + box[1], (float)srcX, (float)this.imageHeight, box[2], box[3], 256, 256);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, j + box[0] + 1, k + box[1] + 1, (float)((box[2] - 2) * option.getOption()), (float)(this.imageHeight + box[3]), box[2] - 2, box[3] - 2, 256, 256);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int p_230451_2_, int p_230451_3_) {
    }

    public boolean inRect(int x, int y, int[] coords) {
        return coords != null && x >= coords[0] && x < coords[0] + coords[2] && y >= coords[1] && y < coords[1] + coords[3];
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float p_230430_4_) {
        int[] box;
        ActivatorOption option;
        int i;
        this.renderBackground(guiGraphics, mouseX, mouseY, p_230430_4_);
        super.render(guiGraphics, mouseX, mouseY, p_230430_4_);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        mouseX -= this.getGuiLeft();
        mouseY -= this.getGuiTop();
        guiGraphics.drawString(Minecraft.getInstance().font, Localization.GUI.TOGGLER.TITLE.translate(new String[0]), this.getGuiLeft() + 8, this.getGuiTop() + 6, -12566464, false);
        for (i = 0; i < this.activator.getOptions().size(); ++i) {
            option = this.activator.getOptions().get(i);
            box = this.getBoxRect(i);
            guiGraphics.drawString(Minecraft.getInstance().font, option.getName(), this.getGuiLeft() + box[0] + box[2] + 6, this.getGuiTop() + box[1] + 4, -12566464, false);
        }
        for (i = 0; i < this.activator.getOptions().size(); ++i) {
            option = this.activator.getOptions().get(i);
            box = this.getBoxRect(i);
            this.drawMouseMover(guiGraphics, option.getInfo(), mouseX, mouseY, box);
        }
    }

    private void drawMouseMover(GuiGraphics guiGraphics, String str, int x, int y, int[] rect) {
        if (this.inRect(x, y, rect)) {
            this.drawMouseOver(guiGraphics, str, x, y, rect);
        }
    }

    public void drawMouseOver(GuiGraphics guiGraphics, String str, int x, int y, int[] rect) {
        if (this.inRect(x, y, rect)) {
            guiGraphics.setTooltipForNextFrame(Minecraft.getInstance().font, (Component)Component.literal((String)str), this.getGuiLeft() + x, this.getGuiTop() + y);
        }
    }

    private int[] getBoxRect(int i) {
        return new int[]{20, 22 + i * 20, 16, 16};
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        super.mouseClicked(mouseX, mouseY, button);
        mouseX -= (double)this.getGuiLeft();
        mouseY -= (double)this.getGuiTop();
        for (int i = 0; i < this.activator.getOptions().size(); ++i) {
            int[] box = this.getBoxRect(i);
            if (!this.inRect((int)mouseX, (int)mouseY, box)) continue;
            byte data = (byte)(button != 0 ? 1 : 0);
            data = (byte)(data | (byte)(i << 1));
            this.activator.getOptions().get(i).changeOption(button == 0);
            StevesCartsClient.sendToServer(new PacketActivator(this.activator.getBlockPos(), 0, new byte[]{data}));
        }
        return true;
    }
}

