/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.client.guis;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import vswe.stevescarts.blocks.tileentities.TileEntityCargo;
import vswe.stevescarts.containers.ContainerCargo;
import vswe.stevescarts.helpers.CargoItemSelection;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.init.ModBlocks;

public class GuiCargo
extends AbstractContainerScreen<ContainerCargo> {
    private static ResourceLocation[] texturesLeft = new ResourceLocation[]{ResourceHelper.getResource("/gui/cargoVersion0Part1.png"), ResourceHelper.getResource("/gui/cargoVersion1Part1.png")};
    private static ResourceLocation[] texturesRight = new ResourceLocation[]{ResourceHelper.getResource("/gui/cargoVersion0Part2.png"), ResourceHelper.getResource("/gui/cargoVersion1Part2.png")};
    private final ContainerCargo containerCargo;
    private final TileEntityCargo manager;

    public GuiCargo(ContainerCargo containerCargo, Inventory playerInventory, Component iTextComponent) {
        super((AbstractContainerMenu)containerCargo, playerInventory, iTextComponent);
        this.containerCargo = containerCargo;
        this.imageWidth = 305;
        this.imageHeight = 222;
        this.manager = containerCargo.tileEntityCargo;
    }

    protected void renderBg(GuiGraphics guiGraphics, float mouseX, int mouseY, int partial) {
        int version = this.containerCargo.getLayoutType() == 0 ? 0 : 1;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texturesLeft[version], this.leftPos, this.topPos, 0.0f, 0.0f, 256, this.imageHeight, 256, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texturesRight[version], this.leftPos + 256, this.topPos, 0.0f, 0.0f, this.imageWidth - 256, this.imageHeight, 256, 256);
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        for (int i = 0; i < 4; ++i) {
            this.drawArrow(guiGraphics, texturesRight[version], i, left, top);
            int color = this.containerCargo.getColor()[i] - 1;
            if (color == 4) continue;
            this.drawColors(guiGraphics, texturesRight[version], i, color, left, top);
        }
        int[] coords = this.getMiddleCoords();
        guiGraphics.renderItem(new ItemStack((ItemLike)this.getBlock(), 1), left + coords[0], top + coords[1]);
        for (int j = 0; j < 4; ++j) {
            this.drawItems(j, guiGraphics, left, top);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int p_230451_2_, int p_230451_3_) {
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float p_230430_4_) {
        int i;
        this.renderBackground(guiGraphics, mouseX, mouseY, p_230430_4_);
        super.render(guiGraphics, mouseX, mouseY, p_230430_4_);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        int[] coords = this.getMiddleCoords();
        guiGraphics.drawString(Minecraft.getInstance().font, this.getManagerName(), this.leftPos + coords[0] - 34, this.topPos + 4, -1);
        guiGraphics.drawString(Minecraft.getInstance().font, Localization.GUI.MANAGER.TITLE.translate(new String[0]), this.leftPos + coords[0] + coords[2], this.topPos + 4, -1);
        for (i = 0; i < 4; ++i) {
            coords = this.getTextCoords(i);
            String str = this.getMaxSizeText(i);
            guiGraphics.drawString(Minecraft.getInstance().font, str, this.leftPos + coords[0], this.topPos + coords[1], -1);
        }
        for (i = 0; i < 4; ++i) {
            try {
                this.drawExtraOverlay(guiGraphics, i, mouseX, mouseY);
                this.drawMouseOver(guiGraphics, Localization.GUI.MANAGER.CHANGE_TRANSFER_DIRECTION.translate(new String[0]) + "\n" + Localization.GUI.MANAGER.CURRENT_SETTING.translate(new String[0]) + ": " + (this.containerCargo.toCart()[i] ? Localization.GUI.MANAGER.DIRECTION_TO_CART.translate(new String[0]) : Localization.GUI.MANAGER.DIRECTION_FROM_CART.translate(new String[0])), mouseX, mouseY, this.getArrowCoords(i));
                this.drawMouseOver(guiGraphics, Localization.GUI.MANAGER.CHANGE_TURN_BACK_SETTING.translate(new String[0]) + "\n" + Localization.GUI.MANAGER.CURRENT_SETTING.translate(new String[0]) + ": " + (this.containerCargo.getColor()[i] == 5 ? Localization.GUI.MANAGER.TURN_BACK_NOT_SELECTED.translate(new String[0]) : (this.containerCargo.doReturn()[this.containerCargo.getColor()[i] - 1] ? Localization.GUI.MANAGER.TURN_BACK_DO.translate(new String[0]) : Localization.GUI.MANAGER.TURN_BACK_DO_NOT.translate(new String[0]))), mouseX, mouseY, this.getReturnCoords(i));
                this.drawMouseOver(guiGraphics, Localization.GUI.MANAGER.CHANGE_TRANSFER_SIZE.translate(new String[0]) + ": " + Localization.GUI.MANAGER.CURRENT_SETTING.translate(new String[0]) + ": " + this.getMaxSizeOverlay(i), mouseX, mouseY, this.getTextCoords(i));
                this.drawMouseOver(guiGraphics, Localization.GUI.MANAGER.CHANGE_SIDE.translate(new String[0]) + ": " + Localization.GUI.MANAGER.CURRENT_SIDE.translate(new String[0]) + ": " + (new String[]{Localization.GUI.MANAGER.SIDE_RED.translate(new String[0]), Localization.GUI.MANAGER.SIDE_BLUE.translate(new String[0]), Localization.GUI.MANAGER.SIDE_YELLOW.translate(new String[0]), Localization.GUI.MANAGER.SIDE_GREEN.translate(new String[0]), Localization.GUI.MANAGER.SIDE_DISABLED.translate(new String[0])})[this.containerCargo.getColor()[i] - 1], mouseX, mouseY, this.getColorpickerCoords(i));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.drawMouseOver(guiGraphics, this.getLayoutString() + "\n" + Localization.GUI.MANAGER.CURRENT_SETTING.translate(new String[0]) + ": " + this.getLayoutOption(this.containerCargo.getLayoutType()), mouseX, mouseY, this.getMiddleCoords());
    }

    protected void drawColors(GuiGraphics guiGraphics, ResourceLocation resourceLocation, int id, int color, int left, int top) {
        try {
            int[] coords = this.getReturnCoords(id);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, resourceLocation, left + coords[0], top + coords[1], (float)(this.getColorSourceX() + (this.containerCargo.doReturn()[this.containerCargo.getColor()[id] - 1] ? 8 : 0)), (float)(80 + 8 * color), 8, 8, 256, 256);
            coords = this.getBoxCoords(id);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, resourceLocation, left + coords[0] - 2, top + coords[1] - 2, (float)this.getColorSourceX(), (float)(20 * color), 20, 20, 256, 256);
            if (this.containerCargo.getLayoutType() == 2) {
                int[] coords1 = this.getInvCoords(id);
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, resourceLocation, left + coords1[0] - 2, top + coords1[1] - 2, 125.0f, (float)(56 * color), 92, 56, 256, 256);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected int[] getReturnCoords(int id) {
        int x = id % 2;
        int y = id / 2;
        int xCoord = this.getCenterTargetX() + 14 + x * 70;
        int yCoord = 49 + y * 32;
        return new int[]{xCoord, yCoord += this.offsetObjectY(this.containerCargo.getLayoutType(), x, y), 8, 8};
    }

    private void drawArrow(GuiGraphics guiGraphics, ResourceLocation resourceLocation, int id, int left, int top) {
        int sourceX = this.getArrowSourceX();
        int sourceY = 28;
        sourceY += 56 * id;
        if (!this.containerCargo.toCart()[id]) {
            sourceX += 28;
        }
        int targetX = this.getArrowCoords(id)[0];
        int targetY = this.getArrowCoords(id)[1];
        int sizeX = 28;
        int sizeY = 28;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, resourceLocation, left + targetX, top + targetY, (float)sourceX, (float)sourceY, sizeX, sizeY, 256, 256);
        if (id == this.manager.getLastSetting() && this.containerCargo.getColor()[id] != 5) {
            sourceY -= 28;
            int scaledProgress = this.manager.moveProgressScaled(42);
            int offsetX = 0;
            int offsetY = 0;
            if (this.containerCargo.toCart()[id]) {
                sizeX = 14;
                if (id % 2 == 0) {
                    offsetX = 14;
                }
                if ((sizeY = scaledProgress) > 19) {
                    sizeY = 19;
                }
                if (id < 2) {
                    offsetY = 28 - sizeY;
                }
            } else {
                sizeY = 14;
                if (id >= 2) {
                    offsetY = 14;
                }
                if ((sizeX = scaledProgress) > 19) {
                    sizeX = 19;
                }
                if (id % 2 == 1) {
                    offsetX = 28 - sizeX;
                }
            }
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, resourceLocation, left + targetX + offsetX, top + targetY + offsetY, (float)(sourceX + offsetX), (float)(sourceY + offsetY), sizeX, sizeY, 256, 256);
            offsetX = 0;
            offsetY = 0;
            sizeX = 28;
            sizeY = 28;
            if (scaledProgress > 19) {
                scaledProgress -= 19;
                if (this.containerCargo.toCart()[id]) {
                    sizeX = scaledProgress;
                    if (sizeX > 23) {
                        sizeX = 23;
                    }
                    offsetX = id % 2 == 0 ? 22 - sizeX : 6;
                } else {
                    sizeY = scaledProgress;
                    if (sizeY > 23) {
                        sizeY = 23;
                    }
                    offsetY = id >= 2 ? 22 - sizeY : 6;
                }
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, resourceLocation, left + targetX + offsetX, top + targetY + offsetY, (float)(sourceX + offsetX), (float)(sourceY + offsetY), sizeX, sizeY, 256, 256);
            }
        }
    }

    protected int[] getMiddleCoords() {
        return new int[]{this.getCenterTargetX() + 45, 61, 20, 20};
    }

    protected int[] getTextCoords(int id) {
        int[] coords = this.getBoxCoords(id);
        int xCoord = coords[0];
        int yCoord = coords[1];
        yCoord = id >= 2 ? (yCoord -= 12) : (yCoord += 20);
        return new int[]{xCoord, yCoord, 20, 10};
    }

    protected int[] getArrowCoords(int id) {
        int x = id % 2;
        int y = id / 2;
        int xCoord = this.getCenterTargetX() + 25 + x * 28;
        int yCoord = 17 + y * 76;
        return new int[]{xCoord, yCoord += this.offsetObjectY(this.containerCargo.getLayoutType(), x, y), 28, 28};
    }

    public void drawMouseOver(GuiGraphics guiGraphics, String str, int x, int y, int[] rect) {
        if (this.inRect(x - this.getGuiLeft(), y - this.getGuiTop(), rect)) {
            guiGraphics.setTooltipForNextFrame(Minecraft.getInstance().font, (Component)Component.literal((String)str), x, y);
        }
    }

    public boolean inRect(int x, int y, int[] coords) {
        return coords != null && x >= coords[0] && x < coords[0] + coords[2] && y >= coords[1] && y < coords[1] + coords[3];
    }

    protected int[] getColorpickerCoords(int id) {
        int x = id % 2;
        int y = id / 2;
        int xCoord = this.getCenterTargetX() + 3 + x * 92;
        int yCoord = 49 + y * 32;
        return new int[]{xCoord, yCoord += this.offsetObjectY(this.containerCargo.getLayoutType(), x, y), 8, 8};
    }

    protected String getMaxSizeOverlay(int id) {
        int amount = this.containerCargo.getAmount(id);
        int type = this.containerCargo.getAmountType(id);
        if (type == 0) {
            return Localization.GUI.CARGO.TRANSFER_ALL.translate(new String[0]);
        }
        if (type == 1) {
            return Localization.GUI.CARGO.TRANSFER_ITEMS.translate(String.valueOf(amount), String.valueOf(amount));
        }
        return Localization.GUI.CARGO.TRANSFER_STACKS.translate(String.valueOf(amount), String.valueOf(amount));
    }

    protected String getMaxSizeText(int id) {
        Object s;
        int type = this.containerCargo.getAmountType(id);
        if (type == 0) {
            s = Localization.GUI.CARGO.TRANSFER_ALL_SHORT.translate(new String[0]);
        } else {
            int amount = this.containerCargo.getAmount(id);
            s = String.valueOf(amount);
            s = type == 1 ? (String)s + " " + Localization.GUI.CARGO.TRANSFER_ITEMS_SHORT.translate(new String[0]) : (String)s + " " + Localization.GUI.CARGO.TRANSFER_STACKS_SHORT.translate(new String[0]);
        }
        return s;
    }

    protected int getArrowSourceX() {
        return 49;
    }

    protected int getColorSourceX() {
        return 105;
    }

    protected int getCenterTargetX() {
        return 98;
    }

    protected void drawItems(int id, GuiGraphics guiGraphics, int left, int top) {
        ItemStack cartIcon = this.containerCargo.getTarget()[id] < 0 || this.containerCargo.getTarget()[id] >= TileEntityCargo.itemSelections.size() || TileEntityCargo.itemSelections.get(this.containerCargo.getTarget()[id]).getIcon().isEmpty() ? new ItemStack((ItemLike)Items.MINECART, 1) : TileEntityCargo.itemSelections.get(this.containerCargo.getTarget()[id]).getIcon();
        int[] coords = this.getBoxCoords(id);
        guiGraphics.renderItem(cartIcon, left + coords[0], top + coords[1]);
    }

    protected int[] getBoxCoords(int id) {
        int x = id % 2;
        int y = id / 2;
        int xCoord = this.getCenterTargetX() + 4 + x * 82;
        int yCoord = 17 + y * 88;
        return new int[]{xCoord, yCoord += this.offsetObjectY(this.containerCargo.getLayoutType(), x, y), 20, 20};
    }

    protected int offsetObjectY(int layout, int x, int y) {
        if (layout != 0) {
            return -5 + y * 10;
        }
        return 0;
    }

    protected boolean sendOnClick(int id, int x, int y, byte data) {
        if (this.inRect(x, y, this.getBoxCoords(id))) {
            this.manager.sendPacket(1, data);
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        super.mouseClicked(mouseX, mouseY, button);
        int x = (int)mouseX;
        int y = (int)mouseY;
        if (this.inRect(x -= this.getGuiLeft(), y -= this.getGuiTop(), this.getMiddleCoords())) {
            this.manager.sendPacket(5, (byte)(button == 0 ? 1 : -1));
        } else {
            for (int i = 0; i < 4; ++i) {
                byte data = (byte)i;
                data = (byte)(data | (byte)(button << 2));
                if (this.inRect(x, y, this.getArrowCoords(i))) {
                    this.manager.sendPacket(0, (byte)i);
                    break;
                }
                if (this.inRect(x, y, this.getTextCoords(i))) {
                    this.manager.sendPacket(2, data);
                    break;
                }
                if (this.inRect(x, y, this.getColorpickerCoords(i))) {
                    this.manager.sendPacket(3, data);
                    break;
                }
                if (this.inRect(x, y, this.getReturnCoords(i))) {
                    this.manager.sendPacket(4, (byte)i);
                    break;
                }
                if (this.sendOnClick(i, x, y, data)) break;
            }
        }
        return true;
    }

    protected void drawExtraOverlay(GuiGraphics guiGraphics, int id, int x, int y) {
        if (this.containerCargo.getTarget()[id] >= 0) {
            int n = this.containerCargo.getTarget()[id];
            this.getCargo();
            if (n < TileEntityCargo.itemSelections.size()) {
                this.getCargo();
                CargoItemSelection item = TileEntityCargo.itemSelections.get(this.containerCargo.getTarget()[id]);
                if (item.getName() != null) {
                    this.drawMouseOver(guiGraphics, Localization.GUI.CARGO.CHANGE_STORAGE_AREA.translate(new String[0]) + ": " + Localization.GUI.MANAGER.CURRENT_SETTING.translate(new String[0]) + ": " + item.getName(), x, y, this.getBoxCoords(id));
                } else {
                    this.drawMouseOver(guiGraphics, Localization.GUI.CARGO.CHANGE_STORAGE_AREA.translate(new String[0]) + ": " + Localization.GUI.MANAGER.CURRENT_SETTING.translate(new String[0]) + ": " + Localization.GUI.CARGO.UNKNOWN_AREA.translate(new String[0]), x, y, this.getBoxCoords(id));
                }
                return;
            }
        }
        this.drawMouseOver(guiGraphics, Localization.GUI.CARGO.CHANGE_STORAGE_AREA.translate(new String[0]) + ": " + Localization.GUI.MANAGER.CURRENT_SETTING.translate(new String[0]) + ": " + Localization.GUI.CARGO.UNKNOWN_AREA.translate(new String[0]), x, y, this.getBoxCoords(id));
    }

    protected Block getBlock() {
        return (Block)ModBlocks.CARGO_MANAGER.get();
    }

    protected String getManagerName() {
        return Localization.GUI.CARGO.TITLE.translate(new String[0]);
    }

    private int[] getInvCoords(int id) {
        int x = id % 2;
        int y = id / 2;
        int xCoord = 8 + x * 198;
        int yCoord = 11 + y * 64;
        return new int[]{xCoord, yCoord};
    }

    private TileEntityCargo getCargo() {
        return this.manager;
    }

    protected String getLayoutString() {
        return Localization.GUI.CARGO.CHANGE_SLOT_LAYOUT.translate(new String[0]);
    }

    protected String getLayoutOption(int id) {
        switch (id) {
            default: {
                return Localization.GUI.CARGO.LAYOUT_SHARED.translate(new String[0]);
            }
            case 1: {
                return Localization.GUI.CARGO.LAYOUT_SIDE.translate(new String[0]);
            }
            case 2: 
        }
        return Localization.GUI.CARGO.LAYOUT_COLOR.translate(new String[0]);
    }
}

