/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.client.guis;

import java.util.ArrayList;
import net.creeperhost.polylib.client.modulargui.lib.container.DataSync;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import vswe.stevescarts.blocks.tileentities.TileEntityDistributor;
import vswe.stevescarts.blocks.tileentities.TileEntityManager;
import vswe.stevescarts.containers.ContainerDistributor;
import vswe.stevescarts.helpers.DistributorSetting;
import vswe.stevescarts.helpers.DistributorSide;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;

public class GuiDistributor
extends AbstractContainerScreen<ContainerDistributor> {
    private final ContainerDistributor containerDistributor;
    private String mouseOverText;
    private static ResourceLocation texture = ResourceHelper.getResource("/gui/distributor.png");
    private int activeId;
    private final TileEntityDistributor distributor;

    public GuiDistributor(ContainerDistributor containerDistributor, Inventory playerInventory, Component iTextComponent) {
        super((AbstractContainerMenu)containerDistributor, playerInventory, iTextComponent);
        this.containerDistributor = containerDistributor;
        this.activeId = -1;
        this.imageWidth = 255;
        this.imageHeight = 186;
        this.distributor = containerDistributor.getDistributor();
    }

    protected void renderBg(GuiGraphics guiGraphics, float p_230450_2_, int x, int y) {
        int j = this.getGuiLeft();
        int k = this.getGuiTop();
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, j, k, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        x -= this.getGuiLeft();
        y -= this.getGuiTop();
        TileEntityManager[] invs = this.distributor.getInventories();
        ArrayList<DataSync<DistributorSide>> sides = this.containerDistributor.sideSyncs;
        int id = 0;
        for (DataSync<DistributorSide> sync : sides) {
            DistributorSide side = (DistributorSide)sync.get();
            if (!side.isEnabled(this.distributor)) continue;
            int[] box = this.getSideBoxRect(id);
            int srcX = 0;
            if (this.inRect(x, y, box)) {
                srcX = box[2];
            }
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, j + box[0], k + box[1], (float)srcX, (float)this.imageHeight, box[2], box[3], 256, 256);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, j + box[0] + 2, k + box[1] + 2, (float)(box[2] * 2 + (box[2] - 4) * side.getId()), (float)this.imageHeight, box[2] - 4, box[3] - 4, 256, 256);
            this.drawMouseMover(Localization.GUI.DISTRIBUTOR.SIDE.translate(side.getName()) + (String)(this.activeId != -1 ? ": [" + Localization.GUI.DISTRIBUTOR.DROP_INSTRUCTION.translate(new String[0]) + "]" : ""), x, y, box);
            int settingCount = 0;
            for (DistributorSetting setting : DistributorSetting.settings) {
                if (!setting.isEnabled(this.distributor) || !side.isSet(setting.getId())) continue;
                int[] settingbox = this.getActiveSettingBoxRect(id, settingCount++);
                this.drawSetting(guiGraphics, setting, settingbox, this.inRect(x, y, settingbox));
                this.drawMouseMover(setting.getName(invs) + ": [" + Localization.GUI.DISTRIBUTOR.REMOVE_INSTRUCTION.translate(new String[0]) + "]", x, y, settingbox);
            }
            ++id;
        }
        for (DistributorSetting setting2 : DistributorSetting.settings) {
            if (!setting2.isEnabled(this.distributor)) continue;
            int[] box = this.getSettingBoxRect(setting2.getImageId(), setting2.getIsTop());
            this.drawSetting(guiGraphics, setting2, box, this.inRect(x, y, box));
            this.drawMouseMover(setting2.getName(invs), x, y, box);
        }
        if (this.activeId != -1) {
            DistributorSetting setting3 = DistributorSetting.settings.get(this.activeId);
            this.drawSetting(guiGraphics, setting3, new int[]{x - 8, y - 8, 16, 16}, true);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int p_230451_2_, int p_230451_3_) {
    }

    public void render(GuiGraphics guiGraphics, int x, int y, float p_230430_4_) {
        this.renderBackground(guiGraphics, x, y, p_230430_4_);
        super.render(guiGraphics, x, y, p_230430_4_);
        guiGraphics.drawString(Minecraft.getInstance().font, Localization.GUI.DISTRIBUTOR.TITLE.translate(new String[0]), this.leftPos + 8, this.topPos + 6, -1);
        TileEntityManager[] invs = this.distributor.getInventories();
        if (invs.length == 0) {
            guiGraphics.drawString(Minecraft.getInstance().font, Localization.GUI.DISTRIBUTOR.NOT_CONNECTED.translate(new String[0]), this.leftPos + 30, this.topPos + 40, -49088);
        }
        if (this.mouseOverText != null && !this.mouseOverText.equals("")) {
            guiGraphics.setTooltipForNextFrame(Minecraft.getInstance().font, (Component)Component.literal((String)this.mouseOverText), x, y);
        }
        this.mouseOverText = null;
    }

    private void drawMouseMover(String str, int x, int y, int[] rect) {
        if (this.inRect(x, y, rect)) {
            this.mouseOverText = str;
        }
    }

    public boolean inRect(int x, int y, int[] coords) {
        return coords != null && x >= coords[0] && x < coords[0] + coords[2] && y >= coords[1] && y < coords[1] + coords[3];
    }

    private void drawSetting(GuiGraphics guiGraphics, DistributorSetting setting, int[] box, boolean hover) {
        int j = this.getGuiLeft();
        int k = this.getGuiTop();
        int srcX = 0;
        if (!setting.getIsTop()) {
            srcX += box[2] * 2;
        }
        if (hover) {
            srcX += box[2];
        }
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, j + box[0], k + box[1], (float)srcX, (float)(this.imageHeight + this.getSideBoxRect(0)[3]), box[2], box[3], 256, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, j + box[0] + 1, k + box[1] + 1, (float)(box[2] * 4 + (box[2] - 2) * setting.getImageId()), (float)(this.imageHeight + this.getSideBoxRect(0)[3]), box[2] - 2, box[3] - 2, 256, 256);
    }

    private int[] getSideBoxRect(int i) {
        return new int[]{20, 18 + i * 24, 22, 22};
    }

    private int[] getSettingBoxRect(int i, boolean topRow) {
        return new int[]{20 + i * 18, 143 + (topRow ? 0 : 18), 16, 16};
    }

    private int[] getActiveSettingBoxRect(int side, int setting) {
        int[] sideCoords = this.getSideBoxRect(side);
        return new int[]{sideCoords[0] + sideCoords[2] + 5 + setting * 18, sideCoords[1] + (sideCoords[3] - 16) / 2, 16, 16};
    }

    public boolean mouseClicked(double x, double y, int button) {
        block5: {
            block6: {
                x -= (double)this.getGuiLeft();
                y -= (double)this.getGuiTop();
                if (button != 0) break block6;
                for (DistributorSetting setting : DistributorSetting.settings) {
                    int[] box;
                    if (!setting.isEnabled(this.distributor) || !this.inRect((int)x, (int)y, box = this.getSettingBoxRect(setting.getImageId(), setting.getIsTop()))) continue;
                    this.activeId = setting.getId();
                }
                if (this.activeId == -1) break block5;
                int id = 0;
                ArrayList<DataSync<DistributorSide>> sides = this.containerDistributor.sideSyncs;
                for (DataSync<DistributorSide> sync : sides) {
                    int[] box;
                    DistributorSide side = (DistributorSide)sync.get();
                    if (!side.isEnabled(this.distributor) || !this.inRect((int)x, (int)y, box = this.getSideBoxRect(id++))) continue;
                    this.distributor.sendPacket(0, new byte[]{(byte)this.activeId, (byte)side.getId()});
                    this.activeId = -1;
                    break block5;
                }
                break block5;
            }
            if (button == 1) {
                int id = 0;
                ArrayList<DataSync<DistributorSide>> sides = this.containerDistributor.sideSyncs;
                for (DataSync<DistributorSide> sync : sides) {
                    DistributorSide side = (DistributorSide)sync.get();
                    if (!side.isEnabled(this.distributor)) continue;
                    int settingCount = 0;
                    for (DistributorSetting setting : DistributorSetting.settings) {
                        int[] settingbox;
                        if (!setting.isEnabled(this.distributor) || !side.isSet(setting.getId()) || !this.inRect((int)x, (int)y, settingbox = this.getActiveSettingBoxRect(id, settingCount++))) continue;
                        this.distributor.sendPacket(1, new byte[]{(byte)setting.getId(), (byte)side.getId()});
                        this.activeId = -1;
                        break;
                    }
                    ++id;
                }
            }
        }
        return super.mouseClicked(x, y, button);
    }
}

