/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.client.guis;

import com.mojang.blaze3d.opengl.GlStateManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import vswe.stevescarts.StevesCartsClient;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.slots.SlotStevesCarts;
import vswe.stevescarts.client.guis.GuiHelper;
import vswe.stevescarts.containers.ContainerMinecart;
import vswe.stevescarts.entities.ModularMinecart;
import vswe.stevescarts.helpers.ModuleCountPair;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.network.packets.PacketMinecartTurn;

public class GuiMinecart
extends AbstractContainerScreen<ContainerMinecart> {
    private static ResourceLocation textureLeft = ResourceHelper.getResource("/gui/guiBase1.png");
    private static ResourceLocation textureRight = ResourceHelper.getResource("/gui/guiBase2.png");
    private static ResourceLocation textureReturn = ResourceHelper.getResource("/gui/return.png");
    private boolean isScrolling;
    private final int[] scrollBox = new int[]{450, 15, 18, 225};
    private ModularMinecart cart;
    private final int[] returnButton = new int[]{324, 173, 24, 12};

    public GuiMinecart(ContainerMinecart containerMinecart, Inventory invPlayer, Component iTextComponent) {
        super((AbstractContainerMenu)containerMinecart, invPlayer, iTextComponent);
        this.setup(containerMinecart.cart);
    }

    protected void setup(ModularMinecart cart) {
        this.cart = cart;
        this.imageWidth = 478;
        this.imageHeight = 256;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.cart == null) {
            return;
        }
        ModuleBase thief = this.cart.getInterfaceThief();
        if (thief != null) {
            this.drawModuleForeground(guiGraphics, thief);
            this.drawModuleMouseOver(guiGraphics, thief, mouseX, mouseY);
        } else {
            for (ModuleBase module : this.cart.modules()) {
                this.drawModuleForeground(guiGraphics, module);
            }
            this.renderModuleListText(guiGraphics, mouseX, mouseY);
            for (ModuleBase module : this.cart.modules()) {
                this.drawModuleMouseOver(guiGraphics, module, mouseX, mouseY);
            }
            this.renderModuleListMouseOver(guiGraphics, mouseX, mouseY);
            this.renderReturnMouseOver(guiGraphics, mouseX, mouseY);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float p_230450_2_, int mouseX, int mouseY) {
        block7: {
            int left = this.getGuiLeft();
            int top = this.getGuiTop();
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, textureLeft, left, top, 0.0f, 0.0f, 256, 256, 256, 256);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, textureRight, left + 256, top, 0.0f, 0.0f, this.imageWidth - 256, this.imageHeight, 256, 256);
            if (this.cart == null) break block7;
            ModuleBase thief = this.cart.getInterfaceThief();
            if (thief != null) {
                this.drawModuleSlots(guiGraphics, textureRight, thief);
                this.drawModuleBackground(guiGraphics, thief, mouseX, mouseY);
                this.drawModuleBackgroundItems(guiGraphics, thief, mouseX, mouseY);
                for (ModuleBase module : this.cart.modules()) {
                    if (!module.hasGui() || !module.hasSlots()) continue;
                    ArrayList<SlotStevesCarts> slotsList = module.getSlots();
                    for (SlotStevesCarts slot : slotsList) {
                        this.resetSlot(slot);
                    }
                }
            } else {
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, textureRight, left + this.scrollBox[0], top + this.scrollBox[1], 222.0f, 24.0f, this.scrollBox[2], this.scrollBox[3], 256, 256);
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, textureRight, left + this.scrollBox[0] + 2, top + this.scrollBox[1] + 2 + this.cart.getScrollY(), 240.0f, (float)(26 + (this.cart.canScrollModules ? 0 : 25)), 14, 25, 256, 256);
                for (ModuleBase module : this.cart.modules()) {
                    this.drawModuleSlots(guiGraphics, textureRight, module);
                }
                for (ModuleBase module : this.cart.modules()) {
                    this.drawModuleBackground(guiGraphics, module, mouseX, mouseY);
                }
                this.renderModuleList(guiGraphics, mouseX, mouseY);
                this.renderReturnButton(guiGraphics, mouseX, mouseY);
                for (ModuleBase module : this.cart.modules()) {
                    this.drawModuleBackgroundItems(guiGraphics, module, mouseX, mouseY);
                }
            }
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int p_230451_2_, int p_230451_3_) {
    }

    private void renderModuleList(GuiGraphics guiGraphics, int x, int y) {
        for (int i = 0; i < this.cart.modules().size(); ++i) {
            this.drawModuleIcon(guiGraphics, this.cart.modules().get(i).getItemStack(), this.getGuiLeft() + this.getModuleDisplayX(i), this.getGuiTop() + this.getModuleDisplayY(i), 1.0f, 1.0f, 0.0f, 0.0f);
        }
    }

    private void renderReturnButton(GuiGraphics guiGraphics, int x, int y) {
        int uy = this.inRect(x -= this.getGuiLeft(), y -= this.getGuiTop(), this.returnButton) ? 12 : 0;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, textureReturn, this.returnButton[0] + this.getGuiLeft(), this.returnButton[1] + this.getGuiTop(), 0.0f, (float)uy, this.returnButton[2], this.returnButton[3], 256, 256);
    }

    public void drawModuleIcon(GuiGraphics guiGraphics, ItemStack icon, int targetX, int targetY, float sizeX, float sizeY, float offsetX, float offsetY) {
        guiGraphics.renderItem(icon, targetX, targetY);
    }

    private void renderModuleListText(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        mouseX -= this.getGuiLeft();
        mouseY -= this.getGuiTop();
        ArrayList<ModuleCountPair> moduleCounts = this.cart.moduleCounts();
        guiGraphics.drawString(Minecraft.getInstance().font, this.cart.getName(), this.getGuiLeft() + 5, this.getGuiTop() + 172, -1);
        GlStateManager._enableBlend();
        for (int i = 0; i < moduleCounts.size(); ++i) {
            ModuleCountPair count = moduleCounts.get(i);
            if (count.getCount() == 1) continue;
            int alpha = (int)((this.inRect(mouseX, mouseY, this.getModuleDisplayX(i), this.getModuleDisplayY(i), 16, 16) ? 1.0f : 0.75f) * 256.0f);
            String str = String.valueOf(count.getCount());
            guiGraphics.drawString(Minecraft.getInstance().font, str, this.getGuiLeft() + this.getModuleDisplayX(i) + 16 - this.font.width(str), this.getModuleDisplayY(i) + 8, 0xFFFFFF | alpha << 24);
        }
        GlStateManager._disableBlend();
    }

    private void renderModuleListMouseOver(GuiGraphics guiGraphics, int x, int y) {
        x -= this.getGuiLeft();
        y -= this.getGuiTop();
        ArrayList<ModuleCountPair> moduleCounts = this.cart.moduleCounts();
        for (int i = 0; i < moduleCounts.size(); ++i) {
            ModuleCountPair count = moduleCounts.get(i);
            if (!this.inRect(x, y, this.getModuleDisplayX(i), this.getModuleDisplayY(i), 16, 16)) continue;
            for (ModuleBase module : this.cart.modules()) {
                if (module.getClass() != count.getData().getModuleClass()) continue;
                if (!module.hasExtraData()) break;
                count.setExtraData(module.writeExtraData());
                break;
            }
            this.drawMouseOver(guiGraphics, count.toString(), x, y);
        }
    }

    @Deprecated
    public void drawMouseOver(GuiGraphics guiGraphics, String str, int x, int y) {
        String[] split = str.split("\n");
        ArrayList<String> text = new ArrayList<String>(Arrays.asList(split));
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        for (String s : text) {
            list.add(Component.literal((String)s));
        }
        guiGraphics.setTooltipForNextFrame(Minecraft.getInstance().font, list, Optional.empty(), this.getGuiLeft() + x, this.getGuiTop() + y);
    }

    public void drawMouseOver(GuiGraphics guiGraphics, List<Component> list, int x, int y) {
        guiGraphics.setTooltipForNextFrame(Minecraft.getInstance().font, list, Optional.empty(), this.getGuiLeft() + x, this.getGuiTop() + y);
    }

    public void drawMouseOver(GuiGraphics guiGraphics, Component toolTip, int x, int y) {
        this.drawMouseOver(guiGraphics, Collections.singletonList(toolTip), x, y);
    }

    private void renderReturnMouseOver(GuiGraphics guiGraphics, int x, int y) {
        if (this.inRect(x -= this.getGuiLeft(), y -= this.getGuiTop(), this.returnButton)) {
            this.drawMouseOver(guiGraphics, (Component)Component.translatable((String)"gui.stevescarts.returnButton"), x, y);
        }
    }

    private int getModuleDisplayX(int id) {
        return id % 8 * 18 + 7;
    }

    private int getModuleDisplayY(int id) {
        return id / 8 * 18 + 182;
    }

    public boolean mouseClicked(double x, double y, int button) {
        ModuleBase thief = this.cart.getInterfaceThief();
        if (thief != null) {
            this.handleModuleMouseClicked(thief, (int)x, (int)y, button);
        } else if (this.cart.modules() != null) {
            if (this.inRect((int)x - this.getGuiLeft(), (int)y - this.getGuiTop(), this.scrollBox[0], this.scrollBox[1], this.scrollBox[2], this.scrollBox[3])) {
                this.scrollToMouse(y);
                this.isScrolling = true;
                return true;
            }
            for (ModuleBase module : this.cart.modules()) {
                this.handleModuleMouseClicked(module, (int)x, (int)y, button);
            }
            if (this.inRect((int)x - this.getGuiLeft(), (int)y - this.getGuiTop(), this.returnButton)) {
                StevesCartsClient.sendToServer(new PacketMinecartTurn(this.cart.getId()));
            }
        }
        return super.mouseClicked(x, y, button);
    }

    public boolean mouseReleased(double x, double y, int button) {
        ModuleBase thief = this.cart.getInterfaceThief();
        if (thief != null) {
            this.handleModuleMouseReleased(thief, (int)x, (int)y, button);
        } else if (this.cart.modules() != null) {
            for (ModuleBase module : this.cart.modules()) {
                this.handleModuleMouseReleased(module, (int)x, (int)y, button);
            }
        }
        this.isScrolling = false;
        return super.mouseReleased(x, y, button);
    }

    protected boolean inRect(int x, int y, int x1, int y1, int sizeX, int sizeY) {
        return x >= x1 && x <= x1 + sizeX && y >= y1 && y <= y1 + sizeY;
    }

    public boolean inRect(int x, int y, int[] coords) {
        return coords != null && x >= coords[0] && x < coords[0] + coords[2] && y >= coords[1] && y < coords[1] + coords[3];
    }

    public boolean mouseDragged(double x, double y, int button, double moveX, double moveY) {
        if (super.mouseDragged(x, y, button, moveX, moveY)) {
            return true;
        }
        if (this.isScrolling) {
            this.scrollToMouse(y);
            return true;
        }
        return false;
    }

    public void mouseMoved(double x, double y) {
        super.mouseMoved(x, y);
        if (this.isScrolling) {
            this.scrollToMouse(y);
        }
        if (this.cart.modules() != null) {
            ModuleBase thief = this.cart.getInterfaceThief();
            if (thief != null) {
                this.handleModuleMouseMoved(thief, (int)x, (int)y);
            } else {
                for (ModuleBase module : this.cart.modules()) {
                    this.handleModuleMouseMoved(module, (int)x, (int)y);
                }
            }
        }
    }

    private void scrollToMouse(double mouseY) {
        int temp = (int)mouseY - this.getGuiTop() - 12 - (this.scrollBox[1] + 2);
        if (temp < 0) {
            temp = 0;
        } else if (temp > 198) {
            temp = 198;
        }
        this.cart.setScrollY(temp);
    }

    public boolean keyPressed(int p_231046_1_, int id, int p_231046_3_) {
        super.keyPressed(p_231046_1_, id, p_231046_3_);
        if (this.cart.modules() != null) {
            ModuleBase thief = this.cart.getInterfaceThief();
            if (thief != null) {
                this.handleModuleKeyPress(thief, id, p_231046_3_);
            } else {
                for (ModuleBase module : this.cart.modules()) {
                    this.handleModuleKeyPress(module, id, p_231046_3_);
                }
            }
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void drawModuleForeground(GuiGraphics guiGraphics, ModuleBase module) {
        if (module.hasGui()) {
            module.drawForeground(guiGraphics, this);
            if (module.useButtons()) {
                module.drawButtonText(guiGraphics, this);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void drawModuleMouseOver(GuiGraphics guiGraphics, ModuleBase module, int x, int y) {
        if (module.hasGui()) {
            module.drawMouseOver(guiGraphics, this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY());
            if (module.useButtons()) {
                module.drawButtonOverlays(guiGraphics, this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY());
            }
        }
    }

    private void drawModuleSlots(GuiGraphics guiGraphics, ResourceLocation texture, ModuleBase module) {
        if (module.hasGui() && module.hasSlots()) {
            ArrayList<SlotStevesCarts> slotsList = module.getSlots();
            for (SlotStevesCarts slot : slotsList) {
                boolean drawAll;
                int[] rect = new int[]{slot.getX() + 1, slot.getY() + 1, 16, 16};
                module.handleScroll(rect);
                boolean bl = drawAll = rect[3] == 16;
                if (drawAll) {
                    slot.x = slot.getX() + module.getX() + 1;
                    slot.y = slot.getY() + module.getY() + 1 - this.cart.getRealScrollY();
                } else {
                    this.resetSlot(slot);
                }
                module.drawImage(guiGraphics, texture, this, slot.getX(), slot.getY(), this.getXSize() - 256, 0, 18, 18);
                if (drawAll) continue;
                module.drawImage(guiGraphics, texture, this, slot.getX() + 1, slot.getY() + 1, this.getXSize() - 256 + 18, 1, 16, 16);
            }
        }
    }

    private void resetSlot(SlotStevesCarts slot) {
        slot.x = -9001;
        slot.y = -9001;
    }

    private void drawModuleBackground(GuiGraphics guiGraphics, ModuleBase module, int x, int y) {
        if (module.hasGui()) {
            module.drawBackground(guiGraphics, this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY());
            if (module.useButtons()) {
                module.drawButtons(guiGraphics, this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY());
            }
        }
    }

    private void drawModuleBackgroundItems(GuiGraphics guiGraphics, ModuleBase module, int x, int y) {
        if (module.hasGui()) {
            module.drawBackgroundItems(guiGraphics, this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY());
        }
    }

    private void handleModuleMouseClicked(ModuleBase module, int x, int y, int button) {
        module.mouseClicked(this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY(), button);
        if (module.useButtons()) {
            module.mouseClickedButton(this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY(), button);
        }
    }

    private void handleModuleMouseReleased(ModuleBase module, int x, int y, int button) {
        module.mouseMovedOrUp(this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY(), button);
        module.mouseReleased(this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY(), button);
    }

    private void handleModuleMouseMoved(ModuleBase module, int x, int y) {
        module.mouseMovedOrUp(this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY(), -1);
        module.mouseMoved(this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY());
    }

    private void handleModuleKeyPress(ModuleBase module, int id, int extraInformation) {
        module.keyPress(this, id, extraInformation);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        if (scrollY < 0.0) {
            scrollY = -1.0;
        }
        if (scrollY > 0.0) {
            scrollY = 1.0;
        }
        if (this.inRect((int)mouseX - this.getGuiLeft(), (int)mouseY - this.getGuiTop(), 0, 0, this.imageWidth, this.imageHeight)) {
            int moduleSize = this.cart.modularSpaceHeight;
            int scroll = this.cart.getScrollY() + (int)(-scrollY) * 4000 / (moduleSize - 168);
            scroll = Mth.clamp((int)scroll, (int)0, (int)198);
            this.cart.setScrollY(scroll);
        }
        return true;
    }

    public void pushScissor() {
        GuiHelper.pushGuiScissor(this.minecraft, this.getGuiLeft() + 5, this.getGuiTop() + 4, 438.0, 164.0, this.width, this.height);
    }

    public void popScissor() {
        GuiHelper.popScissor();
    }

    public void drawTexturedModalRect(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y, int u, int v, int w, int h) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, x, y, (float)u, (float)v, w, h, 256, 256);
    }

    public static enum RENDER_ROTATION {
        NORMAL,
        ROTATE_90,
        ROTATE_180,
        ROTATE_270,
        FLIP_HORIZONTAL,
        ROTATE_90_FLIP,
        FLIP_VERTICAL,
        ROTATE_270_FLIP;


        public RENDER_ROTATION getNextRotation() {
            switch (this.ordinal()) {
                default: {
                    return ROTATE_90;
                }
                case 1: {
                    return ROTATE_180;
                }
                case 2: {
                    return ROTATE_270;
                }
                case 3: {
                    return NORMAL;
                }
                case 4: {
                    return ROTATE_90_FLIP;
                }
                case 5: {
                    return FLIP_VERTICAL;
                }
                case 6: {
                    return ROTATE_270_FLIP;
                }
                case 7: 
            }
            return FLIP_HORIZONTAL;
        }

        public RENDER_ROTATION getFlippedRotation() {
            switch (this.ordinal()) {
                default: {
                    return FLIP_HORIZONTAL;
                }
                case 1: {
                    return ROTATE_90_FLIP;
                }
                case 2: {
                    return FLIP_VERTICAL;
                }
                case 3: {
                    return ROTATE_270_FLIP;
                }
                case 4: {
                    return NORMAL;
                }
                case 5: {
                    return ROTATE_90;
                }
                case 6: {
                    return ROTATE_180;
                }
                case 7: 
            }
            return ROTATE_270;
        }
    }
}

