/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.client.guis;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import vswe.stevescarts.blocks.tileentities.TileEntityUpgrade;
import vswe.stevescarts.containers.ContainerUpgrade;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.upgrades.InterfaceUpgradeEffect;
import vswe.stevescarts.upgrades.InventoryUpgradeEffect;

public class GuiUpgrade
extends AbstractContainerScreen<ContainerUpgrade> {
    private static ResourceLocation texture = ResourceHelper.getResource("/gui/upgrade.png");
    private final TileEntityUpgrade upgrade;

    public GuiUpgrade(ContainerUpgrade containerUpgrade, Inventory playerInventory, Component iTextComponent) {
        super((AbstractContainerMenu)containerUpgrade, playerInventory, iTextComponent);
        this.upgrade = containerUpgrade.getUpgrade();
        this.imageWidth = 256;
        this.imageHeight = 190;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float p_230430_4_) {
        InterfaceUpgradeEffect gui;
        this.renderBackground(guiGraphics, mouseX, mouseY, p_230430_4_);
        super.render(guiGraphics, mouseX, mouseY, p_230430_4_);
        if (this.upgrade.getUpgrade() != null && (gui = this.upgrade.getUpgrade().getInterfaceEffect()) != null) {
            gui.drawForeground(this.upgrade, this);
            gui.drawMouseOver(guiGraphics, this.upgrade, this, mouseX, mouseY);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    public boolean inRect(int x, int y, int[] coords) {
        return coords != null && x >= coords[0] && x < coords[0] + coords[2] && y >= coords[1] && y < coords[1] + coords[3];
    }

    protected void renderBg(GuiGraphics guiGraphics, float p_230450_2_, int mouseX, int mouseY) {
        int j = this.getGuiLeft();
        int k = this.getGuiTop();
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, j, k, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        if (this.upgrade.getUpgrade() != null) {
            InterfaceUpgradeEffect gui;
            InventoryUpgradeEffect inventory = this.upgrade.getUpgrade().getInventoryEffect();
            if (inventory != null) {
                for (int i = 0; i < inventory.getInventorySize(); ++i) {
                    guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, j + inventory.getSlotX(i) - 1, k + inventory.getSlotY(i) - 1, 0.0f, (float)this.imageHeight, 18, 18, 256, 256);
                }
            }
            if ((gui = this.upgrade.getUpgrade().getInterfaceEffect()) != null) {
                gui.drawBackground(guiGraphics, this.upgrade, this, mouseX, mouseY);
            }
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int p_230451_2_, int p_230451_3_) {
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)this.upgrade.getUpgrade().getName()), 8, 6, -1);
    }
}

