/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.api.client.ModelCartbase;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.addons.ModuleLiquidSensors;

public class ModelLiquidSensors
extends ModelCartbase {
    private static ResourceLocation texture = ResourceHelper.getResource("/models/sensorModel.png");
    private int activeColour = 0;
    private ModelPart[] sensorLeft = new ModelPart[]{this.createSensor(false, 1), this.createSensor(false, 2), this.createSensor(false, 3)};
    private ModelPart[] sensorRight = new ModelPart[]{this.createSensor(true, 1), this.createSensor(true, 2), this.createSensor(true, 3)};

    public ModelLiquidSensors() {
        super(null, texture);
    }

    private ModelPart createSensor(boolean right, int colour) {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition base = modelPartData.addOrReplaceChild("base", CubeListBuilder.create().addBox(-0.5f, 2.0f, -0.5f, 1.0f, 4.0f, 1.0f), PartPose.offset((float)-9.0f, (float)-11.0f, (float)(right ? 7.0f : -7.0f)));
        PartDefinition head = base.addOrReplaceChild("head", CubeListBuilder.create().texOffs(4, 0).addBox(-3.0f, -2.0f, -3.0f, 4.0f, 4.0f, 4.0f), PartPose.offset((float)1.0f, (float)0.0f, (float)1.0f));
        PartDefinition face = head.addOrReplaceChild("face", CubeListBuilder.create().texOffs(20, 0).addBox(-1.5f, -1.0f, -2.0f, 1.0f, 2.0f, 2.0f), PartPose.offset((float)-2.5f, (float)0.0f, (float)0.0f));
        PartDefinition light = head.addOrReplaceChild("light_" + colour, CubeListBuilder.create().texOffs(20, 1 + colour * 3).addBox(-2.0f, -0.5f, -2.0f, 2.0f, 1.0f, 2.0f), PartPose.offset((float)0.0f, (float)-2.5f, (float)0.0f));
        return base.bake(32, 16);
    }

    @Override
    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumers, int light, int overlay, int colour) {
        this.sensorLeft[this.activeColour].render(poseStack, vertexConsumers, light, overlay, colour);
        this.sensorRight[this.activeColour].render(poseStack, vertexConsumers, light, overlay, colour);
    }

    @Override
    public void applyEffects(ModuleBase module, PoseStack matrixStack, MultiBufferSource rtb, float yaw, float pitch, float roll) {
        this.sensorLeft[this.activeColour].yRot = module == null ? 0.0f : -((ModuleLiquidSensors)module).getSensorRotation();
        this.sensorRight[this.activeColour].yRot = module == null ? 0.0f : ((ModuleLiquidSensors)module).getSensorRotation();
        this.activeColour = (module == null ? 2 : ((ModuleLiquidSensors)module).getLight()) - 1;
    }
}

