/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.client.renders;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import vswe.stevescarts.api.client.ModelCartbase;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.entities.ModularMinecart;
import vswe.stevescarts.init.ModItemData;
import vswe.stevescarts.init.ModItems;

public class ItemStackRenderer
implements SpecialModelRenderer<Data> {
    public void render(@Nullable Data data, ItemDisplayContext transformType, PoseStack matrixStack, MultiBufferSource iRenderTypeBuffer, int light, int overlay, boolean b) {
        ItemStack stack = data.stack;
        if (stack.getItem() != ModItems.CARTS.get()) {
            return;
        }
        matrixStack.pushPose();
        matrixStack.scale(-1.0f, -1.0f, 1.0f);
        CompoundTag info = ModItemData.getTagCopy(stack);
        if (info.contains("modules")) {
            float lowestMult = 1.0f;
            ModularMinecart cart = new ModularMinecart((Level)Minecraft.getInstance().level, 0.0, 0.0, 0.0, info);
            if (transformType == ItemDisplayContext.GUI) {
                matrixStack.translate(-1.0f, 0.0f, 0.0f);
            } else {
                matrixStack.translate(-0.5, -0.5, 0.5);
            }
            matrixStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
            matrixStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(180.0f));
            if (cart.modules() != null) {
                for (ModuleBase module : cart.modules()) {
                    if (module.getModels() == null) continue;
                    for (ModelCartbase model : module.getModels()) {
                        VertexConsumer buffer = iRenderTypeBuffer.getBuffer(model.getRenderType(module));
                        model.applyEffects(module, matrixStack, iRenderTypeBuffer, 0.0f, 0.0f, 0.0f);
                        model.renderToBuffer(matrixStack, buffer, light, overlay, -1);
                    }
                }
            }
        }
        matrixStack.popPose();
    }

    public void getExtents(Set<Vector3f> set) {
        set.add(new Vector3f());
    }

    @Nullable
    public Data extractArgument(ItemStack itemStack) {
        return new Data(itemStack);
    }

    public static class Data {
        public ItemStack stack;

        public Data(ItemStack stack) {
            this.stack = stack;
        }
    }

    public record Unbaked() implements SpecialModelRenderer.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(builder -> builder.stable((Object)new Unbaked()));

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        public SpecialModelRenderer<?> bake(EntityModelSet p_387681_) {
            return new ItemStackRenderer();
        }
    }
}

