/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.client.renders;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import vswe.stevescarts.api.client.ModelCartbase;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.entities.ModularMinecart;
import vswe.stevescarts.entities.ModularMinecartBehavior;

public class RenderModulerCart
extends EntityRenderer<ModularMinecart, ModularCartRenderState> {
    public RenderModulerCart(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(ModularCartRenderState state, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        if (state.isInvisible) {
            return;
        }
        super.render((EntityRenderState)state, poseStack, bufferSource, light);
        poseStack.pushPose();
        long offsetSeed = state.offsetSeed;
        float xOffset = (((float)(offsetSeed >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float yOffset = (((float)(offsetSeed >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float zOffset = (((float)(offsetSeed >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        poseStack.translate(xOffset, yOffset, zOffset);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(state.yRot));
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(-state.xRot));
        poseStack.translate(0.0f, 0.375f, 0.0f);
        float f3 = state.hurtTime;
        if (f3 > 0.0f) {
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(Mth.sin((float)f3) * f3 * state.damageTime / 10.0f * (float)state.hurtDir));
        }
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        for (ModuleBase module : state.modules) {
            if (!module.haveModels()) continue;
            for (ModelCartbase model : module.getModels()) {
                if (model.getRenderType(module) == null) continue;
                model.applyEffects(module, poseStack, bufferSource, state.yRot, state.xRot, 0.0f);
                model.renderToBuffer(poseStack, bufferSource.getBuffer(model.getRenderType(module)), light, OverlayTexture.NO_OVERLAY, -1);
            }
        }
        poseStack.popPose();
        this.renderTag(state.label, poseStack, bufferSource, light);
    }

    protected void renderTag(List<Component> label, PoseStack poseStack, MultiBufferSource source, int light) {
        boolean throughWalls = true;
        poseStack.pushPose();
        poseStack.translate(0.0, 1.2, 0.0);
        poseStack.mulPose((Quaternionfc)this.entityRenderDispatcher.cameraOrientation());
        poseStack.scale(0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.last().pose();
        Font font = this.getFont();
        int n = label.size() - 1;
        Objects.requireNonNull(font);
        int rowOffset = -(n * (9 + 1));
        for (Component component : label) {
            float f = (float)(-font.width((FormattedText)component)) / 2.0f;
            int j = (int)(Minecraft.getInstance().options.getBackgroundOpacity(0.25f) * 255.0f) << 24;
            font.drawInBatch(component, f, (float)rowOffset, -2130706433, false, matrix4f, source, throughWalls ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, j, light);
            if (throughWalls) {
                font.drawInBatch(component, f, (float)rowOffset, -1, false, matrix4f, source, Font.DisplayMode.NORMAL, 0, LightTexture.lightCoordsWithEmission((int)light, (int)2));
            }
            Objects.requireNonNull(font);
            rowOffset += 9 + 1;
        }
        poseStack.popPose();
    }

    public ModularCartRenderState createRenderState() {
        return new ModularCartRenderState();
    }

    public void extractRenderState(ModularMinecart entity, ModularCartRenderState state, float partialTick) {
        super.extractRenderState((Entity)entity, (EntityRenderState)state, partialTick);
        ModularMinecartBehavior behavior = (ModularMinecartBehavior)entity.getBehavior();
        if (behavior.cartHasPosRotLerp()) {
            state.renderPos = behavior.getCartLerpPosition(partialTick);
            state.xRot = behavior.getCartLerpXRot(partialTick);
            state.yRot = behavior.getCartLerpYRot(partialTick);
        } else {
            state.renderPos = null;
            state.xRot = entity.getXRot();
            state.yRot = entity.getYRot();
        }
        long seedBase = (long)entity.getId() * 493286711L;
        state.offsetSeed = seedBase * seedBase * 4392167121L + seedBase * 98761L;
        state.hurtTime = (float)entity.getHurtTime() - partialTick;
        state.hurtDir = entity.getHurtDir();
        state.damageTime = Math.max(entity.getDamage() - partialTick, 0.0f);
        state.displayOffset = entity.getDisplayOffset();
        state.modules.clear();
        state.modules.addAll(entity.modules());
        state.isInvisible = entity.isInvisible() || state.modules.stream().anyMatch(e -> !e.shouldCartRender());
        state.label.clear();
        state.label.addAll(entity.getLabel());
    }

    public static class ModularCartRenderState
    extends EntityRenderState {
        public boolean isInvisible;
        public float xRot;
        public float yRot;
        public long offsetSeed;
        public int hurtDir;
        public float hurtTime;
        public float damageTime;
        public int displayOffset;
        @Nullable
        public Vec3 renderPos;
        public List<ModuleBase> modules = new ArrayList<ModuleBase>();
        public List<Component> label = new ArrayList<Component>();
    }
}

