/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.containers;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.blocks.tileentities.TileEntityLiquid;
import vswe.stevescarts.containers.ContainerBase;
import vswe.stevescarts.containers.slots.SlotLiquidFilter;
import vswe.stevescarts.containers.slots.SlotLiquidManagerInput;
import vswe.stevescarts.containers.slots.SlotLiquidOutput;
import vswe.stevescarts.init.ModContainers;

public class ContainerLiquid
extends ContainerBase {
    public FluidStack[] oldLiquids = new FluidStack[4];
    public SimpleContainerData data;
    private final TileEntityLiquid tileEntityLiquid;

    public ContainerLiquid(int id, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(id, playerInventory, (TileEntityLiquid)Objects.requireNonNull(Minecraft.getInstance().level.getBlockEntity(packetBuffer.readBlockPos())), new SimpleContainerData(17));
    }

    public ContainerLiquid(int id, Inventory playerInventory, TileEntityLiquid tileEntityLiquid, SimpleContainerData data) {
        super((MenuType)ModContainers.CONTAINER_LIQUID.get(), id);
        this.tileEntityLiquid = tileEntityLiquid;
        this.data = data;
        for (int i = 0; i < 4; ++i) {
            int x = i % 2;
            int y = i / 2;
            this.addSlot(new SlotLiquidManagerInput(tileEntityLiquid, i, i * 3, x == 0 ? 6 : 208, y == 0 ? 17 : 80));
            this.addSlot(new SlotLiquidOutput(tileEntityLiquid, i * 3 + 1, x == 0 ? 6 : 208, y == 0 ? 42 : 105));
            this.addSlot(new SlotLiquidFilter(tileEntityLiquid, i * 3 + 2, x == 0 ? 66 : 148, y == 0 ? 12 : 110));
        }
        for (int k = 0; k < 3; ++k) {
            for (int j1 = 0; j1 < 9; ++j1) {
                if (playerInventory == null) continue;
                this.addSlot(new Slot((Container)playerInventory, j1 + k * 9 + 9, j1 * 18 + this.offsetX(), 104 + k * 18 + 36));
            }
        }
        for (int l = 0; l < 9; ++l) {
            if (playerInventory == null) continue;
            this.addSlot(new Slot((Container)playerInventory, l, l * 18 + this.offsetX(), 198));
        }
        this.addDataSlots((ContainerData)data);
    }

    public int getLayoutType() {
        return this.data.get(0);
    }

    public int[] getColor() {
        return new int[]{this.data.get(1), this.data.get(2), this.data.get(3), this.data.get(4)};
    }

    public boolean[] toCart() {
        return new boolean[]{this.data.get(5) == 1, this.data.get(6) == 1, this.data.get(7) == 1, this.data.get(8) == 1};
    }

    public boolean[] doReturn() {
        return new boolean[]{this.data.get(9) == 1, this.data.get(10) == 1, this.data.get(11) == 1, this.data.get(12) == 1};
    }

    private int[] getAmounts() {
        return new int[]{this.data.get(13), this.data.get(14), this.data.get(15), this.data.get(16)};
    }

    public int getMaxAmount(int id) {
        return (int)(this.getMaxAmountBuckets(id) * 1000.0f);
    }

    public float getMaxAmountBuckets(int id) {
        return switch (this.getAmounts()[id]) {
            case 1 -> 0.25f;
            case 2 -> 0.5f;
            case 3 -> 0.75f;
            case 4 -> 1.0f;
            case 5 -> 2.0f;
            case 6 -> 3.0f;
            case 7 -> 5.0f;
            case 8 -> 7.5f;
            case 9 -> 10.0f;
            case 10 -> 15.0f;
            default -> 0.0f;
        };
    }

    protected int offsetX() {
        return 35;
    }

    public TileEntityLiquid getTileEntityLiquid() {
        return this.tileEntityLiquid;
    }

    public boolean stillValid(@NotNull Player playerEntity) {
        return true;
    }
}

