/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.datagen;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import vswe.stevescarts.api.modules.data.ModuleData;
import vswe.stevescarts.helpers.ComponentTypes;
import vswe.stevescarts.init.ModBlocks;
import vswe.stevescarts.init.ModItems;
import vswe.stevescarts.init.StevesCartsModules;

public class GeneratorRecipes
extends RecipeProvider {
    public GeneratorRecipes(HolderLookup.Provider provider, RecipeOutput output) {
        super(provider, output);
    }

    protected void buildRecipes() {
        this.addBlockRecipes();
        this.addSmithingTableRecipes();
        this.addModuleRecipes();
        this.addSmelting();
        this.shapedCrafting();
    }

    private void addSmelting() {
        this.oreCooking(RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, (ItemLike)this.itemFromName("stevescarts:component_raw_hardener"), RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_refined_hardener"), 0.7f, 200, "stevescarts", "_from_smelting");
        this.oreCooking(RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, (ItemLike)this.itemFromName("stevescarts:component_large_lump_of_galgador"), RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_enhanced_galgadorian_metal"), 0.7f, 200, "stevescarts", "_from_smelting");
        this.oreCooking(RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, (ItemLike)this.itemFromName("stevescarts:component_stabilized_metal"), RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_reinforced_metal"), 0.7f, 200, "stevescarts", "_from_smelting");
        this.oreCooking(RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, (ItemLike)this.itemFromName("stevescarts:component_raw_handle"), RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_refined_handle"), 0.7f, 200, "stevescarts", "_from_smelting");
        this.oreCooking(RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, (ItemLike)this.itemFromName("stevescarts:component_lump_of_galgador"), RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_galgadorian_metal"), 0.7f, 200, "stevescarts", "_from_smelting");
    }

    private void addBlockRecipes() {
        this.shaped(RecipeCategory.MISC, (ItemLike)ModBlocks.ADVANCED_DETECTOR.get()).pattern("#P#").pattern("#X#").pattern("#P#").define(Character.valueOf('X'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('#'), Tags.Items.INGOTS_IRON).define(Character.valueOf('P'), (ItemLike)Items.STONE_PRESSURE_PLATE).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)ModBlocks.GALGADORIAN_METAL.get()).pattern("XXX").pattern("XXX").pattern("XXX").define(Character.valueOf('X'), (ItemLike)ModItems.COMPONENTS.get((Object)ComponentTypes.GALGADORIAN_METAL).get()).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)ModBlocks.REINFORCED_METAL.get()).pattern("XXX").pattern("XXX").pattern("XXX").define(Character.valueOf('X'), (ItemLike)ModItems.COMPONENTS.get((Object)ComponentTypes.REINFORCED_METAL).get()).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output);
    }

    private void addModuleRecipes() {
        this.shaped(RecipeCategory.MISC, (ItemLike)this.getStackFromModule(StevesCartsModules.CHUNK_LOADER).getItem()).pattern("III").pattern("GEG").pattern("IDI").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('E'), (ItemLike)Items.ENDER_EYE).define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output);
    }

    private void addSmithingTableRecipes() {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike)Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE), (Ingredient)Ingredient.of((ItemLike)this.getStackFromModule(StevesCartsModules.BASIC_WOOD_CUTTER).getItem()), (Ingredient)Ingredient.of((ItemLike)Items.NETHERITE_INGOT), (RecipeCategory)RecipeCategory.MISC, (Item)this.getStackFromModule(StevesCartsModules.NETHERITE_WOOD_CUTTER).getItem()).unlocks("has_item", this.has(Tags.Items.INGOTS_NETHERITE)).save(this.output, this.recipeFolder((ItemLike)this.getStackFromModule(StevesCartsModules.NETHERITE_WOOD_CUTTER).getItem(), "smithing"));
    }

    private ResourceKey<Recipe<?>> recipeFolder(ItemLike result, String folder) {
        ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)result.asItem());
        return ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"stevescarts", (String)(folder + "/" + key.getPath())));
    }

    protected <T extends AbstractCookingRecipe> void oreCooking(RecipeSerializer<T> serializer, AbstractCookingRecipe.Factory<T> recipeFactory, ItemLike input, RecipeCategory category, ItemLike result, float experience, int cookingTime, String group, String suffix) {
        SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike)input), (RecipeCategory)category, (ItemLike)result, (float)experience, (int)cookingTime, serializer, recipeFactory).group(group).unlockedBy(GeneratorRecipes.getHasName((ItemLike)input), this.has(input)).save(this.output, this.recipeFolder(result, "smelting"));
    }

    private Item itemFromName(String name) {
        return (Item)((Holder.Reference)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)name)).get()).value();
    }

    private ItemStack getStackFromModule(ModuleData moduleData) {
        if (moduleData == null) {
            return ItemStack.EMPTY;
        }
        Supplier<Item> itemSupplier = ModItems.MODULES.get(moduleData);
        if (itemSupplier == null || itemSupplier.get() == null) {
            return ItemStack.EMPTY;
        }
        return new ItemStack((ItemLike)itemSupplier.get());
    }

    private void shapedCrafting() {
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).pattern("#X#").pattern("XGX").pattern("#X#").define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).define(Character.valueOf('G'), (ItemLike)this.itemFromName("minecraft:gold_ingot")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:redstone")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_simple_pcb"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_compact_solar_engine")).pattern("#I#").pattern("XRX").pattern("PIP").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_advanced_pcb")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_advanced_solar_panel")).define(Character.valueOf('P'), (ItemLike)this.itemFromName("minecraft:piston")).define(Character.valueOf('R'), (ItemLike)this.itemFromName("minecraft:redstone")).define(Character.valueOf('I'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_compact_solar_engine"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_steves_arcade")).pattern(" G ").pattern("X#X").pattern("RXR").define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).define(Character.valueOf('X'), ItemTags.PLANKS).define(Character.valueOf('R'), (ItemLike)this.itemFromName("minecraft:redstone")).define(Character.valueOf('G'), (ItemLike)this.itemFromName("minecraft:glass_pane")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_steves_arcade"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_railer")).pattern("###").pattern("XRX").pattern("###").define(Character.valueOf('R'), (ItemLike)this.itemFromName("minecraft:rail")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).define(Character.valueOf('#'), ItemTags.STONE_CRAFTING_MATERIALS).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_railer"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_empty_disk")).pattern("#").pattern("X").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:redstone")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_empty_disk"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:upgrade_thermal_engine")).pattern("NXN").pattern("PFP").pattern("O#O").define(Character.valueOf('P'), (ItemLike)this.itemFromName("minecraft:piston")).define(Character.valueOf('F'), (ItemLike)this.itemFromName("minecraft:furnace")).define(Character.valueOf('N'), (ItemLike)this.itemFromName("minecraft:nether_brick")).define(Character.valueOf('O'), (ItemLike)this.itemFromName("minecraft:obsidian")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_advanced_pcb")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_blank_upgrade")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:upgrade_thermal_engine"), "upgrade"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_side_chests")).pattern("#X#").pattern("LCL").pattern("#X#").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_chest_pane")).define(Character.valueOf('L'), (ItemLike)this.itemFromName("stevescarts:component_large_chest_pane")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_huge_chest_pane")).define(Character.valueOf('C'), (ItemLike)this.itemFromName("stevescarts:component_chest_lock")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_side_chests"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_hydrator")).pattern("I#I").pattern(" X ").define(Character.valueOf('I'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:oak_fence")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:glass_bottle")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_hydrator"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_invisibility_core")).pattern(" X ").pattern("XEX").pattern(" # ").define(Character.valueOf('E'), (ItemLike)this.itemFromName("minecraft:ender_eye")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:golden_carrot")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_glass_o_magic")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_invisibility_core"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_tri_torch")).pattern("###").define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:torch")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_tri_torch"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:upgrade_module_input")).pattern(" X ").pattern("PCP").pattern("I#I").define(Character.valueOf('I'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).define(Character.valueOf('P'), (ItemLike)this.itemFromName("minecraft:piston")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_advanced_pcb")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_blank_upgrade")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:upgrade_module_input"), "upgrade"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("minecraft:spruce_planks"), 2).pattern("X").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_spruce_log")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("minecraft:spruce_planks"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_milker")).pattern("XXX").pattern("#B#").pattern(" # ").define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:wheat")).define(Character.valueOf('B'), (ItemLike)this.itemFromName("minecraft:bucket")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_milker"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_eye_of_galgador")).pattern("X#X").pattern("TET").pattern("X#X").define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:magma_cream")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:fermented_spider_eye")).define(Character.valueOf('E'), (ItemLike)this.itemFromName("minecraft:ender_eye")).define(Character.valueOf('T'), (ItemLike)this.itemFromName("minecraft:ghast_tear")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_eye_of_galgador"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_huge_iron_pane")).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_iron_pane")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_huge_iron_pane"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:upgrade_cart_deployer")).pattern("IRI").pattern("XPX").pattern("I#I").define(Character.valueOf('I'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).define(Character.valueOf('R'), (ItemLike)this.itemFromName("minecraft:rail")).define(Character.valueOf('P'), (ItemLike)this.itemFromName("minecraft:piston")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_blank_upgrade")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:upgrade_cart_deployer"), "upgrade"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_advanced_shooter")).pattern(" D ").pattern(" SP").pattern("IEI").define(Character.valueOf('D'), (ItemLike)this.itemFromName("stevescarts:component_entity_scanner")).define(Character.valueOf('S'), (ItemLike)this.itemFromName("stevescarts:component_shooting_station")).define(Character.valueOf('P'), (ItemLike)this.itemFromName("stevescarts:component_pipe")).define(Character.valueOf('I'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).define(Character.valueOf('E'), (ItemLike)this.itemFromName("stevescarts:component_entity_analyzer")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_advanced_shooter"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:blockjunction"), 1).pattern(" # ").pattern("#X#").pattern(" # ").define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:rail")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:redstone")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:blockjunction"), "block"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_galgadorian_metal"), 9).pattern("X").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:galgadorian_metal")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_galgadorian_metal"), "block"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("minecraft:birch_planks"), 2).pattern("X").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_birch_log")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("minecraft:birch_planks"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_track_remover")).pattern("###").pattern("# #").pattern("#  ").define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_track_remover"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:blockdistributor"), 1).pattern("X#X").pattern("#R#").pattern("X#X").define(Character.valueOf('X'), ItemTags.STONE_CRAFTING_MATERIALS).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).define(Character.valueOf('R'), (ItemLike)this.itemFromName("minecraft:redstone")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:blockdistributor"), "block"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_entity_detector_animal")).pattern("#").pattern("X").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_empty_disk")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:porkchop")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_entity_detector_animal"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_entity_analyzer")).pattern("#X#").pattern("#P#").pattern("###").define(Character.valueOf('P'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:redstone")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_entity_analyzer"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_fuse"), 12).pattern("#").pattern("#").pattern("#").define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:string")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_fuse"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_iron_blade"), 4).pattern(" # ").pattern("XXX").pattern(" X ").define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:shears")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_iron_blade"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_huge_dynamic_pane")).pattern("###").pattern("#X#").pattern("###").define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_dynamic_pane")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_huge_dynamic_pane"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_top_sctank")).pattern("###").pattern("XCX").pattern("###").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_sctank_pane")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_huge_sctank_pane")).define(Character.valueOf('C'), (ItemLike)this.itemFromName("stevescarts:component_sctank_valve")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_top_sctank"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_front_sctank")).pattern("X#X").pattern("XCX").pattern("###").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_sctank_pane")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_large_sctank_pane")).define(Character.valueOf('C'), (ItemLike)this.itemFromName("stevescarts:component_sctank_valve")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_front_sctank"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_galgadorian_farmer")).pattern("DDD").pattern(" I ").pattern("#X#").define(Character.valueOf('I'), (ItemLike)this.itemFromName("stevescarts:component_reinforced_metal")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:gold_ingot")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_advanced_pcb")).define(Character.valueOf('D'), (ItemLike)this.itemFromName("stevescarts:component_galgadorian_metal")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_galgadorian_farmer"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_information_provider")).pattern("XXX").pattern("IGI").pattern("#S#").define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:glass_pane")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).define(Character.valueOf('S'), (ItemLike)this.itemFromName("minecraft:oak_sign")).define(Character.valueOf('G'), (ItemLike)this.itemFromName("minecraft:glowstone_dust")).define(Character.valueOf('I'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_information_provider"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("minecraft:oak_planks"), 2).pattern("X").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_oak_log")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("minecraft:oak_planks"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_raw_hardener"), 2).pattern("# #").pattern(" X ").pattern("# #").define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:diamond")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:obsidian")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_raw_hardener"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_side_tanks")).pattern("#X#").pattern("LCL").pattern("#X#").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_sctank_pane")).define(Character.valueOf('L'), (ItemLike)this.itemFromName("stevescarts:component_large_sctank_pane")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_huge_sctank_pane")).define(Character.valueOf('C'), (ItemLike)this.itemFromName("stevescarts:component_sctank_valve")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_side_tanks"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_drill_intelligence")).pattern("XXX").pattern("I#I").pattern("#R#").define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_advanced_pcb")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:gold_ingot")).define(Character.valueOf('R'), (ItemLike)this.itemFromName("minecraft:redstone")).define(Character.valueOf('I'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_drill_intelligence"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_speed_handle")).pattern("  B").pattern("XH ").pattern("#X ").define(Character.valueOf('B'), (ItemLike)this.itemFromName("minecraft:blue_dye")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:gold_ingot")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:redstone")).define(Character.valueOf('H'), (ItemLike)this.itemFromName("stevescarts:component_refined_handle")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_speed_handle"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_divine_shield")).pattern("O#O").pattern("#X#").pattern("O#O").define(Character.valueOf('O'), (ItemLike)this.itemFromName("minecraft:obsidian")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:diamond_block")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_refined_hardener")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_divine_shield"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_height_controller")).pattern(" C ").pattern("#X#").pattern("###").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:paper")).define(Character.valueOf('C'), (ItemLike)this.itemFromName("minecraft:compass")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_height_controller"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_green_pigment")).pattern(" # ").pattern("XXX").pattern(" # ").define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:green_dye")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:glowstone_dust")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_green_pigment"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_dynamic_pane")).pattern("#").pattern("X").define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_iron_pane")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:redstone")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_dynamic_pane"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_cleaning_core")).pattern("C#C").pattern("XXX").pattern("#X#").define(Character.valueOf('C'), (ItemLike)this.itemFromName("stevescarts:component_cleaning_fan")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_cleaning_tube")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_cleaning_core"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_huge_chest_pane")).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_chest_pane")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_huge_chest_pane"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_chest_lock"), 8).pattern("X").pattern("#").define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).define(Character.valueOf('X'), ItemTags.STONE_CRAFTING_MATERIALS).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_chest_lock"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:upgrade_batteries")).pattern("XXX").pattern("XDX").pattern("X#X").define(Character.valueOf('D'), (ItemLike)this.itemFromName("minecraft:diamond")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:redstone")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_blank_upgrade")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:upgrade_batteries"), "upgrade"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_galgadorian_farmer")).pattern("DDD").pattern(" # ").pattern(" X ").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:module_basic_farmer")).define(Character.valueOf('D'), (ItemLike)this.itemFromName("stevescarts:component_galgadorian_metal")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_galgadorian_farmer"), "module_alt"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_advanced_thermal_engine")).pattern("OOO").pattern("#X#").pattern("P P").define(Character.valueOf('O'), (ItemLike)this.itemFromName("minecraft:nether_brick")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_reinforced_metal")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:module_thermal_engine")).define(Character.valueOf('P'), (ItemLike)this.itemFromName("minecraft:piston")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_advanced_thermal_engine"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_blade_arm")).pattern("# #").pattern(" X ").pattern("# #").define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_iron_blade")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_blade_arm"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_large_dynamic_pane")).pattern(" # ").pattern("#X#").pattern(" # ").define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_dynamic_pane")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:redstone")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_large_dynamic_pane"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_galgadorian_wheels")).pattern(" X ").pattern("X#X").pattern(" X ").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_reinforced_metal")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_galgadorian_metal")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_galgadorian_wheels"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_coal_engine")).pattern("###").pattern("#X#").pattern("P P").define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:furnace")).define(Character.valueOf('P'), (ItemLike)this.itemFromName("minecraft:piston")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_coal_engine"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:upgrade_power_crystal")).pattern("DXD").pattern("XEX").pattern("D#D").define(Character.valueOf('D'), (ItemLike)this.itemFromName("minecraft:diamond")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:glowstone_dust")).define(Character.valueOf('E'), (ItemLike)this.itemFromName("minecraft:emerald_block")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:upgrade_batteries")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:upgrade_power_crystal"), "upgrade"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_cleaning_fan")).pattern("#X#").pattern("X X").pattern("#X#").define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:redstone")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:iron_bars")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_cleaning_fan"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_experience_bank")).pattern(" X ").pattern("GEG").pattern("#C#").define(Character.valueOf('E'), (ItemLike)this.itemFromName("minecraft:emerald")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).define(Character.valueOf('C'), (ItemLike)this.itemFromName("minecraft:cauldron")).define(Character.valueOf('G'), (ItemLike)this.itemFromName("minecraft:glowstone_dust")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:redstone")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_experience_bank"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_stabilized_metal"), 5).pattern("#M#").pattern("###").pattern("XXX").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_refined_hardener")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).define(Character.valueOf('M'), (ItemLike)this.itemFromName("stevescarts:component_hardened_mesh")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_stabilized_metal"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_entity_detector_bat")).pattern("#").pattern("X").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_empty_disk")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:pumpkin")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_entity_detector_bat"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_reinforced_hull")).pattern("# #").pattern("###").pattern("X X").define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_reinforced_metal")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_reinforced_wheels")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_reinforced_hull"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_large_railer")).pattern("###").pattern("XRX").pattern("###").define(Character.valueOf('R'), (ItemLike)this.itemFromName("minecraft:rail")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:module_railer")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_large_railer"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_advanced_pcb")).pattern("#X#").pattern("PXP").pattern("#X#").define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).define(Character.valueOf('P'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:redstone")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_advanced_pcb"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_melter")).pattern("O#O").pattern("GXG").pattern("O#O").define(Character.valueOf('O'), (ItemLike)this.itemFromName("minecraft:nether_bricks")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:furnace")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:glowstone")).define(Character.valueOf('G'), (ItemLike)this.itemFromName("minecraft:glowstone_dust")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_melter"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_glistering_easter_egg")).pattern("###").pattern("#X#").pattern("#B#").define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:gold_nugget")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:gunpowder")).define(Character.valueOf('B'), (ItemLike)this.itemFromName("minecraft:blue_dye")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_glistering_easter_egg"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_power_observer")).pattern(" X ").pattern("IRI").pattern("R#R").define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_advanced_pcb")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:piston")).define(Character.valueOf('R'), (ItemLike)this.itemFromName("minecraft:redstone")).define(Character.valueOf('I'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_power_observer"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_large_lump_of_galgador")).pattern("XXX").pattern("XXX").pattern("XXX").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_lump_of_galgador")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_large_lump_of_galgador"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:upgrade_module_knowledge")).pattern("BSB").pattern("SES").pattern("X#X").define(Character.valueOf('E'), (ItemLike)this.itemFromName("minecraft:enchanting_table")).define(Character.valueOf('B'), (ItemLike)this.itemFromName("minecraft:book")).define(Character.valueOf('S'), (ItemLike)this.itemFromName("minecraft:bookshelf")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_reinforced_metal")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_blank_upgrade")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:upgrade_module_knowledge"), "upgrade"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_galgadorian_wood_cutter")).pattern("###").pattern("#I#").pattern(" X ").define(Character.valueOf('I'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:module_hardened_wood_cutter")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_galgadorian_metal")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_galgadorian_wood_cutter"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_chocolate_easter_egg")).pattern("#S#").pattern("#X#").pattern("#S#").define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:egg")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:cocoa_beans")).define(Character.valueOf('S'), (ItemLike)this.itemFromName("minecraft:sugar")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_chocolate_easter_egg"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_top_chest")).pattern("###").pattern("XCX").pattern("###").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_chest_pane")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_huge_chest_pane")).define(Character.valueOf('C'), (ItemLike)this.itemFromName("stevescarts:component_chest_lock")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_top_chest"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_pipe")).pattern("XXX").pattern("#  ").define(Character.valueOf('X'), ItemTags.STONE_CRAFTING_MATERIALS).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_pipe"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_liquid_cleaning_core")).pattern("C#C").pattern("XXX").pattern("#X#").define(Character.valueOf('C'), (ItemLike)this.itemFromName("stevescarts:component_cleaning_fan")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_liquid_cleaning_tube")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_liquid_cleaning_core"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_liquid_cleaner")).pattern("#X#").pattern("# #").pattern("# #").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_liquid_cleaning_core")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_liquid_cleaning_tube")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_liquid_cleaner"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_liquid_cleaning_tube"), 2).pattern("#X#").pattern("#X#").pattern("#X#").define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:green_dye")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_liquid_cleaning_tube"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:blockcartassembler"), 1).pattern("X#X").pattern("#X#").pattern("R#R").define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:stone")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).define(Character.valueOf('R'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:blockcartassembler"), "block"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_shooting_station")).pattern("# #").pattern("#G#").pattern("DXD").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:redstone")).define(Character.valueOf('G'), (ItemLike)this.itemFromName("minecraft:gold_ingot")).define(Character.valueOf('D'), (ItemLike)this.itemFromName("minecraft:dispenser")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_shooting_station"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_cake_server")).pattern(" C ").pattern("XXX").pattern(" # ").define(Character.valueOf('X'), ItemTags.WOODEN_SLABS).define(Character.valueOf('C'), (ItemLike)this.itemFromName("minecraft:cake")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_cake_server"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_ore_extractor")).pattern("T T").pattern("XGX").pattern("R#R").define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_advanced_pcb")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_eye_of_galgador")).define(Character.valueOf('T'), (ItemLike)this.itemFromName("minecraft:redstone_torch")).define(Character.valueOf('R'), (ItemLike)this.itemFromName("minecraft:quartz")).define(Character.valueOf('G'), (ItemLike)this.itemFromName("stevescarts:component_galgadorian_metal")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_ore_extractor"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_advanced_control_system")).pattern(" D ").pattern("XWX").pattern("##H").define(Character.valueOf('D'), (ItemLike)this.itemFromName("stevescarts:component_graphical_interface")).define(Character.valueOf('W'), (ItemLike)this.itemFromName("stevescarts:component_wheel")).define(Character.valueOf('H'), (ItemLike)this.itemFromName("stevescarts:component_speed_handle")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:redstone")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_advanced_control_system"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_crafter")).pattern("X").pattern("#").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:crafting_table")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_crafter"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:upgrade_generic_engine")).pattern(" X ").pattern("PFP").pattern("I#I").define(Character.valueOf('I'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).define(Character.valueOf('F'), (ItemLike)this.itemFromName("minecraft:furnace")).define(Character.valueOf('P'), (ItemLike)this.itemFromName("minecraft:piston")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_blank_upgrade")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:upgrade_generic_engine"), "upgrade"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:upgrade_experienced_assembler")).pattern("SBS").pattern("XLX").pattern("X#X").define(Character.valueOf('B'), (ItemLike)this.itemFromName("minecraft:enchanted_book")).define(Character.valueOf('L'), (ItemLike)this.itemFromName("stevescarts:component_advanced_pcb")).define(Character.valueOf('S'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_reinforced_metal")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_blank_upgrade")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:upgrade_experienced_assembler"), "upgrade"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_chest_lock"), 8).pattern("#").pattern("X").define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).define(Character.valueOf('X'), ItemTags.STONE_CRAFTING_MATERIALS).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_chest_lock"), "component_alt"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_saw_blade")).pattern("##X").define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:diamond")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_saw_blade"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_galgadorian_wood_cutter")).pattern("###").pattern("#I#").pattern(" X ").define(Character.valueOf('I'), (ItemLike)this.itemFromName("stevescarts:component_reinforced_metal")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_wood_cutting_core")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_galgadorian_saw_blade")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_galgadorian_wood_cutter"), "module_alt"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_hardened_mesh")).pattern("#X#").pattern("X#X").pattern("#X#").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_refined_hardener")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:iron_bars")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_hardened_mesh"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_torch_placer")).pattern("X X").pattern("# #").pattern("###").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_tri_torch")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_torch_placer"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_mechanical_pig")).pattern("# #").pattern("###").pattern("X X").define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:porkchop")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_iron_wheels")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_mechanical_pig"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_smelter")).pattern("X").pattern("#").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:furnace")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_smelter"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_advanced_sctank")).pattern("XXX").pattern("X#X").pattern("XXX").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_huge_sctank_pane")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_sctank_valve")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_advanced_sctank"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_thermal_engine")).pattern("OOO").pattern("#X#").pattern("P P").define(Character.valueOf('O'), (ItemLike)this.itemFromName("minecraft:nether_bricks")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:obsidian")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:furnace")).define(Character.valueOf('P'), (ItemLike)this.itemFromName("minecraft:piston")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_thermal_engine"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_reinforced_wheels")).pattern(" X ").pattern("X#X").pattern(" X ").define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_reinforced_metal")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_reinforced_wheels"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_hardened_saw_blade")).pattern("##X").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_reinforced_metal")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_hardened_saw_blade"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_wheel")).pattern("#X#").pattern("X#X").pattern(" X ").define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:stick")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_wheel"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_entity_detector_player")).pattern("#").pattern("X").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_empty_disk")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:diamond")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_entity_detector_player"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_solar_engine")).pattern("I#I").pattern("#X#").pattern("P#P").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_advanced_pcb")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_solar_panel_component")).define(Character.valueOf('P'), (ItemLike)this.itemFromName("minecraft:piston")).define(Character.valueOf('I'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_solar_engine"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_warm_hat")).pattern(" #X").pattern("#D#").pattern("###").define(Character.valueOf('D'), (ItemLike)this.itemFromName("minecraft:diamond")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:white_wool")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:red_wool")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_warm_hat"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_tiny_coal_engine")).pattern("#X#").pattern(" P ").define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:furnace")).define(Character.valueOf('P'), (ItemLike)this.itemFromName("minecraft:piston")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_tiny_coal_engine"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_burning_easter_egg")).pattern("#B#").pattern("#X#").pattern("RMY").define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:egg")).define(Character.valueOf('R'), (ItemLike)this.itemFromName("minecraft:red_dye")).define(Character.valueOf('Y'), (ItemLike)this.itemFromName("minecraft:yellow_dye")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:blaze_powder")).define(Character.valueOf('B'), (ItemLike)this.itemFromName("minecraft:blaze_rod")).define(Character.valueOf('M'), (ItemLike)this.itemFromName("minecraft:magma_cream")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_burning_easter_egg"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_enhanced_galgadorian_metal"), 9).pattern("X").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:enhanced_galgadorian_metal")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_enhanced_galgadorian_metal"), "block"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_graphical_interface")).pattern("GDG").pattern("XPX").pattern("#X#").define(Character.valueOf('D'), (ItemLike)this.itemFromName("minecraft:diamond")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:glass_pane")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:redstone")).define(Character.valueOf('G'), (ItemLike)this.itemFromName("minecraft:gold_ingot")).define(Character.valueOf('P'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_graphical_interface"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_red_gift_ribbon")).pattern("###").pattern("#X#").pattern("###").define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:string")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:red_dye")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_red_gift_ribbon"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_basic_farmer")).pattern("DDD").pattern(" I ").pattern("#X#").define(Character.valueOf('I'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:gold_ingot")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).define(Character.valueOf('D'), (ItemLike)this.itemFromName("minecraft:diamond")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_basic_farmer"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_wooden_hull")).pattern("# #").pattern("###").pattern("X X").define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_wooden_wheels")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_wooden_hull"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_entity_detector_villager")).pattern("#").pattern("X").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_empty_disk")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:emerald")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_entity_detector_villager"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_hardened_wood_cutter")).pattern("###").pattern("#I#").pattern(" X ").define(Character.valueOf('I'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:module_basic_wood_cutter")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_reinforced_metal")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_hardened_wood_cutter"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_enchanter")).pattern(" G ").pattern("XEX").pattern("R#R").define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_advanced_pcb")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:book")).define(Character.valueOf('E'), (ItemLike)this.itemFromName("minecraft:enchanting_table")).define(Character.valueOf('R'), (ItemLike)this.itemFromName("minecraft:redstone")).define(Character.valueOf('G'), (ItemLike)this.itemFromName("stevescarts:component_galgadorian_metal")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_enchanter"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_note_sequencer")).pattern("# #").pattern("#J#").pattern("XRX").define(Character.valueOf('X'), ItemTags.PLANKS).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:note_block")).define(Character.valueOf('J'), (ItemLike)this.itemFromName("minecraft:jukebox")).define(Character.valueOf('R'), (ItemLike)this.itemFromName("minecraft:redstone")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_note_sequencer"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_bridge_builder")).pattern(" R ").pattern("X#X").pattern(" P ").define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:bricks")).define(Character.valueOf('R'), (ItemLike)this.itemFromName("minecraft:redstone")).define(Character.valueOf('P'), (ItemLike)this.itemFromName("minecraft:piston")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_bridge_builder"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:upgrade_cotwo_friendly")).pattern(" P ").pattern("XFX").pattern("C#C").define(Character.valueOf('P'), (ItemLike)this.itemFromName("minecraft:piston")).define(Character.valueOf('F'), ItemTags.WOODEN_FENCES).define(Character.valueOf('C'), (ItemLike)this.itemFromName("stevescarts:component_cleaning_fan")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_blank_upgrade")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:upgrade_cotwo_friendly"), "upgrade"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_advanced_crafter")).pattern(" D ").pattern(" # ").pattern("XCX").define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_advanced_pcb")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).define(Character.valueOf('D'), (ItemLike)this.itemFromName("minecraft:diamond")).define(Character.valueOf('C'), (ItemLike)this.itemFromName("stevescarts:module_crafter")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_advanced_crafter"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:blockcargomanager"), 1).pattern("X#X").pattern("#R#").pattern("X#X").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_large_iron_pane")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_huge_iron_pane")).define(Character.valueOf('R'), (ItemLike)this.itemFromName("stevescarts:component_large_dynamic_pane")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:blockcargomanager"), "block"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_sctank_pane"), 32).pattern("###").pattern("X#X").pattern("###").define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:glass_pane")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:glass")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_sctank_pane"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_large_chest_pane")).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_chest_pane")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_large_chest_pane"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_yellow_gift_ribbon")).pattern("###").pattern("#X#").pattern("###").define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:string")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:yellow_dye")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_yellow_gift_ribbon"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_solar_panel_component")).pattern("#R").pattern("X#").define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:glowstone_dust")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).define(Character.valueOf('R'), (ItemLike)this.itemFromName("minecraft:redstone")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_solar_panel_component"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_shooter")).pattern("PPP").pattern("PSP").pattern("PPP").define(Character.valueOf('S'), (ItemLike)this.itemFromName("stevescarts:component_shooting_station")).define(Character.valueOf('P'), (ItemLike)this.itemFromName("stevescarts:component_pipe")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_shooter"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:blockliquidmanager"), 1).pattern("X#X").pattern("# #").pattern("X#X").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:module_advanced_sctank")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:blockliquidmanager"), "block"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_red_pigment")).pattern(" # ").pattern("XXX").pattern(" # ").define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:red_dye")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:glowstone_dust")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_red_pigment"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_internal_sctank")).pattern("XXX").pattern("X#X").pattern("XXX").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_sctank_pane")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_sctank_valve")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_internal_sctank"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("minecraft:stick"), 2).pattern("X").define(Character.valueOf('X'), Ingredient.of((ItemLike[])new ItemLike[]{this.itemFromName("stevescarts:component_oak_twig"), this.itemFromName("stevescarts:component_spruce_twig"), this.itemFromName("stevescarts:component_birch_twig"), this.itemFromName("stevescarts:component_jungle_twig")})).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"stevescarts", (String)"component/stick")));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_iron_pane"), 8).pattern("###").pattern("#X#").pattern("###").define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_chest_pane")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_iron_pane"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_entity_scanner")).pattern("GXG").pattern("#L#").pattern("# #").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:redstone")).define(Character.valueOf('G'), (ItemLike)this.itemFromName("minecraft:gold_ingot")).define(Character.valueOf('L'), (ItemLike)this.itemFromName("stevescarts:component_advanced_pcb")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_entity_scanner"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:enhanced_galgadorian_metal"), 1).pattern("XXX").pattern("XXX").pattern("XXX").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_enhanced_galgadorian_metal")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:enhanced_galgadorian_metal"), "block"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:blockactivator"), 1).pattern("OGB").pattern("#I#").pattern("RXR").define(Character.valueOf('O'), (ItemLike)this.itemFromName("minecraft:orange_dye")).define(Character.valueOf('B'), (ItemLike)this.itemFromName("minecraft:blue_dye")).define(Character.valueOf('#'), ItemTags.STONE_CRAFTING_MATERIALS).define(Character.valueOf('I'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).define(Character.valueOf('G'), (ItemLike)this.itemFromName("minecraft:gold_ingot")).define(Character.valueOf('R'), (ItemLike)this.itemFromName("minecraft:redstone")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_advanced_pcb")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:blockactivator"), "block"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:upgrade_quick_demolisher")).pattern("OXO").pattern("XIX").pattern("O#O").define(Character.valueOf('I'), (ItemLike)this.itemFromName("minecraft:iron_block")).define(Character.valueOf('O'), (ItemLike)this.itemFromName("minecraft:obsidian")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_reinforced_metal")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_blank_upgrade")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:upgrade_quick_demolisher"), "upgrade"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_standard_hull")).pattern(" # ").pattern("X X").define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:minecart")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_iron_wheels")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_standard_hull"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_freezer")).pattern("#X#").pattern("XPX").pattern("#X#").define(Character.valueOf('P'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:snow")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:water_bucket")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_freezer"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_chest_pane"), 32).pattern("###").pattern("X#X").pattern("###").define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('X'), ItemTags.LOGS).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_chest_pane"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:upgrade_solar_panel")).pattern("XXX").pattern("DRD").pattern("R#R").define(Character.valueOf('D'), (ItemLike)this.itemFromName("minecraft:diamond")).define(Character.valueOf('R'), (ItemLike)this.itemFromName("minecraft:redstone")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_solar_panel_component")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_blank_upgrade")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:upgrade_solar_panel"), "upgrade"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_brake_handle")).pattern("  R").pattern("#S ").pattern("X# ").define(Character.valueOf('R'), (ItemLike)this.itemFromName("minecraft:red_dye")).define(Character.valueOf('S'), (ItemLike)this.itemFromName("stevescarts:component_refined_handle")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:redstone")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_brake_handle"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:upgrade_redstone_control")).pattern("PXP").pattern("TLT").pattern("R#R").define(Character.valueOf('T'), (ItemLike)this.itemFromName("minecraft:redstone_torch")).define(Character.valueOf('R'), (ItemLike)this.itemFromName("minecraft:redstone")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:repeater")).define(Character.valueOf('L'), (ItemLike)this.itemFromName("stevescarts:component_advanced_pcb")).define(Character.valueOf('P'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_blank_upgrade")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:upgrade_redstone_control"), "upgrade"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_sctank_valve"), 8).pattern(" X ").pattern("X#X").pattern(" X ").define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:iron_bars")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_sctank_valve"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_firework_display")).pattern("#D#").pattern("CFC").pattern("XSX").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).define(Character.valueOf('F'), (ItemLike)this.itemFromName("stevescarts:component_fuse")).define(Character.valueOf('#'), ItemTags.WOODEN_FENCES).define(Character.valueOf('D'), (ItemLike)this.itemFromName("minecraft:dispenser")).define(Character.valueOf('S'), (ItemLike)this.itemFromName("minecraft:flint_and_steel")).define(Character.valueOf('C'), (ItemLike)this.itemFromName("minecraft:crafting_table")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_firework_display"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_basic_wood_cutter")).pattern("###").pattern("#I#").pattern(" X ").define(Character.valueOf('I'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_wood_cutting_core")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_saw_blade")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_basic_wood_cutter"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_huge_sctank_pane")).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_sctank_pane")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_huge_sctank_pane"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:upgrade_entropy")).pattern("GX ").pattern("DLD").pattern(" #G").define(Character.valueOf('D'), (ItemLike)this.itemFromName("minecraft:diamond")).define(Character.valueOf('L'), (ItemLike)this.itemFromName("minecraft:lapis_block")).define(Character.valueOf('G'), (ItemLike)this.itemFromName("stevescarts:component_eye_of_galgador")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_reinforced_metal")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:upgrade_quick_demolisher")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:upgrade_entropy"), "upgrade"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_entity_detector_monster")).pattern("#").pattern("X").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_empty_disk")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:slime_ball")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_entity_detector_monster"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_galgadorian_drill")).pattern("#X ").pattern("BDX").pattern("#X ").define(Character.valueOf('D'), (ItemLike)this.itemFromName("stevescarts:module_hardened_drill")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_galgadorian_metal")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_enhanced_galgadorian_metal")).define(Character.valueOf('B'), (ItemLike)this.itemFromName("minecraft:diamond_block")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_galgadorian_drill"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_pumpkin_chariot")).pattern("# #").pattern("#P#").pattern("X X").define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_wooden_wheels")).define(Character.valueOf('P'), (ItemLike)this.itemFromName("minecraft:pumpkin")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_pumpkin_chariot"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_galgadorian_saw_blade")).pattern("##X").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_galgadorian_metal")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_galgadorian_saw_blade"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_cleaning_tube"), 2).pattern("#X#").pattern("#X#").pattern("#X#").define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:orange_dye")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_cleaning_tube"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_glass_o_magic")).pattern("X#X").pattern("XRX").pattern("XXX").define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:glass_pane")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:fermented_spider_eye")).define(Character.valueOf('R'), (ItemLike)this.itemFromName("minecraft:redstone")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_glass_o_magic"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_wood_cutting_core")).pattern("XXX").pattern("X#X").pattern("XXX").define(Character.valueOf('X'), ItemTags.SAPLINGS).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_advanced_pcb")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_wood_cutting_core"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_standard_hull")).pattern("# #").pattern("###").pattern("X X").define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_iron_wheels")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_standard_hull"), "module_alt"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_explosive_easter_egg")).pattern("###").pattern("#X#").pattern("#G#").define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:egg")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:gunpowder")).define(Character.valueOf('G'), (ItemLike)this.itemFromName("minecraft:green_dye")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_explosive_easter_egg"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_dynamite")).pattern("#").pattern("X").pattern("X").define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:gunpowder")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_fuse")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_dynamite"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).pattern("X#X").pattern("#G#").pattern("X#X").define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).define(Character.valueOf('G'), (ItemLike)this.itemFromName("minecraft:gold_ingot")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:redstone")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_simple_pcb"), "component_alt"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_iron_wheels")).pattern(" X ").pattern("X#X").pattern(" X ").define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:stick")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_iron_wheels"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_wooden_wheels")).pattern("XXX").pattern("X#X").pattern("XXX").define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:stick")).define(Character.valueOf('#'), ItemTags.PLANKS).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_wooden_wheels"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_liquid_sensors")).pattern("R R").pattern("LDW").pattern("#X#").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_advanced_pcb")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).define(Character.valueOf('R'), (ItemLike)this.itemFromName("minecraft:redstone")).define(Character.valueOf('L'), (ItemLike)this.itemFromName("minecraft:lava_bucket")).define(Character.valueOf('W'), (ItemLike)this.itemFromName("minecraft:water_bucket")).define(Character.valueOf('D'), (ItemLike)this.itemFromName("minecraft:diamond")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_liquid_sensors"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_blue_pigment")).pattern(" # ").pattern("XXX").pattern(" # ").define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:blue_dye")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:glowstone_dust")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_blue_pigment"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_basic_drill")).pattern("#X ").pattern(" #X").pattern("#X ").define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:diamond")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_basic_drill"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_fertilizer")).pattern("F F").pattern("#X#").pattern("XPX").define(Character.valueOf('P'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:leather")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:glass_bottle")).define(Character.valueOf('F'), (ItemLike)this.itemFromName("minecraft:bone_meal")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_fertilizer"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_front_chest")).pattern("X#X").pattern("XCX").pattern("###").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_chest_pane")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_large_chest_pane")).define(Character.valueOf('C'), (ItemLike)this.itemFromName("stevescarts:component_chest_lock")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_front_chest"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:upgrade_manager_bridge")).pattern("IPI").pattern("XDX").pattern("I#I").define(Character.valueOf('I'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).define(Character.valueOf('P'), (ItemLike)this.itemFromName("minecraft:ender_pearl")).define(Character.valueOf('D'), (ItemLike)this.itemFromName("stevescarts:blockdistributor")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_blank_upgrade")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:upgrade_manager_bridge"), "upgrade"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_sock")).pattern("##X").pattern("##B").pattern("###").define(Character.valueOf('B'), (ItemLike)this.itemFromName("minecraft:milk_bucket")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:cookie")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:red_wool")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_sock"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:upgrade_cart_crane")).pattern("XRX").pattern("PIP").pattern(" # ").define(Character.valueOf('I'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).define(Character.valueOf('R'), (ItemLike)this.itemFromName("minecraft:rail")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:piston")).define(Character.valueOf('P'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_blank_upgrade")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:upgrade_cart_crane"), "upgrade"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_reinforced_metal"), 9).pattern("X").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:reinforced_metal")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_reinforced_metal"), "block"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_hardened_wood_cutter")).pattern("###").pattern("#I#").pattern(" X ").define(Character.valueOf('I'), (ItemLike)this.itemFromName("minecraft:diamond")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_wood_cutting_core")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_hardened_saw_blade")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_hardened_wood_cutter"), "module_alt"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_dynamic_pane")).pattern("X").pattern("#").define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_iron_pane")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:redstone")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_dynamic_pane"), "component_alt"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_hardened_drill")).pattern("#X ").pattern("BDX").pattern("#X ").define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_hardened_mesh")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_reinforced_metal")).define(Character.valueOf('B'), (ItemLike)this.itemFromName("minecraft:diamond_block")).define(Character.valueOf('D'), (ItemLike)this.itemFromName("stevescarts:module_basic_drill")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_hardened_drill"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_large_sctank_pane")).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_sctank_pane")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_large_sctank_pane"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_advanced_smelter")).pattern(" D ").pattern(" # ").pattern("XCX").define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_advanced_pcb")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).define(Character.valueOf('D'), (ItemLike)this.itemFromName("minecraft:diamond")).define(Character.valueOf('C'), (ItemLike)this.itemFromName("stevescarts:module_smelter")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_advanced_smelter"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_basket")).pattern("XXX").pattern("X X").pattern("###").define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:stick")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_basket"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:upgrade_production_line")).pattern(" X ").pattern("LRL").pattern("I#I").define(Character.valueOf('R'), (ItemLike)this.itemFromName("minecraft:redstone")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).define(Character.valueOf('I'), (ItemLike)this.itemFromName("stevescarts:component_reinforced_metal")).define(Character.valueOf('L'), (ItemLike)this.itemFromName("stevescarts:component_advanced_pcb")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_blank_upgrade")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:upgrade_production_line"), "upgrade"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_blank_upgrade"), 2).pattern("XXX").pattern("#R#").pattern("XLX").define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).define(Character.valueOf('R'), (ItemLike)this.itemFromName("minecraft:redstone")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_reinforced_metal")).define(Character.valueOf('L'), (ItemLike)this.itemFromName("stevescarts:component_advanced_pcb")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_blank_upgrade"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:upgrade_new_era")).pattern("XBX").pattern("XLX").pattern("X#X").define(Character.valueOf('B'), (ItemLike)this.itemFromName("minecraft:enchanted_book")).define(Character.valueOf('L'), (ItemLike)this.itemFromName("stevescarts:component_advanced_pcb")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_galgadorian_metal")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:upgrade_experienced_assembler")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:upgrade_new_era"), "upgrade"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_basic_solar_engine")).pattern("#I#").pattern("IXI").pattern(" P ").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_solar_panel_component")).define(Character.valueOf('P'), (ItemLike)this.itemFromName("minecraft:piston")).define(Character.valueOf('I'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_basic_solar_engine"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_extreme_melter")).pattern("O#O").pattern("MXM").pattern("O#O").define(Character.valueOf('O'), (ItemLike)this.itemFromName("minecraft:bricks")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:obsidian")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:lava_bucket")).define(Character.valueOf('M'), (ItemLike)this.itemFromName("stevescarts:component_chest_lock")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_extreme_melter"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_open_sctank")).pattern("X X").pattern("XCX").pattern("###").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_sctank_pane")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_huge_sctank_pane")).define(Character.valueOf('C'), (ItemLike)this.itemFromName("stevescarts:component_sctank_valve")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_open_sctank"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_lawn_mower")).pattern("X X").pattern(" # ").pattern("X X").define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_blade_arm")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_lawn_mower"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_internal_storage")).pattern("XXX").pattern("X#X").pattern("XXX").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_chest_pane")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_chest_lock")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_internal_storage"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_galgadorian_hull")).pattern("# #").pattern("###").pattern("X X").define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_galgadorian_metal")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_galgadorian_wheels")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_galgadorian_hull"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_advanced_solar_panel")).pattern("#X#").pattern(" P ").pattern("#X#").define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_solar_panel_component")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).define(Character.valueOf('P'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_advanced_solar_panel"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_advanced_solar_panel")).pattern("# #").pattern("XPX").pattern("# #").define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_solar_panel_component")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).define(Character.valueOf('P'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_advanced_solar_panel"), "component_alt"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_planter_range_extender")).pattern("R#R").pattern(" S ").pattern("XSX").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_advanced_pcb")).define(Character.valueOf('S'), ItemTags.SAPLINGS).define(Character.valueOf('R'), (ItemLike)this.itemFromName("minecraft:redstone")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_planter_range_extender"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:upgrade_cart_modifier")).pattern("I I").pattern("PAP").pattern("I#I").define(Character.valueOf('I'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).define(Character.valueOf('A'), (ItemLike)this.itemFromName("minecraft:anvil")).define(Character.valueOf('P'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_blank_upgrade")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:upgrade_cart_modifier"), "upgrade"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_large_iron_pane")).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_iron_pane")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_large_iron_pane"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:upgrade_industrial_espionage")).pattern("SRS").pattern("GRG").pattern("R#R").define(Character.valueOf('S'), (ItemLike)this.itemFromName("minecraft:bookshelf")).define(Character.valueOf('R'), (ItemLike)this.itemFromName("stevescarts:component_reinforced_metal")).define(Character.valueOf('G'), (ItemLike)this.itemFromName("stevescarts:component_eye_of_galgador")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:upgrade_module_knowledge")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:upgrade_industrial_espionage"), "upgrade"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_raw_handle")).pattern("  X").pattern(" X ").pattern("X  ").define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_raw_handle"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_cleaning_machine")).pattern("#X#").pattern("# #").pattern("# #").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_cleaning_core")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_cleaning_tube")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_cleaning_machine"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_cage")).pattern("###").pattern("#X#").pattern("###").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_simple_pcb")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:oak_fence")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_cage"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:component_lump_of_galgador"), 2).pattern("#D#").pattern("X#X").pattern("RXR").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_eye_of_galgador")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:glowstone_dust")).define(Character.valueOf('D'), (ItemLike)this.itemFromName("minecraft:diamond")).define(Character.valueOf('R'), (ItemLike)this.itemFromName("stevescarts:component_stabilized_metal")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:component_lump_of_galgador"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_incinerator")).pattern("OOO").pattern("#X#").pattern("OOO").define(Character.valueOf('O'), (ItemLike)this.itemFromName("minecraft:nether_bricks")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:obsidian")).define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:furnace")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_incinerator"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_iron_drill")).pattern("XX ").pattern(" XX").pattern("XX ").define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:iron_ingot")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_iron_drill"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_seat")).pattern(" #").pattern(" #").pattern("X#").define(Character.valueOf('X'), ItemTags.WOODEN_SLABS).define(Character.valueOf('#'), ItemTags.PLANKS).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_seat"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("minecraft:jungle_planks"), 2).pattern("X").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_jungle_log")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("minecraft:jungle_planks"), "component"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_dynamite_carrier")).pattern(" # ").pattern("#X#").pattern(" # ").define(Character.valueOf('X'), (ItemLike)this.itemFromName("minecraft:flint_and_steel")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("stevescarts:component_dynamite")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_dynamite_carrier"), "module"));
        this.shaped(RecipeCategory.MISC, (ItemLike)this.itemFromName("stevescarts:module_crop_nether_wart")).pattern("#").pattern("X").define(Character.valueOf('X'), (ItemLike)this.itemFromName("stevescarts:component_empty_disk")).define(Character.valueOf('#'), (ItemLike)this.itemFromName("minecraft:nether_wart")).group("stevescarts").unlockedBy("has_item", this.has(Tags.Items.INGOTS_IRON)).save(this.output, this.recipeFolder((ItemLike)this.itemFromName("stevescarts:module_crop_nether_wart"), "module"));
    }

    public static class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput p_365442_, CompletableFuture<HolderLookup.Provider> p_362168_) {
            super(p_365442_, p_362168_);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider p_364945_, RecipeOutput p_362956_) {
            return new GeneratorRecipes(p_364945_, p_362956_);
        }

        public String getName() {
            return "Steves Carts Recipes";
        }
    }
}

