/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.init.ModEntities;

public class EntityCake
extends ThrownEgg {
    public EntityCake(Level world) {
        super((EntityType)ModEntities.CAKE.get(), world);
    }

    public EntityCake(Level world, LivingEntity thrower, ItemStack stack) {
        super(world, thrower, stack);
    }

    public EntityCake(Level world, double x, double y, double z, ItemStack stack) {
        super(world, x, y, z, stack);
    }

    public EntityCake(EntityType<EntityCake> entityCakeEntityType, Level world) {
        super(entityCakeEntityType, world);
    }

    protected void onHitEntity(EntityHitResult data) {
        Entity entity;
        if (data.getEntity() != null && (entity = data.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            player.getFoodData().eat(14, 0.7f);
        }
        if ((entity = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)entity;
            this.kill(serverLevel);
        }
    }

    protected void onHitBlock(@NotNull BlockHitResult blockHitResult) {
        BlockPos pos = this.blockPosition();
        if (this.level().getBlockState(pos).isAir() && Blocks.CAKE.defaultBlockState().canSurvive((LevelReader)this.level(), pos)) {
            this.level().setBlock(pos, Blocks.CAKE.defaultBlockState(), 3);
        }
        for (int j = 0; j < 8; ++j) {
            this.level().addParticle((ParticleOptions)ParticleTypes.ITEM_SNOWBALL, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.kill(serverLevel);
        }
    }
}

