/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.entities;

import java.lang.reflect.Constructor;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vswe.stevescarts.StevesCarts;
import vswe.stevescarts.api.StevesCartsAPI;
import vswe.stevescarts.api.client.ModelCartbase;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.modules.data.ModuleData;
import vswe.stevescarts.api.modules.interfaces.IActivatorModule;
import vswe.stevescarts.api.modules.template.ModuleEngine;
import vswe.stevescarts.api.modules.template.ModuleWorker;
import vswe.stevescarts.blocks.tileentities.TileEntityCartAssembler;
import vswe.stevescarts.containers.ContainerMinecart;
import vswe.stevescarts.entities.ModularMinecart;
import vswe.stevescarts.helpers.ActivatorOption;
import vswe.stevescarts.helpers.ForceChunkHelper;
import vswe.stevescarts.helpers.GuiAllocationHelper;
import vswe.stevescarts.helpers.ModuleCountPair;
import vswe.stevescarts.helpers.storages.TransferHandler;
import vswe.stevescarts.modules.addons.ModuleCreativeSupplies;
import vswe.stevescarts.modules.storages.tanks.ModuleTank;
import vswe.stevescarts.modules.workers.CompWorkModule;

public interface IModularCart
extends Container,
IFluidHandler {
    public ModularMinecart getCart();

    @Deprecated
    default public int x() {
        return (int)Math.floor(this.getCart().position().x);
    }

    @Deprecated
    default public int y() {
        return (int)Math.floor(this.getCart().position().y);
    }

    @Deprecated
    default public int z() {
        return (int)Math.floor(this.getCart().position().z);
    }

    public ArrayList<ModuleBase> modules();

    public ArrayList<ModuleWorker> workers();

    public ArrayList<ModuleEngine> engines();

    public ArrayList<ModuleTank> moduleTanks();

    public ArrayList<ModuleCountPair> moduleCounts();

    public boolean isPlaceholder();

    public void setPlaceholder(TileEntityCartAssembler var1);

    default public boolean dropOnDeath() {
        return !this.isPlaceholder() && this.modules().stream().allMatch(ModuleBase::dropOnDeath);
    }

    default public float[] getColor() {
        for (ModuleBase module : this.modules()) {
            float[] color = module.getColor();
            if (color[0] == 1.0f && color[1] == 1.0f && color[2] == 1.0f) continue;
            return color;
        }
        return new float[]{1.0f, 1.0f, 1.0f};
    }

    default public int getYTarget() {
        for (ModuleBase module : this.modules()) {
            int yTarget = module.getYTarget();
            if (yTarget == Integer.MIN_VALUE) continue;
            return yTarget;
        }
        return this.y();
    }

    default public ModuleBase getInterfaceThief() {
        return this.modules().stream().filter(ModuleBase::doStealInterface).findFirst().orElse(null);
    }

    default public double getPushFactor() {
        for (ModuleBase module : this.modules()) {
            double factor = module.getPushFactor();
            if (!(factor >= 0.0)) continue;
            return factor;
        }
        return 0.05;
    }

    default public boolean hasFuel() {
        if (this.getCart().isDisabled()) {
            return false;
        }
        for (ModuleBase module : this.modules()) {
            if (!module.stopEngines()) continue;
            return false;
        }
        return this.hasFuelForModule();
    }

    default public boolean hasFuelForModule() {
        if (this.isPlaceholder()) {
            return true;
        }
        int consumption = this.getConsumption(true);
        for (ModuleBase module : this.modules()) {
            if (!module.hasFuel(consumption)) continue;
            return true;
        }
        return false;
    }

    default public int getConsumption() {
        return this.getConsumption(!this.getCart().isDisabled() && this.getCart().isEngineBurning());
    }

    default public int getConsumption(boolean isMoving) {
        int consumption;
        int n = consumption = isMoving ? 1 : 0;
        if (!this.isPlaceholder()) {
            for (ModuleBase module : this.modules()) {
                consumption += module.getConsumption(isMoving);
            }
        }
        return consumption;
    }

    private ModuleEngine getCurrentEngine() {
        for (ModuleBase module : this.modules()) {
            if (!module.stopEngines()) continue;
            return null;
        }
        int consumption = this.getConsumption(true);
        ArrayList<ModuleEngine> priority = new ArrayList<ModuleEngine>();
        int mostImportant = -1;
        for (ModuleEngine engine : this.engines()) {
            if (!engine.hasFuel(consumption) || mostImportant != -1 && mostImportant < engine.getPriority()) continue;
            if (engine.getPriority() < mostImportant) {
                priority.clear();
            }
            mostImportant = engine.getPriority();
            priority.add(engine);
        }
        if (!priority.isEmpty()) {
            if (this.getCart().motorRotation >= priority.size()) {
                this.getCart().motorRotation = 0;
            }
            this.getCart().motorRotation = (this.getCart().motorRotation + 1) % priority.size();
            return (ModuleEngine)priority.get(this.getCart().motorRotation);
        }
        return null;
    }

    default public ArrayList<Component> getLabel() {
        ArrayList<Component> label = new ArrayList<Component>();
        for (ModuleBase module : this.modules()) {
            module.addToLabel(label);
        }
        return label;
    }

    default public boolean hasCreativeSupplies() {
        return this.getCart().hasCreativeSupplies;
    }

    default public TileEntityCartAssembler getPlaceholderAsssembler() {
        return this.getCart().placeholderAsssembler;
    }

    default public BlockPos getDisabledPos() {
        return this.getCart().disabledPos;
    }

    default public void onCartUpdate() {
        this.updateFuel();
        for (ModuleBase module : this.modules()) {
            module.update();
        }
        for (ModuleBase module : this.modules()) {
            module.postUpdate();
        }
        this.work();
        if (this.isPlaceholder() && this.getCart().keepAlive++ > 20) {
            this.getCart().remove(Entity.RemovalReason.KILLED);
            this.getCart().placeholderAsssembler.resetPlaceholder();
        }
    }

    default public void updateFuel() {
        ModuleEngine engine;
        int consumption;
        if (!this.getCart().level().isClientSide()) {
            this.getCart().setEngineBurning(this.hasFuel() && !this.getCart().isDisabled());
        }
        if ((consumption = this.getConsumption()) > 0 && (engine = this.getCurrentEngine()) != null) {
            engine.consumeFuel(consumption);
            if (!this.isPlaceholder() && this.getCart().level().isClientSide && this.getCart().isEngineBurning()) {
                engine.smoke();
            }
        }
    }

    default public void handleActivator(ActivatorOption option, boolean isOrange) {
        for (ModuleBase module : this.modules()) {
            if (!(module instanceof IActivatorModule)) continue;
            IActivatorModule activator = (IActivatorModule)((Object)module);
            if (!option.getModule().isAssignableFrom(module.getClass())) continue;
            if (option.shouldActivate(isOrange)) {
                activator.doActivate(option.getId());
                continue;
            }
            if (option.shouldDeactivate(isOrange)) {
                activator.doDeActivate(option.getId());
                continue;
            }
            if (!option.shouldToggle()) continue;
            if (activator.isActive(option.getId())) {
                activator.doDeActivate(option.getId());
                continue;
            }
            activator.doActivate(option.getId());
        }
    }

    default public RailShape getRailDirection(BlockPos pos) {
        ModuleBase module;
        ModuleBase.RAILDIRECTION dir = ModuleBase.RAILDIRECTION.DEFAULT;
        Iterator<ModuleBase> iterator = this.modules().iterator();
        while (iterator.hasNext() && (dir = (module = iterator.next()).getSpecialRailDirection(pos)) == ModuleBase.RAILDIRECTION.DEFAULT) {
        }
        if (dir == ModuleBase.RAILDIRECTION.DEFAULT) {
            return null;
        }
        int Yaw = (int)(this.getCart().getYRot() % 180.0f);
        if (Yaw < 0) {
            Yaw += 180;
        }
        boolean flag = Yaw >= 45 && Yaw <= 135;
        Vec3 motion = this.getCart().getDeltaMovement();
        if (this.getCart().fixedRailDirection == null) {
            switch (dir) {
                case FORWARD: {
                    if (flag) {
                        this.getCart().fixedRailDirection = RailShape.NORTH_SOUTH;
                        break;
                    }
                    this.getCart().fixedRailDirection = RailShape.EAST_WEST;
                    break;
                }
                case LEFT: {
                    if (flag) {
                        if (motion.z > 0.0) {
                            this.getCart().fixedRailDirection = RailShape.NORTH_EAST;
                            break;
                        }
                        if (!(motion.z <= 0.0)) break;
                        this.getCart().fixedRailDirection = RailShape.SOUTH_WEST;
                        break;
                    }
                    if (motion.x > 0.0) {
                        this.getCart().fixedRailDirection = RailShape.NORTH_WEST;
                        break;
                    }
                    if (!(motion.x < 0.0)) break;
                    this.getCart().fixedRailDirection = RailShape.SOUTH_EAST;
                    break;
                }
                case RIGHT: {
                    if (flag) {
                        if (motion.z > 0.0) {
                            this.getCart().fixedRailDirection = RailShape.NORTH_WEST;
                            break;
                        }
                        if (!(motion.z <= 0.0)) break;
                        this.getCart().fixedRailDirection = RailShape.SOUTH_EAST;
                        break;
                    }
                    if (motion.x > 0.0) {
                        this.getCart().fixedRailDirection = RailShape.SOUTH_WEST;
                        break;
                    }
                    if (!(motion.x < 0.0)) break;
                    this.getCart().fixedRailDirection = RailShape.NORTH_EAST;
                    break;
                }
                case NORTH: {
                    if (flag) {
                        if (!(motion.z > 0.0)) break;
                        this.getCart().fixedRailDirection = RailShape.NORTH_SOUTH;
                        break;
                    }
                    if (motion.x > 0.0) {
                        this.getCart().fixedRailDirection = RailShape.SOUTH_WEST;
                        break;
                    }
                    if (!(motion.x < 0.0)) break;
                    this.getCart().fixedRailDirection = RailShape.SOUTH_EAST;
                    break;
                }
            }
            if (this.getCart().fixedRailDirection == null) {
                return null;
            }
            this.getCart().fixedRailPos = new BlockPos((Vec3i)pos);
        }
        return this.getCart().fixedRailDirection;
    }

    private void work() {
        if (this.isPlaceholder()) {
            return;
        }
        if (!this.getCart().level().isClientSide && this.hasFuel()) {
            if (this.getCart().workingTime <= 0) {
                ModuleWorker oldComponent = this.getCart().workingComponent;
                if (this.getCart().workingComponent != null) {
                    boolean result = this.getCart().workingComponent.work();
                    if (this.getCart().workingComponent != null && oldComponent == this.getCart().workingComponent && this.getCart().workingTime <= 0 && !this.getCart().workingComponent.preventAutoShutdown()) {
                        this.getCart().workingComponent.stopWorking();
                    }
                    if (result) {
                        this.work();
                        return;
                    }
                }
                for (ModuleWorker module : this.workers()) {
                    if (!module.work()) continue;
                    return;
                }
            } else {
                --this.getCart().workingTime;
            }
        }
    }

    public void setWorker(ModuleWorker var1);

    public ModuleWorker getWorker();

    public void setWorkingTime(int var1);

    default public void loadChunks() {
        this.updateTicket(true);
    }

    default public void initChunkLoading() {
        this.updateTicket(true);
    }

    default public void dropChunkLoading() {
        this.updateTicket(false);
    }

    default public void updateTicket(boolean loadingEnabled) {
        Level level = this.getCart().level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        ArrayList removed = new ArrayList();
        if (!loadingEnabled) {
            this.getCart().forcedChunks.forEach(pos -> {
                if (ForceChunkHelper.CONTROLLER.forceChunk(level2, (Entity)this.getCart(), pos.x, pos.z, false, true)) {
                    removed.add(pos);
                }
            });
            this.getCart().forcedChunks.removeAll(removed);
            return;
        }
        ArrayList<ChunkPos> forcedCopy = new ArrayList<ChunkPos>(this.getCart().forcedChunks);
        Stream loadArea = ChunkPos.rangeClosed((ChunkPos)this.getCart().chunkPosition(), (int)1);
        loadArea.forEach(pos -> {
            if (forcedCopy.contains(pos)) {
                forcedCopy.remove(pos);
            } else if (ForceChunkHelper.CONTROLLER.forceChunk(level2, (Entity)this.getCart(), pos.x, pos.z, true, true)) {
                this.getCart().forcedChunks.add((ChunkPos)pos);
            }
        });
        forcedCopy.forEach(pos -> {
            if (ForceChunkHelper.CONTROLLER.forceChunk(level2, (Entity)this.getCart(), pos.x, pos.z, false, true)) {
                removed.add(pos);
            }
        });
        this.getCart().forcedChunks.removeAll(removed);
    }

    default public void initModules() {
        this.moduleCounts().clear();
        for (ModuleBase module : this.modules()) {
            ModuleData data = StevesCartsAPI.MODULE_REGISTRY.get(module.getModuleId());
            boolean found = false;
            for (ModuleCountPair count : this.moduleCounts()) {
                if (!count.isContainingData(data)) continue;
                count.increase();
                found = true;
                break;
            }
            if (found) continue;
            this.moduleCounts().add(new ModuleCountPair(data));
        }
        for (ModuleBase module : this.modules()) {
            module.preInit();
        }
        this.workers().clear();
        this.engines().clear();
        this.moduleTanks().clear();
        int guidata = 0;
        int packets = 0;
        if (this.getCart().level().isClientSide) {
            this.generateModels();
        }
        block8: for (ModuleBase module2 : this.modules()) {
            ModuleBase moduleBase = module2;
            int count = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ModuleWorker.class, ModuleEngine.class, ModuleTank.class}, (Object)moduleBase, count)) {
                case 0: {
                    ModuleWorker moduleWorker = (ModuleWorker)moduleBase;
                    this.workers().add(moduleWorker);
                    continue block8;
                }
                case 1: {
                    ModuleEngine moduleEngine = (ModuleEngine)moduleBase;
                    this.engines().add(moduleEngine);
                    continue block8;
                }
                case 2: {
                    ModuleTank moduleTank = (ModuleTank)moduleBase;
                    this.moduleTanks().add(moduleTank);
                    continue block8;
                }
            }
            if (!(module2 instanceof ModuleCreativeSupplies)) continue;
            this.getCart().hasCreativeSupplies = true;
        }
        CompWorkModule sorter = new CompWorkModule();
        this.workers().sort(sorter);
        if (!this.isPlaceholder()) {
            ArrayList<GuiAllocationHelper> lines = new ArrayList<GuiAllocationHelper>();
            int slots = 0;
            for (ModuleBase module3 : this.modules()) {
                if (module3.hasGui()) {
                    boolean foundLine = false;
                    for (GuiAllocationHelper line : lines) {
                        if (line.width + module3.guiWidth() > 443) continue;
                        module3.setX(line.width);
                        line.width += module3.guiWidth();
                        line.maxHeight = Math.max(line.maxHeight, module3.guiHeight());
                        line.modules.add(module3);
                        foundLine = true;
                        break;
                    }
                    if (!foundLine) {
                        GuiAllocationHelper line2 = new GuiAllocationHelper();
                        module3.setX(0);
                        line2.width = module3.guiWidth();
                        line2.maxHeight = module3.guiHeight();
                        line2.modules.add(module3);
                        lines.add(line2);
                    }
                    module3.setGuiDataStart(guidata);
                    guidata += module3.numberOfGuiData();
                    if (module3.hasSlots()) {
                        slots = module3.generateSlots(slots);
                    }
                }
                module3.setPacketStart(packets);
                packets += module3.totalNumberOfPackets();
            }
            int currentY = 0;
            for (GuiAllocationHelper line3 : lines) {
                for (ModuleBase module4 : line3.modules) {
                    module4.setY(currentY);
                }
                currentY += line3.maxHeight;
            }
            if (currentY > 168) {
                this.getCart().canScrollModules = true;
            }
            this.getCart().modularSpaceHeight = currentY;
        }
        for (ModuleBase module5 : this.modules()) {
            module5.init();
        }
    }

    default public void loadPlaceHolderModules(List<ResourceLocation> data) {
        this.modules().clear();
        for (ResourceLocation moduleResourceLocation : data) {
            ModuleData moduleData = StevesCartsAPI.MODULE_REGISTRY.get(moduleResourceLocation);
            this.doLoadModules(moduleData, null);
        }
        this.initModules();
        this.getCart().moduleLoadingData = data;
    }

    default public void doLoadModules(ModuleData moduleData, @Nullable CompoundTag data) {
        if (moduleData == null) {
            return;
        }
        try {
            Class<? extends ModuleBase> moduleClass = moduleData.getModuleClass();
            Constructor<? extends ModuleBase> moduleConstructor = moduleClass.getConstructor(ModularMinecart.class);
            ModuleBase module = moduleConstructor.newInstance(this);
            module.setModuleId(moduleData.getID());
            this.modules().add(module);
        }
        catch (Exception e) {
            StevesCarts.LOGGER.error("Failed to load module with ID " + String.valueOf(moduleData.getID()) + "! More info below.");
            e.printStackTrace();
        }
    }

    default public void updateSimulationModules(List<ResourceLocation> data) {
        if (!this.isPlaceholder()) {
            StevesCarts.LOGGER.error("You're stupid! This is not a placeholder cart.");
        } else {
            this.loadPlaceHolderModules(data);
        }
    }

    default public void loadModulesFromNames(List<ResourceLocation> data) {
        this.modules().clear();
        if (data != null) {
            for (ResourceLocation name : data) {
                this.doLoadModules(StevesCartsAPI.MODULE_REGISTRY.get(name), null);
            }
        }
        this.initModules();
    }

    default public int getContainerSize() {
        int slotCount = 0;
        for (ModuleBase module : this.modules()) {
            slotCount += module.getInventorySize();
        }
        return slotCount;
    }

    default public boolean isEmpty() {
        return false;
    }

    @NotNull
    default public ItemStack getItem(int i) {
        for (ModuleBase module : this.modules()) {
            if (i < module.getInventorySize()) {
                return module.getStack(i);
            }
            i -= module.getInventorySize();
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    default public ItemStack removeItem(int i, int p_70298_2_) {
        if (!this.getItem(i).isEmpty()) {
            ItemStack var2 = this.getItem(i);
            this.setItem(i, ItemStack.EMPTY);
            return var2;
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    default public ItemStack removeItemNoUpdate(int i) {
        return ItemStack.EMPTY;
    }

    default public void setItem(int i, @NotNull ItemStack item) {
        for (ModuleBase module : this.modules()) {
            if (i < module.getInventorySize()) {
                module.setStack(i, item);
                break;
            }
            i -= module.getInventorySize();
        }
    }

    default public void setChanged() {
        for (ModuleBase module : this.modules()) {
            module.onInventoryChanged();
        }
    }

    default public boolean stillValid(Player player) {
        return true;
    }

    default public void addItemToChest(@Nonnull ItemStack iStack) {
        TransferHandler.TransferItem(iStack, (Container)this, this.getCon(null), Slot.class, null, -1);
    }

    default public void addItemToChest(@Nonnull ItemStack iStack, int start, int end) {
        TransferHandler.TransferItem(iStack, this, start, end, this.getCon(null), Slot.class, null, -1);
    }

    default public void addItemToChest(@Nonnull ItemStack iStack, Class validSlot, Class invalidSlot) {
        TransferHandler.TransferItem(iStack, (Container)this, this.getCon(null), validSlot, invalidSlot, -1);
    }

    default public AbstractContainerMenu getCon(Inventory playerInventory) {
        return new ContainerMinecart(0, playerInventory, this.getCart());
    }

    default public void clearContent() {
    }

    default public int getTanks() {
        return this.moduleTanks().size();
    }

    @Nonnull
    default public FluidStack getFluidInTank(int tank) {
        return this.moduleTanks().get(tank).getFluid();
    }

    default public int getTankCapacity(int tank) {
        return this.moduleTanks().get(tank).getCapacity();
    }

    default public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.moduleTanks().get(tank).isFluidValid(stack);
    }

    default public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int amount = 0;
        if (resource != null && resource.getAmount() > 0) {
            FluidStack fluid = resource.copy();
            for (int i = 0; i < this.moduleTanks().size(); ++i) {
                int tempAmount = this.moduleTanks().get(i).fill(fluid, action);
                amount += tempAmount;
                fluid.shrink(tempAmount);
                if (fluid.getAmount() <= 0) break;
            }
        }
        return amount;
    }

    default public FluidStack drain(FluidStack resource, int maxDrain, IFluidHandler.FluidAction doDrain) {
        FluidStack ret = resource;
        if (ret != null) {
            ret = ret.copy();
            ret.setAmount(0);
        }
        for (int i = 0; i < this.moduleTanks().size(); ++i) {
            FluidStack temp = null;
            temp = this.moduleTanks().get(i).drain(maxDrain, doDrain);
            if (temp == null || ret != null && !FluidStack.isSameFluidSameComponents((FluidStack)ret, (FluidStack)temp)) continue;
            if (ret == null) {
                ret = temp;
            } else {
                ret.grow(temp.getAmount());
            }
            if ((maxDrain -= temp.getAmount()) <= 0) break;
        }
        if (ret != null && ret.getAmount() == 0) {
            return null;
        }
        return ret;
    }

    default public int drain(Fluid type, int maxDrain, IFluidHandler.FluidAction doDrain) {
        int amount = 0;
        if (type != null && maxDrain > 0) {
            for (ModuleTank tank : this.moduleTanks()) {
                FluidStack drained = tank.drain(maxDrain, doDrain);
                if (drained.isEmpty() || !type.isSame(drained.getFluid())) continue;
                amount += drained.getAmount();
                maxDrain -= drained.getAmount();
                if (doDrain == IFluidHandler.FluidAction.EXECUTE) {
                    tank.drain(drained.getAmount(), doDrain);
                }
                if (maxDrain > 0) continue;
                break;
            }
        }
        return amount;
    }

    @Nonnull
    default public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.drain(resource, !resource.isEmpty() ? 0 : resource.getAmount(), action);
    }

    @Nonnull
    default public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.drain(maxDrain, action);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void generateModels() {
        ModuleData data;
        ArrayList<String> invalid = new ArrayList<String>();
        for (ModuleBase module : this.modules()) {
            data = module.getData();
            if (!data.haveRemovedModels()) continue;
            invalid.addAll(data.getRemovedModels());
        }
        for (int i = this.modules().size() - 1; i >= 0; --i) {
            ModuleBase module;
            module = this.modules().get(i);
            data = module.getData();
            if (data == null || !data.haveModels(this.isPlaceholder())) continue;
            ArrayList<ModelCartbase> models = new ArrayList<ModelCartbase>();
            for (String str : data.getModels(this.isPlaceholder()).keySet()) {
                if (invalid.contains(str)) continue;
                models.add(data.getModels(this.isPlaceholder()).get(str));
                invalid.add(str);
            }
            if (models.isEmpty()) continue;
            module.setModels(models);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void updateSounds() {
    }

    default public void setScrollY(int val) {
        if (this.getCart().canScrollModules) {
            this.getCart().scrollY = val;
        }
    }

    default public int getScrollY() {
        if (this.getInterfaceThief() != null) {
            return 0;
        }
        return this.getCart().scrollY;
    }

    default public int getRealScrollY() {
        return (int)((float)(this.getCart().modularSpaceHeight - 168) / 198.0f * (float)this.getScrollY());
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void renderOverlay(GuiGraphics render, float partialTicks) {
        for (ModuleBase module : this.modules()) {
            module.renderOverlay(render, partialTicks);
        }
    }
}

