/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.entities;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vswe.stevescarts.api.StevesCartsAPI;
import vswe.stevescarts.api.events.CartEvents;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.modules.data.ModuleData;
import vswe.stevescarts.api.modules.template.ModuleEngine;
import vswe.stevescarts.api.modules.template.ModuleWorker;
import vswe.stevescarts.blocks.tileentities.TileEntityCartAssembler;
import vswe.stevescarts.containers.ContainerMinecart;
import vswe.stevescarts.entities.IModularCart;
import vswe.stevescarts.entities.ModularMinecartBehavior;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ModuleCountPair;
import vswe.stevescarts.init.ModBlocks;
import vswe.stevescarts.init.ModEntities;
import vswe.stevescarts.modules.storages.tanks.ModuleTank;
import vswe.stevescarts.polylib.DataEntity;
import vswe.stevescarts.polylib.EntityData;

public class ModularMinecart
extends AbstractMinecart
implements IEntityWithComplexSpawn,
MenuProvider,
DataEntity,
IModularCart {
    public static final int MODULAR_SPACE_WIDTH = 443;
    public static final int MODULAR_SPACE_HEIGHT = 168;
    private static final EntityDataAccessor<Boolean> IS_BURNING = SynchedEntityData.defineId(ModularMinecart.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_DISANABLED = SynchedEntityData.defineId(ModularMinecart.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final ArrayList<ModuleCountPair> moduleCounts = new ArrayList();
    private final ArrayList<ModuleBase> modules = new ArrayList();
    private final ArrayList<ModuleWorker> workModules = new ArrayList();
    private final ArrayList<ModuleEngine> engineModules = new ArrayList();
    private final ArrayList<ModuleTank> tankModules = new ArrayList();
    private final List<EntityData<?>> entityDataList = new ArrayList();
    protected final List<ChunkPos> forcedChunks = new ArrayList<ChunkPos>();
    protected TileEntityCartAssembler placeholderAsssembler;
    protected List<ResourceLocation> moduleLoadingData;
    protected ModuleWorker workingComponent;
    protected boolean hasCreativeSupplies;
    protected boolean isPlaceholder;
    protected boolean wasDisabled;
    protected BlockPos disabledPos;
    protected boolean fullStop = false;
    protected int workingTime;
    protected int motorRotation;
    protected int keepAlive;
    private float rotationOffset;
    private float playerRotationOffset;
    protected Vec3 preStopVelocity = null;
    protected RailShape fixedRailDirection;
    protected BlockPos fixedRailPos;
    protected Component name;
    protected int scrollY;
    public boolean canScrollModules;
    public int modularSpaceHeight;
    public static final int[][][] railDirectionCoordinates = new int[][][]{new int[][]{{0, 0, -1}, {0, 0, 1}}, new int[][]{{-1, 0, 0}, {1, 0, 0}}, new int[][]{{-1, -1, 0}, {1, 0, 0}}, new int[][]{{-1, 0, 0}, {1, -1, 0}}, new int[][]{{0, 0, -1}, {0, -1, 1}}, new int[][]{{0, -1, -1}, {0, 0, 1}}, new int[][]{{0, 0, 1}, {1, 0, 0}}, new int[][]{{0, 0, 1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {1, 0, 0}}};

    public ModularMinecart(Level level, double x, double y, double z) {
        super((EntityType)ModEntities.MODULAR_CART.get(), level, x, y, z);
        this.behavior = new ModularMinecartBehavior(this);
    }

    protected ModularMinecart(Level level) {
        this((EntityType)ModEntities.MODULAR_CART.get(), level);
    }

    public ModularMinecart(Level world, TileEntityCartAssembler assembler, ArrayList<ResourceLocation> data) {
        this(world);
        this.setPlaceholder(assembler);
        this.loadPlaceHolderModules(data);
    }

    public ModularMinecart(Level world, double x, double y, double z, CompoundTag data) {
        this(world, x, y, z);
        this._oldLoadModules(data);
    }

    private void _oldLoadModules(CompoundTag info) {
        ArrayList<CompoundTag> modules = new ArrayList<CompoundTag>();
        if (info == null) {
            return;
        }
        ArrayList<ResourceLocation> names = new ArrayList<ResourceLocation>();
        ListTag listTag = (ListTag)info.get("modules");
        for (int i = 0; i < listTag.size(); ++i) {
            Tag tag = listTag.get(i);
            modules.add((CompoundTag)tag);
            names.add(ResourceLocation.parse((String)((CompoundTag)tag).getStringOr(String.valueOf(i), "")));
        }
        if (!names.isEmpty()) {
            this.getCart().moduleLoadingData = names;
        }
        this._oldLoadModules(modules);
    }

    private void _oldLoadModules(List<CompoundTag> data) {
        this.modules().clear();
        if (data != null) {
            for (int i = 0; i < data.size(); ++i) {
                CompoundTag tag = data.get(i);
                ResourceLocation name = ResourceLocation.parse((String)tag.getStringOr(String.valueOf(i), ""));
                this.doLoadModules(StevesCartsAPI.MODULE_REGISTRY.get(name), tag);
            }
        }
        this.initModules();
    }

    public ModularMinecart(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.behavior = new ModularMinecartBehavior(this);
    }

    public void tick() {
        if (!this.level().isClientSide) {
            this.entityDataList.forEach(EntityData::detectAndSend);
            if (this.isDisabled() && this.disabledPos != null) {
                if (!this.fullStop) {
                    double xOffset = (double)this.disabledPos.getX() + 0.5 - this.position().x;
                    double zOffset = (double)this.disabledPos.getZ() + 0.5 - this.position().z;
                    this.move(MoverType.SELF, new Vec3(xOffset * 0.25, 0.0, zOffset * 0.25));
                    if (xOffset < 0.05 && zOffset < 0.05) {
                        this.fullStop = true;
                    }
                }
            } else {
                this.fullStop = false;
            }
        }
        this.flipped = true;
        this.onCartUpdate();
        if (this.level().isClientSide) {
            this.updateSounds();
        }
        double lastYRot = this.getYRot();
        Vec3 lastPos = this.position();
        super.tick();
        if (this.level().isClientSide && lastPos.distanceTo(this.position()) > 0.01) {
            this.rotationOffset += (float)(((double)this.getYRot() - lastYRot) % 360.0);
            this.rotationOffset %= 360.0f;
        }
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_BURNING, (Object)false);
        builder.define(IS_DISANABLED, (Object)false);
    }

    public ItemStack getPickResult() {
        return this.getCartItem();
    }

    protected Item getDropItem() {
        return Items.AIR;
    }

    @Nonnull
    public ItemStack getCartItem() {
        return ModuleData.createModularCart(this);
    }

    public boolean canBeCollidedWith(@Nullable Entity entity) {
        return !this.isPlaceholder() && super.canBeCollidedWith(entity);
    }

    public boolean canRiderInteract() {
        return true;
    }

    public Entity getCartRider() {
        return this.getPassengers().isEmpty() ? null : (Entity)this.getPassengers().get(0);
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        return null;
    }

    protected void destroy(ServerLevel level, DamageSource damageSource) {
        this.kill(level);
        if (level.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS) && this.dropOnDeath()) {
            ItemStack itemstack = this.getCartItem();
            if (this.hasCustomName()) {
                itemstack.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
            }
            for (int i = 0; i < this.getContainerSize(); ++i) {
                ItemStack stack = this.getItem(i);
                if (stack.isEmpty()) continue;
                this.spawnAtLocation(level, stack);
            }
            this.spawnAtLocation(level, itemstack);
        }
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource dmg, float damage) {
        if (this.isPlaceholder()) {
            return false;
        }
        for (ModuleBase module : this.modules()) {
            if (module.receiveDamage(dmg, damage)) continue;
            return false;
        }
        return super.hurtServer(serverLevel, dmg, damage);
    }

    public void activateMinecart(int x, int y, int z, boolean active) {
        for (ModuleBase module : this.modules()) {
            module.activatedByRail(x, y, z, active);
        }
    }

    public boolean isDisabled() {
        return (Boolean)this.entityData.get(IS_DISANABLED);
    }

    public void setIsDisabled(boolean disabled) {
        this.entityData.set(IS_DISANABLED, (Object)disabled);
    }

    public boolean isEngineBurning() {
        return (Boolean)this.entityData.get(IS_BURNING);
    }

    public void setEngineBurning(boolean on) {
        this.entityData.set(IS_BURNING, (Object)on);
    }

    @NotNull
    public Component getDisplayName() {
        return Localization.translate("entity.minecraft.minecart", new Object[0]);
    }

    public Vec3 getEffectiveVelocity() {
        float rotation = this.behavior.getYRot();
        float pushRad = (rotation + 90.0f) * ((float)Math.PI / 180);
        float sin = org.joml.Math.sin((float)pushRad);
        float cos = org.joml.Math.cosFromSin((float)sin, (float)pushRad);
        return new Vec3((double)sin, 0.0, (double)cos);
    }

    protected Vec3 applyNaturalSlowdown(Vec3 initialVelocity) {
        if (this.isDisabled()) {
            if (initialVelocity.length() > 0.1) {
                initialVelocity = initialVelocity.multiply(0.0, 0.0, 0.0);
            }
            return super.applyNaturalSlowdown(initialVelocity.multiply(0.8, 0.8, 0.8));
        }
        if (this.isEngineBurning() && this.preStopVelocity == null) {
            double pushFactor = this.getPushFactor();
            Vec3 velocity = this.getEffectiveVelocity();
            initialVelocity = initialVelocity.multiply(0.8, 0.0, 0.8).add(velocity.multiply(pushFactor, 0.0, pushFactor));
            if (this.isInWater()) {
                initialVelocity = initialVelocity.scale(0.1);
            }
        }
        return super.applyNaturalSlowdown(initialVelocity);
    }

    public void handleMoveAlongTrack(BlockPos pos, BlockState state) {
        boolean forceUnDisable;
        for (ModuleBase module : this.modules()) {
            module.moveMinecartOnRail(pos, state);
        }
        if (state.getBlock() != ModBlocks.ADVANCED_DETECTOR.get() && this.isDisabled()) {
            this.releaseCart();
        }
        boolean canBeDisabled = state.getBlock() == ModBlocks.ADVANCED_DETECTOR.get();
        boolean bl = forceUnDisable = this.wasDisabled && this.disabledPos != null && this.disabledPos.equals((Object)pos);
        if (!forceUnDisable && this.wasDisabled) {
            this.wasDisabled = false;
        }
        boolean bl2 = canBeDisabled = !forceUnDisable && canBeDisabled;
        if (canBeDisabled && !this.isDisabled()) {
            this.preStopVelocity = this.getDeltaMovement().add(0.0);
            this.disabledPos = new BlockPos((Vec3i)pos);
            this.setIsDisabled(true);
        }
        if (this.fixedRailPos != null && !this.fixedRailPos.equals((Object)pos)) {
            this.fixedRailDirection = null;
            this.fixedRailPos = new BlockPos(this.fixedRailPos.getX(), -1, this.fixedRailPos.getZ());
        }
    }

    public void turnback() {
        this.behavior.setYRot((this.behavior.getYRot() + 180.0f) % 360.0f);
        this.setDeltaMovement(this.getDeltaMovement().multiply(-1.0, -1.0, -1.0));
    }

    public void releaseCart() {
        this.wasDisabled = true;
        this.setIsDisabled(false);
        this.behavior.setDeltaMovement(this.preStopVelocity);
        this.preStopVelocity = null;
    }

    protected void comeOffTrack(ServerLevel level) {
        super.comeOffTrack(level);
    }

    protected double getMaxSpeed(ServerLevel level) {
        return super.getMaxSpeed(level);
    }

    protected double makeStepAlongTrack(BlockPos pos, RailShape shape, double distance) {
        return super.makeStepAlongTrack(pos, shape, distance);
    }

    protected void moveAlongTrack(ServerLevel level) {
        super.moveAlongTrack(level);
    }

    @Override
    public ModularMinecart getCart() {
        return this;
    }

    @Override
    public ArrayList<ModuleBase> modules() {
        return this.modules;
    }

    @Override
    public ArrayList<ModuleWorker> workers() {
        return this.workModules;
    }

    @Override
    public ArrayList<ModuleEngine> engines() {
        return this.engineModules;
    }

    @Override
    public ArrayList<ModuleTank> moduleTanks() {
        return this.tankModules;
    }

    @Override
    public ArrayList<ModuleCountPair> moduleCounts() {
        return this.moduleCounts;
    }

    @Override
    public boolean isPlaceholder() {
        return this.isPlaceholder;
    }

    @Override
    public void setPlaceholder(TileEntityCartAssembler assembler) {
        this.isPlaceholder = true;
        this.placeholderAsssembler = assembler;
    }

    @Override
    public void setWorker(ModuleWorker worker) {
        if (this.workingComponent != null && worker != null) {
            this.workingComponent.stopWorking();
        }
        if ((this.workingComponent = worker) == null) {
            this.setWorkingTime(0);
        }
    }

    @Override
    public ModuleWorker getWorker() {
        return this.workingComponent;
    }

    @Override
    public void setWorkingTime(int val) {
        this.workingTime = val;
    }

    @NotNull
    public InteractionResult interactAt(@NotNull Player player, @NotNull Vec3 vec, @NotNull InteractionHand hand) {
        if (this.isPlaceholder()) {
            return InteractionResult.FAIL;
        }
        if (!player.isCrouching()) {
            boolean interupt = false;
            for (ModuleBase module : this.modules()) {
                if (!module.onInteractFirst(player)) continue;
                interupt = true;
            }
            if (interupt) {
                return InteractionResult.SUCCESS;
            }
        }
        if (player instanceof ServerPlayer) {
            player.openMenu((MenuProvider)this, packetBuffer -> packetBuffer.writeInt(this.getId()));
        }
        return InteractionResult.SUCCESS;
    }

    public void remove(@NotNull Entity.RemovalReason removalReason) {
        CartEvents.CartRemovedEvent event = new CartEvents.CartRemovedEvent(this);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        if (this.level().isClientSide) {
            for (int var1 = 0; var1 < this.getContainerSize(); ++var1) {
                this.setItem(var1, ItemStack.EMPTY);
            }
        }
        super.remove(removalReason);
        for (ModuleBase module : this.modules) {
            module.onDeath();
        }
        this.dropChunkLoading();
    }

    public void removeVehicle() {
        if (!this.level().isClientSide && !this.isRemoved()) {
            this.level().addFreshEntity((Entity)new ItemEntity(this.level(), (double)this.blockPosition().getX() + 0.5, (double)this.blockPosition().getY() + 0.5, (double)this.blockPosition().getZ() + 0.5, this.getCartItem()));
        }
        super.removeVehicle();
    }

    public void writeSpawnData(RegistryFriendlyByteBuf data) {
        if (this.moduleLoadingData == null) {
            data.writeByte(0);
            return;
        }
        data.writeByte(this.moduleLoadingData.size());
        for (ResourceLocation b : this.moduleLoadingData) {
            data.writeResourceLocation(b);
        }
        this.entityDataList.forEach(e -> e.toBytes(data));
        data.writeBoolean(this.isEngineBurning());
        data.writeBoolean(this.isDisabled());
    }

    public void readSpawnData(RegistryFriendlyByteBuf data) {
        int length = data.readByte();
        if (length == 0) {
            return;
        }
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        for (int i = 0; i < length; ++i) {
            list.add(data.readResourceLocation());
        }
        this.loadModulesFromNames(list);
        this.entityDataList.forEach(e -> e.fromBytes(data));
        this.setEngineBurning(data.readBoolean());
        this.setIsDisabled(data.readBoolean());
    }

    protected void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        if (this.name != null) {
            output.putString("cartName", this.name.getString());
        }
        output.putBoolean("engine_burning", this.isEngineBurning());
        output.putBoolean("disabled", this.isDisabled());
        output.putBoolean("stopped", this.preStopVelocity != null);
        if (this.preStopVelocity != null) {
            output.putDouble("preStopVelX", this.preStopVelocity.x());
            output.putDouble("preStopVelY", this.preStopVelocity.y());
            output.putDouble("preStopVelZ", this.preStopVelocity.z());
        }
        output.putShort("workingTime", (short)this.workingTime);
        if (this.disabledPos != null) {
            output.store("disabled_pos", BlockPos.CODEC, (Object)this.disabledPos);
        }
        ValueOutput list = output.child("modules");
        list.putInt("count", this.modules.size());
        for (int i = 0; i < this.modules.size(); ++i) {
            ModuleBase module = this.modules.get(i);
            list.putString(String.valueOf(i), this.modules.get(i).getModuleId().toString());
            module.writeToNBT(list, i);
        }
    }

    protected void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        this.name = Localization.translate(input.getStringOr("cartName", ""), new Object[0]);
        this.setEngineBurning(input.getBooleanOr("engine_burning", false));
        this.setIsDisabled(input.getBooleanOr("disabled", false));
        this.preStopVelocity = input.getBooleanOr("stopped", false) ? new Vec3(input.getDoubleOr("preStopVelX", 0.0), input.getDoubleOr("preStopVelY", 0.0), input.getDoubleOr("preStopVelZ", 0.0)) : null;
        this.workingTime = input.getShortOr("workingTime", (short)0);
        this.disabledPos = input.read("disabled_pos", BlockPos.CODEC).orElse(null);
        this.loadModules(input);
    }

    public void loadModules(ValueInput input) {
        ResourceLocation moduleName;
        ArrayList<ResourceLocation> names = new ArrayList<ResourceLocation>();
        ValueInput.ValueInputList migration = input.childrenListOrEmpty("modules");
        if (!migration.isEmpty()) {
            int i = 0;
            for (ValueInput in : migration) {
                String string = in.getStringOr(String.valueOf(i), "");
                if (string.isEmpty()) continue;
                moduleName = ResourceLocation.parse((String)string);
                names.add(moduleName);
                ++i;
            }
        }
        ValueInput list = input.childOrEmpty("modules");
        int count = list.getIntOr("count", 0);
        for (int i = 0; i < count; ++i) {
            String string = list.getStringOr(String.valueOf(i), "");
            if (string.isEmpty()) continue;
            moduleName = ResourceLocation.parse((String)string);
            names.add(moduleName);
        }
        if (!names.isEmpty()) {
            this.getCart().moduleLoadingData = names;
        }
        this.modules().clear();
        for (ResourceLocation resourceLocation : names) {
            this.doLoadModules(StevesCartsAPI.MODULE_REGISTRY.get(resourceLocation), null);
        }
        this.initModules();
        for (int i = 0; i < this.modules.size(); ++i) {
            ModuleBase moduleBase = this.modules.get(i);
            moduleBase.readFromNBT(list, i);
        }
    }

    public static Optional<BlockPos> readBlockPos(CompoundTag tag, String key) {
        int[] aint = tag.getIntArray(key).orElseGet(() -> new int[0]);
        return aint.length == 3 ? Optional.of(new BlockPos(aint[0], aint[1], aint[2])) : Optional.empty();
    }

    @Override
    public List<EntityData<?>> getEntityDataList() {
        return this.entityDataList;
    }

    @Override
    public void registerEntityData(EntityData<?> data) {
        this.entityDataList.add(data);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new ContainerMinecart(id, inventory, this);
    }

    protected void positionRider(Entity passenger, Entity.MoveFunction moveFunction) {
        Player player;
        super.positionRider(passenger, moveFunction);
        if (!this.level().isClientSide || !(passenger instanceof Player) || (player = (Player)passenger).shouldRotateWithMinecart()) {
            // empty if block
        }
    }
}

