/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.NewMinecartBehavior;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.blocks.BlockRailAdvDetector;
import vswe.stevescarts.entities.ModularMinecart;

public class ModularMinecartBehavior
extends NewMinecartBehavior {
    private final ModularMinecart minecart;

    public ModularMinecartBehavior(ModularMinecart minecart) {
        super((AbstractMinecart)minecart);
        this.minecart = minecart;
    }

    public void tick() {
        super.tick();
    }

    public void moveAlongTrack(ServerLevel serverLevel) {
        NewMinecartBehavior.TrackIteration newminecartbehavior$trackiteration = new NewMinecartBehavior.TrackIteration();
        while (newminecartbehavior$trackiteration.shouldIterate() && this.minecart.isAlive()) {
            Vec3 vec31;
            Vec3 vec3 = this.getDeltaMovement();
            BlockPos blockpos = this.minecart.getCurrentBlockPosOrRailBelow();
            BlockState blockstate = this.level().getBlockState(blockpos);
            boolean flag = BaseRailBlock.isRail((BlockState)blockstate);
            if (this.minecart.isOnRails() != flag) {
                this.minecart.setOnRails(flag);
                this.adjustToRails(blockpos, blockstate, false);
            }
            if (flag) {
                PoweredRailBlock poweredRail;
                this.minecart.resetFallDistance();
                this.minecart.setOldPosAndRot();
                Block block = blockstate.getBlock();
                if (block instanceof PoweredRailBlock && (poweredRail = (PoweredRailBlock)block).isActivatorRail()) {
                    this.minecart.activateMinecart(blockpos.getX(), blockpos.getY(), blockpos.getZ(), (Boolean)blockstate.getValue((Property)PoweredRailBlock.POWERED));
                }
                if (block instanceof BlockRailAdvDetector) {
                    BlockRailAdvDetector advDetector = (BlockRailAdvDetector)block;
                    advDetector.onMinecartPassSC(blockstate, (Level)serverLevel, blockpos, this.minecart);
                }
                this.minecart.handleMoveAlongTrack(blockpos, blockstate);
                RailShape railshape = ((BaseRailBlock)blockstate.getBlock()).getRailDirection(blockstate, (BlockGetter)this.level(), blockpos, (AbstractMinecart)this.minecart);
                vec31 = this.calculateTrackSpeed(serverLevel, vec3.horizontal(), newminecartbehavior$trackiteration, blockpos, blockstate, railshape);
                newminecartbehavior$trackiteration.movementLeft = newminecartbehavior$trackiteration.firstIteration ? vec31.horizontalDistance() : (newminecartbehavior$trackiteration.movementLeft += vec31.horizontalDistance() - vec3.horizontalDistance());
                this.setDeltaMovement(vec31);
                newminecartbehavior$trackiteration.movementLeft = this.minecart.makeStepAlongTrack(blockpos, railshape, newminecartbehavior$trackiteration.movementLeft);
            } else {
                this.minecart.comeOffTrack(serverLevel);
                newminecartbehavior$trackiteration.movementLeft = 0.0;
            }
            Vec3 vec32 = this.position();
            vec31 = vec32.subtract(this.minecart.oldPosition());
            double d0 = vec31.length();
            if (d0 > (double)1.0E-5f) {
                if (!(vec31.horizontalDistanceSqr() > (double)1.0E-5f)) {
                    if (!this.minecart.isOnRails()) {
                        this.setXRot(this.minecart.onGround() ? 0.0f : Mth.rotLerp((float)0.2f, (float)this.getXRot(), (float)0.0f));
                    }
                } else {
                    float f = 180.0f - (float)(Math.atan2(vec31.z, vec31.x) * 180.0 / Math.PI);
                    float f1 = this.minecart.onGround() && !this.minecart.isOnRails() ? 0.0f : 90.0f - (float)(Math.atan2(vec31.horizontalDistance(), vec31.y) * 180.0 / Math.PI);
                    this.setRotation(f += this.minecart.isFlipped() ? 180.0f : 0.0f, f1 *= this.minecart.isFlipped() ? -1.0f : 1.0f);
                }
                this.lerpSteps.add(new NewMinecartBehavior.MinecartStep(vec32, this.getDeltaMovement(), this.getYRot(), this.getXRot(), (float)Math.min(d0, this.getMaxSpeed(serverLevel))));
            } else if (vec3.horizontalDistanceSqr() > 0.0) {
                this.lerpSteps.add(new NewMinecartBehavior.MinecartStep(vec32, this.getDeltaMovement(), this.getYRot(), this.getXRot(), 1.0f));
            }
            if (d0 > (double)1.0E-5f || newminecartbehavior$trackiteration.firstIteration) {
                this.minecart.applyEffectsFromBlocks();
                this.minecart.applyEffectsFromBlocks();
            }
            newminecartbehavior$trackiteration.firstIteration = false;
        }
    }

    public double getMaxSpeed(ServerLevel level) {
        double maxSpeed = this.minecart.isInWater() ? 0.2 : 0.4;
        return Math.min(maxSpeed, this.minecart.modules().stream().mapToDouble(ModuleBase::getMaxSpeed).min().orElse(maxSpeed));
    }
}

