/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.helpers;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;

public class RecipeHelper {
    private static final Map<RecipeType<?>, RecipeManager.CachedCheck<?, ?>> CACHES = new HashMap();

    public static Optional<RecipeHolder<SmeltingRecipe>> findSmeltRecipe(ItemStack stack, ServerLevel level) {
        return RecipeHelper.findRecipe(RecipeType.SMELTING, new SingleRecipeInput(stack), level);
    }

    public static <I extends RecipeInput, T extends Recipe<I>> Optional<RecipeHolder<T>> findRecipe(RecipeType<T> type, I input, ServerLevel level) {
        RecipeManager.CachedCheck cache = CACHES.computeIfAbsent(type, recipeType -> RecipeManager.createCheck((RecipeType)type));
        return cache.getRecipeFor(input, level);
    }
}

